# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from suger_sdk_python.models.azure_included_base_quantity import AzureIncludedBaseQuantity
from suger_sdk_python.models.gcp_price_tier import GcpPriceTier
from suger_sdk_python.models.usage_count import UsageCount
from suger_sdk_python.models.value_type import ValueType
from typing import Optional, Set
from typing_extensions import Self

class MeteringDimension(BaseModel):
    """
    The dimension to meter usage in entitlement.
    """ # noqa: E501
    category: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    included_base_quantities: Optional[List[AzureIncludedBaseQuantity]] = Field(default=None, description="how many quantities of this dimension are included in the commit.", alias="includedBaseQuantities")
    key: Optional[StrictStr] = None
    name: Optional[StrictStr] = Field(default=None, description="Display name of the dimension. For GCP Marketplace, it is the metering metric ID without plan prefix.")
    plan_id: Optional[StrictStr] = Field(default=None, description="The plan ID of the metering dimension. Applicable to GCP Marketplace only. No ISO duration suffix.", alias="planId")
    plan_name: Optional[StrictStr] = Field(default=None, description="The name of the plan for the metering dimension. Applicable to GCP Marketplace only. It may contains the ISO duration suffix, such as P1Y.", alias="planName")
    price_tiers: Optional[List[GcpPriceTier]] = Field(default=None, description="The price tiers of the metering dimension. Applicable to GCP Marketplace only.", alias="priceTiers")
    rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The unit price of this usage metering dimension.")
    sku_id: Optional[StrictStr] = Field(default=None, description="The SKU ID of the metering dimension. Applicable to GCP Marketplace only.", alias="skuId")
    types: Optional[List[StrictStr]] = None
    usage_count: Optional[UsageCount] = Field(default=None, description="The current Dimension Usage Count. Available when call GetEntitlement API.", alias="usageCount")
    value_type: Optional[ValueType] = Field(default=None, description="The value type of the metering dimension quantity. Applicable to GCP Marketplace only.", alias="valueType")
    __properties: ClassVar[List[str]] = ["category", "description", "includedBaseQuantities", "key", "name", "planId", "planName", "priceTiers", "rate", "skuId", "types", "usageCount", "valueType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MeteringDimension from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in included_base_quantities (list)
        _items = []
        if self.included_base_quantities:
            for _item_included_base_quantities in self.included_base_quantities:
                if _item_included_base_quantities:
                    _items.append(_item_included_base_quantities.to_dict())
            _dict['includedBaseQuantities'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in price_tiers (list)
        _items = []
        if self.price_tiers:
            for _item_price_tiers in self.price_tiers:
                if _item_price_tiers:
                    _items.append(_item_price_tiers.to_dict())
            _dict['priceTiers'] = _items
        # override the default output from pydantic by calling `to_dict()` of usage_count
        if self.usage_count:
            _dict['usageCount'] = self.usage_count.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MeteringDimension from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "category": obj.get("category"),
            "description": obj.get("description"),
            "includedBaseQuantities": [AzureIncludedBaseQuantity.from_dict(_item) for _item in obj["includedBaseQuantities"]] if obj.get("includedBaseQuantities") is not None else None,
            "key": obj.get("key"),
            "name": obj.get("name"),
            "planId": obj.get("planId"),
            "planName": obj.get("planName"),
            "priceTiers": [GcpPriceTier.from_dict(_item) for _item in obj["priceTiers"]] if obj.get("priceTiers") is not None else None,
            "rate": obj.get("rate"),
            "skuId": obj.get("skuId"),
            "types": obj.get("types"),
            "usageCount": UsageCount.from_dict(obj["usageCount"]) if obj.get("usageCount") is not None else None,
            "valueType": obj.get("valueType")
        })
        return _obj


