# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from suger_sdk_python.models.metering_usage_record_group_meta_info import MeteringUsageRecordGroupMetaInfo
from typing import Optional, Set
from typing_extensions import Self

class MeteringUsageRecordGroup(BaseModel):
    """
    MeteringUsageRecordGroup
    """ # noqa: E501
    buyer_id: Optional[StrictStr] = Field(default=None, alias="buyerID")
    creation_time: Optional[datetime] = Field(default=None, alias="creationTime")
    entitlement_id: Optional[StrictStr] = Field(default=None, alias="entitlementID")
    id: Optional[StrictStr] = None
    last_update_time: Optional[datetime] = Field(default=None, alias="lastUpdateTime")
    meta_info: Optional[MeteringUsageRecordGroupMetaInfo] = Field(default=None, alias="metaInfo")
    organization_id: Optional[StrictStr] = Field(default=None, alias="organizationID")
    partner: Optional[StrictStr] = None
    records: Optional[Dict[str, Union[StrictFloat, StrictInt]]] = None
    serial_id: Optional[StrictInt] = Field(default=None, alias="serialID")
    status: Optional[StrictStr] = None
    usage_record_report_id: Optional[StrictStr] = Field(default=None, alias="usageRecordReportID")
    __properties: ClassVar[List[str]] = ["buyerID", "creationTime", "entitlementID", "id", "lastUpdateTime", "metaInfo", "organizationID", "partner", "records", "serialID", "status", "usageRecordReportID"]

    @field_validator('partner')
    def partner_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['AWS', 'AZURE', 'GCP']):
            raise ValueError("must be one of enum values ('AWS', 'AZURE', 'GCP')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MeteringUsageRecordGroup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of meta_info
        if self.meta_info:
            _dict['metaInfo'] = self.meta_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MeteringUsageRecordGroup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "buyerID": obj.get("buyerID"),
            "creationTime": obj.get("creationTime"),
            "entitlementID": obj.get("entitlementID"),
            "id": obj.get("id"),
            "lastUpdateTime": obj.get("lastUpdateTime"),
            "metaInfo": MeteringUsageRecordGroupMetaInfo.from_dict(obj["metaInfo"]) if obj.get("metaInfo") is not None else None,
            "organizationID": obj.get("organizationID"),
            "partner": obj.get("partner"),
            "records": obj.get("records"),
            "serialID": obj.get("serialID"),
            "status": obj.get("status"),
            "usageRecordReportID": obj.get("usageRecordReportID")
        })
        return _obj


