# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from suger_sdk_python.models.metering_usage_record import MeteringUsageRecord
from suger_sdk_python.models.usage_record_group_source import UsageRecordGroupSource
from typing import Optional, Set
from typing_extensions import Self

class MeteringUsageRecordGroupMetaInfo(BaseModel):
    """
    MeteringUsageRecordGroupMetaInfo
    """ # noqa: E501
    skip_validation: Optional[StrictBool] = Field(default=None, description="If it is true, the validation of the usage record group is skipped.", alias="SkipValidation")
    billable_records: Optional[List[MeteringUsageRecord]] = Field(default=None, description="for usage metering API v2", alias="billableRecords")
    lago_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The lago amount (in dollars) of the customer. This field keeps the largest of the monthly amount. So it can only be updated when the invoice month increases.", alias="lagoAmount")
    lago_subscription_id: Optional[StrictStr] = Field(default=None, description="The lago subscription ID of the customer.", alias="lagoSubscriptionID")
    lago_usage_start_time: Optional[datetime] = Field(default=None, description="The lago usage start time of the customer usage.", alias="lagoUsageStartTime")
    metronome_daily_cost_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The metronome daily cost amount (in dollars) of the customer.", alias="metronomeDailyCostAmount")
    metronome_invoice_id: Optional[StrictStr] = Field(default=None, description="The metronome invoice ID of the customer.", alias="metronomeInvoiceID")
    metronome_monthly_invoice_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The metronome monthly invoice amount (in dollars) of the customer. This field keeps the largest amount of the invoice month. So it can only be updated when the invoice month increases.", alias="metronomeMonthlyInvoiceAmount")
    metronome_monthly_invoice_amount_adjusted: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The metronome monthly invoice amount (in dollars) of the customer, which is adjusted by the seller. This field is populated only when the invoice amount is decreased by the seller via credit granting.", alias="metronomeMonthlyInvoiceAmountAdjusted")
    origin_records: Optional[Dict[str, Union[StrictFloat, StrictInt]]] = Field(default=None, description="The original records reported by the customer before convertion. If no dimension mapping is applied, this field is the same as the records field.", alias="originRecords")
    source: Optional[UsageRecordGroupSource] = Field(default=None, description="The source of the usage record group. Can be from Suger API or other third party services, such as Metronome.")
    timestamp: Optional[datetime] = Field(default=None, description="The timestamp (UTC)) of when the usage records were generated. Optional, if not provided, the current report timestamp will be used.")
    __properties: ClassVar[List[str]] = ["SkipValidation", "billableRecords", "lagoAmount", "lagoSubscriptionID", "lagoUsageStartTime", "metronomeDailyCostAmount", "metronomeInvoiceID", "metronomeMonthlyInvoiceAmount", "metronomeMonthlyInvoiceAmountAdjusted", "originRecords", "source", "timestamp"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MeteringUsageRecordGroupMetaInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in billable_records (list)
        _items = []
        if self.billable_records:
            for _item_billable_records in self.billable_records:
                if _item_billable_records:
                    _items.append(_item_billable_records.to_dict())
            _dict['billableRecords'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MeteringUsageRecordGroupMetaInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "SkipValidation": obj.get("SkipValidation"),
            "billableRecords": [MeteringUsageRecord.from_dict(_item) for _item in obj["billableRecords"]] if obj.get("billableRecords") is not None else None,
            "lagoAmount": obj.get("lagoAmount"),
            "lagoSubscriptionID": obj.get("lagoSubscriptionID"),
            "lagoUsageStartTime": obj.get("lagoUsageStartTime"),
            "metronomeDailyCostAmount": obj.get("metronomeDailyCostAmount"),
            "metronomeInvoiceID": obj.get("metronomeInvoiceID"),
            "metronomeMonthlyInvoiceAmount": obj.get("metronomeMonthlyInvoiceAmount"),
            "metronomeMonthlyInvoiceAmountAdjusted": obj.get("metronomeMonthlyInvoiceAmountAdjusted"),
            "originRecords": obj.get("originRecords"),
            "source": obj.get("source"),
            "timestamp": obj.get("timestamp")
        })
        return _obj


