# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from suger_sdk_python.models.aws_channel_partner import AwsChannelPartner
from suger_sdk_python.models.aws_marketplace_cppo_opportunity import AwsMarketplaceCppoOpportunity
from suger_sdk_python.models.aws_marketplace_event_bridge_event_detail import AwsMarketplaceEventBridgeEventDetail
from suger_sdk_python.models.azure_audience import AzureAudience
from suger_sdk_python.models.azure_marketplace_price_and_availability_private_offer_plan import AzureMarketplacePriceAndAvailabilityPrivateOfferPlan
from suger_sdk_python.models.azure_marketplace_private_offer import AzureMarketplacePrivateOffer
from suger_sdk_python.models.azure_product_variant import AzureProductVariant
from suger_sdk_python.models.billable_dimension import BillableDimension
from suger_sdk_python.models.billing_cycle import BillingCycle
from suger_sdk_python.models.commit_dimension import CommitDimension
from suger_sdk_python.models.eula_type import EulaType
from suger_sdk_python.models.gcp_marketplace_private_offer import GcpMarketplacePrivateOffer
from suger_sdk_python.models.gcp_marketplace_private_offer_customer_info import GcpMarketplacePrivateOfferCustomerInfo
from suger_sdk_python.models.gcp_marketplace_private_offer_provider_info import GcpMarketplacePrivateOfferProviderInfo
from suger_sdk_python.models.gcp_marketplace_product_metering_metric import GcpMarketplaceProductMeteringMetric
from suger_sdk_python.models.gcp_marketplace_product_purchase_option_spec import GcpMarketplaceProductPurchaseOptionSpec
from suger_sdk_python.models.gcp_marketplace_reseller_private_offer_plan import GcpMarketplaceResellerPrivateOfferPlan
from suger_sdk_python.models.gcp_marketplace_usage_plan_price_model import GcpMarketplaceUsagePlanPriceModel
from suger_sdk_python.models.metering_dimension import MeteringDimension
from suger_sdk_python.models.payment_installment import PaymentInstallment
from suger_sdk_python.models.payment_schedule_type import PaymentScheduleType
from suger_sdk_python.models.trial_config import TrialConfig
from typing import Optional, Set
from typing_extensions import Self

class OfferInfo(BaseModel):
    """
    OfferInfo
    """ # noqa: E501
    additional_eula_urls: Optional[List[StrictStr]] = Field(default=None, description="The URL of the additional EULA files. Only applicable when EulaType = CUSTOM. The additional EULA files will be attached to the EULA file in the EulaUrl, and form a single EULA file.", alias="additionalEulaUrls")
    additional_reseller_eula_urls: Optional[List[StrictStr]] = Field(default=None, description="The URL of the additional reseller EULA files. Only applicable when ResellerEulaType = CUSTOM.", alias="additionalResellerEulaUrls")
    attach_eula_type: Optional[EulaType] = Field(default=None, description="Attach the standard EULA file to the CUSTOM EULA file. Only applicable when EulaType = CUSTOM", alias="attachEulaType")
    auto_renew: Optional[StrictBool] = Field(default=None, description="Is this offer Auto Renew enabled.", alias="autoRenew")
    aws_agreement_duration: Optional[StrictStr] = Field(default=None, description="Aws private subscription offer Usage duration. ISO8601 format. P300D means the contract Usage start date At acceptance, and with duration 300 days.", alias="awsAgreementDuration")
    aws_channel_partner: Optional[AwsChannelPartner] = Field(default=None, description="The AWS channel partner (reseller), only applicable for AWS Marketplace CPPO_OUT or CPPO offers.", alias="awsChannelPartner")
    aws_cppo_event_detail: Optional[AwsMarketplaceEventBridgeEventDetail] = Field(default=None, description="AWS EventBridge Event, only applicable for AWS Marketplace CPPO offers.", alias="awsCppoEventDetail")
    aws_cppo_opportunity: Optional[AwsMarketplaceCppoOpportunity] = Field(default=None, description="AWS CPPO Opportunity, only applicable for AWS Marketplace CPPO_OUT or CPPO_IN offers.", alias="awsCppoOpportunity")
    aws_markup_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="AWS private reseller offer using markup percentage. 10.0 represent 10% partner margin.", alias="awsMarkupPercentage")
    aws_resale_authorization_id: Optional[StrictStr] = Field(default=None, description="AWS ResaleAuthorizationId(CPPO_IN offer id) for CPPO offers of the reseller.", alias="awsResaleAuthorizationId")
    azure_original_plan: Optional[AzureMarketplacePriceAndAvailabilityPrivateOfferPlan] = Field(default=None, description="The origin pricing of Azure plan. Only applicable for Azure Marketplace plans.", alias="azureOriginalPlan")
    azure_private_offer: Optional[AzureMarketplacePrivateOffer] = Field(default=None, description="The private offer for Azure Marketplace. Only applicable for Azure Marketplace private offers.", alias="azurePrivateOffer")
    azure_product_variant: Optional[AzureProductVariant] = Field(default=None, description="For Azure marketplace only.", alias="azureProductVariant")
    billable_dimensions: Optional[List[BillableDimension]] = Field(default=None, description="Usage based metering dimensions based on Billable Metrics, managed by Suger only.", alias="billableDimensions")
    billing_cycle: Optional[BillingCycle] = Field(default=None, description="Billing Cycle for the offer.", alias="billingCycle")
    buyer_aws_account_ids: Optional[List[StrictStr]] = Field(default=None, description="The buyers' AWS Account IDs of this offer.", alias="buyerAwsAccountIds")
    buyer_azure_tenants: Optional[List[AzureAudience]] = Field(default=None, description="The buyers' Azure tenants of this offer.", alias="buyerAzureTenants")
    commit_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The amount that the buyer has committed to pay, before discount if applicable. It can be monthly commitment or total commitment. For frontend display or analysis purposes, not used for billing.", alias="commitAmount")
    commit_billing_interval_in_months: Optional[StrictInt] = Field(default=None, description="Billing interval in months for commitDimensions", alias="commitBillingIntervalInMonths")
    commits: Optional[List[CommitDimension]] = Field(default=None, description="Recurring flat fee for the offer, managed by cloud marketplaces or Suger.")
    currency: Optional[StrictStr] = Field(default=None, description="The currency code of the offer. ISO 4217 format.")
    dimensions: Optional[List[MeteringDimension]] = Field(default=None, description="Usage based metering dimensions defined on cloud marketplaces, managed by Cloud marketplaces only.")
    discount_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The discount percentage off the original price. For example, 20 means 20% off. 0 means no discount. It can be discount off the commitment amount or discount off the usage price.", alias="discountPercentage")
    eula_type: Optional[EulaType] = Field(default=None, alias="eulaType")
    eula_url: Optional[StrictStr] = Field(default=None, alias="eulaUrl")
    gcp_customer_info: Optional[GcpMarketplacePrivateOfferCustomerInfo] = Field(default=None, description="Only required when creating GCP Marketplace private offer.", alias="gcpCustomerInfo")
    gcp_duration: Optional[StrictInt] = Field(default=None, description="The duration of the offer in months. Only required when creating GCP Marketplace private offer.", alias="gcpDuration")
    gcp_metrics: Optional[List[GcpMarketplaceProductMeteringMetric]] = Field(default=None, description="Only applicable for GCP Marketplace Offers (the default or private offer)", alias="gcpMetrics")
    gcp_payment_schedule: Optional[PaymentScheduleType] = Field(default=None, description="Only required when creating GCP Marketplace private offer, to specify the payment schedule for the private offer. TODO: It will be deprecated in the future and replaced by PaymentSchedule.", alias="gcpPaymentSchedule")
    gcp_plans: Optional[List[GcpMarketplaceProductPurchaseOptionSpec]] = Field(default=None, description="Only applicable for GCP Marketplace", alias="gcpPlans")
    gcp_private_offer: Optional[GcpMarketplacePrivateOffer] = Field(default=None, description="The private offer for GCP Marketplace. Only applicable for GCP Marketplace private offers.", alias="gcpPrivateOffer")
    gcp_provider_info: Optional[GcpMarketplacePrivateOfferProviderInfo] = Field(default=None, description="Only required when creating GCP Marketplace private offer.", alias="gcpProviderInfo")
    gcp_provider_internal_note: Optional[StrictStr] = Field(default=None, description="Optional when creating GCP Marketplace private offer. The internal note for the seller/ISV. It is only visible to the seller/ISV.", alias="gcpProviderInternalNote")
    gcp_provider_public_note: Optional[StrictStr] = Field(default=None, description="Optional when creating GCP Marketplace private offer. By default, it is the same as offer name. The public note for the buyer. It is visible to the buyer.", alias="gcpProviderPublicNote")
    gcp_reseller_private_offer_plan: Optional[GcpMarketplaceResellerPrivateOfferPlan] = Field(default=None, alias="gcpResellerPrivateOfferPlan")
    gcp_usage_plan_price_model: Optional[GcpMarketplaceUsagePlanPriceModel] = Field(default=None, description="Only applicable for GCP Marketplace with Usage plan. Not appliable for Subscription plan.", alias="gcpUsagePlanPriceModel")
    grace_period_in_days: Optional[StrictInt] = Field(default=None, description="The grace period in days for the offer. This is the number of days during which invoices remain in draft status, for reviewing. This filed can be overridden at the entitlement level.", alias="gracePeriodInDays")
    net_terms_in_days: Optional[StrictInt] = Field(default=None, description="The net terms in days for the offer. This is the number of days the buyer has to pay the invoice. This filed can be overridden at the entitlement level.", alias="netTermsInDays")
    payment_installments: Optional[List[PaymentInstallment]] = Field(default=None, description="For flexible payment schedule, managed by cloud marketplaces or Suger.", alias="paymentInstallments")
    payment_schedule: Optional[PaymentScheduleType] = Field(default=None, description="The payment schedule for the offer. PREPAY means the buyer pays before the service is provided. POSTPAY means the buyer pays after the service is provided.", alias="paymentSchedule")
    private_offer_url: Optional[StrictStr] = Field(default=None, description="The URL of the private offer sent to buyers to accept. Only applicable for private offer.", alias="privateOfferUrl")
    prorated_billing: Optional[StrictBool] = Field(default=None, description="Prorated billing for the offer. If true, the billing is prorated based on the start date and end date. If false, the billing is not prorated. This filed can be overridden at the entitlement level.", alias="proratedBilling")
    refund_cancellation_policy: Optional[StrictStr] = Field(default=None, alias="refundCancellationPolicy")
    reseller_attach_eula_type: Optional[EulaType] = Field(default=None, description="Attach the standard EULA file to the CUSTOM EULA file. Only applicable when EulaType = CUSTOM", alias="resellerAttachEulaType")
    reseller_eula_type: Optional[EulaType] = Field(default=None, description="The type of the reseller EULA. Only applicable for CPPO offers.", alias="resellerEulaType")
    reseller_eula_url: Optional[StrictStr] = Field(default=None, alias="resellerEulaUrl")
    seller_notes: Optional[StrictStr] = Field(default=None, alias="sellerNotes")
    start_time: Optional[datetime] = Field(default=None, description="Optional when creating AWS or GCP Marketplace private offer on the contract product. The future start time of the offer if it is not started on the acceptance.", alias="startTime")
    tax_ids: Optional[List[StrictStr]] = Field(default=None, description="Tax ids for the offer, used to calculate the tax amount for the offer. This field can be overridden at the entitlement level.", alias="taxIds")
    trial_config: Optional[TrialConfig] = Field(default=None, description="The offer for Direct. Only applicable for Direct offers. It is used in Stripe, Adyen, and other direct payment providers. The trial configuration for the offer.", alias="trialConfig")
    usage_billing_interval_in_months: Optional[StrictInt] = Field(default=None, description="Billing interval in months for billableDimensions", alias="usageBillingIntervalInMonths")
    visibility: Optional[StrictStr] = Field(default=None, description="The default visibility of offer is PRIVATE.")
    __properties: ClassVar[List[str]] = ["additionalEulaUrls", "additionalResellerEulaUrls", "attachEulaType", "autoRenew", "awsAgreementDuration", "awsChannelPartner", "awsCppoEventDetail", "awsCppoOpportunity", "awsMarkupPercentage", "awsResaleAuthorizationId", "azureOriginalPlan", "azurePrivateOffer", "azureProductVariant", "billableDimensions", "billingCycle", "buyerAwsAccountIds", "buyerAzureTenants", "commitAmount", "commitBillingIntervalInMonths", "commits", "currency", "dimensions", "discountPercentage", "eulaType", "eulaUrl", "gcpCustomerInfo", "gcpDuration", "gcpMetrics", "gcpPaymentSchedule", "gcpPlans", "gcpPrivateOffer", "gcpProviderInfo", "gcpProviderInternalNote", "gcpProviderPublicNote", "gcpResellerPrivateOfferPlan", "gcpUsagePlanPriceModel", "gracePeriodInDays", "netTermsInDays", "paymentInstallments", "paymentSchedule", "privateOfferUrl", "proratedBilling", "refundCancellationPolicy", "resellerAttachEulaType", "resellerEulaType", "resellerEulaUrl", "sellerNotes", "startTime", "taxIds", "trialConfig", "usageBillingIntervalInMonths", "visibility"]

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PRIVATE', 'PUBLIC']):
            raise ValueError("must be one of enum values ('PRIVATE', 'PUBLIC')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OfferInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of aws_channel_partner
        if self.aws_channel_partner:
            _dict['awsChannelPartner'] = self.aws_channel_partner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of aws_cppo_event_detail
        if self.aws_cppo_event_detail:
            _dict['awsCppoEventDetail'] = self.aws_cppo_event_detail.to_dict()
        # override the default output from pydantic by calling `to_dict()` of aws_cppo_opportunity
        if self.aws_cppo_opportunity:
            _dict['awsCppoOpportunity'] = self.aws_cppo_opportunity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of azure_original_plan
        if self.azure_original_plan:
            _dict['azureOriginalPlan'] = self.azure_original_plan.to_dict()
        # override the default output from pydantic by calling `to_dict()` of azure_private_offer
        if self.azure_private_offer:
            _dict['azurePrivateOffer'] = self.azure_private_offer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of azure_product_variant
        if self.azure_product_variant:
            _dict['azureProductVariant'] = self.azure_product_variant.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in billable_dimensions (list)
        _items = []
        if self.billable_dimensions:
            for _item_billable_dimensions in self.billable_dimensions:
                if _item_billable_dimensions:
                    _items.append(_item_billable_dimensions.to_dict())
            _dict['billableDimensions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in buyer_azure_tenants (list)
        _items = []
        if self.buyer_azure_tenants:
            for _item_buyer_azure_tenants in self.buyer_azure_tenants:
                if _item_buyer_azure_tenants:
                    _items.append(_item_buyer_azure_tenants.to_dict())
            _dict['buyerAzureTenants'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in commits (list)
        _items = []
        if self.commits:
            for _item_commits in self.commits:
                if _item_commits:
                    _items.append(_item_commits.to_dict())
            _dict['commits'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in dimensions (list)
        _items = []
        if self.dimensions:
            for _item_dimensions in self.dimensions:
                if _item_dimensions:
                    _items.append(_item_dimensions.to_dict())
            _dict['dimensions'] = _items
        # override the default output from pydantic by calling `to_dict()` of gcp_customer_info
        if self.gcp_customer_info:
            _dict['gcpCustomerInfo'] = self.gcp_customer_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in gcp_metrics (list)
        _items = []
        if self.gcp_metrics:
            for _item_gcp_metrics in self.gcp_metrics:
                if _item_gcp_metrics:
                    _items.append(_item_gcp_metrics.to_dict())
            _dict['gcpMetrics'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in gcp_plans (list)
        _items = []
        if self.gcp_plans:
            for _item_gcp_plans in self.gcp_plans:
                if _item_gcp_plans:
                    _items.append(_item_gcp_plans.to_dict())
            _dict['gcpPlans'] = _items
        # override the default output from pydantic by calling `to_dict()` of gcp_private_offer
        if self.gcp_private_offer:
            _dict['gcpPrivateOffer'] = self.gcp_private_offer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gcp_provider_info
        if self.gcp_provider_info:
            _dict['gcpProviderInfo'] = self.gcp_provider_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gcp_reseller_private_offer_plan
        if self.gcp_reseller_private_offer_plan:
            _dict['gcpResellerPrivateOfferPlan'] = self.gcp_reseller_private_offer_plan.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in payment_installments (list)
        _items = []
        if self.payment_installments:
            for _item_payment_installments in self.payment_installments:
                if _item_payment_installments:
                    _items.append(_item_payment_installments.to_dict())
            _dict['paymentInstallments'] = _items
        # override the default output from pydantic by calling `to_dict()` of trial_config
        if self.trial_config:
            _dict['trialConfig'] = self.trial_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OfferInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "additionalEulaUrls": obj.get("additionalEulaUrls"),
            "additionalResellerEulaUrls": obj.get("additionalResellerEulaUrls"),
            "attachEulaType": obj.get("attachEulaType"),
            "autoRenew": obj.get("autoRenew"),
            "awsAgreementDuration": obj.get("awsAgreementDuration"),
            "awsChannelPartner": AwsChannelPartner.from_dict(obj["awsChannelPartner"]) if obj.get("awsChannelPartner") is not None else None,
            "awsCppoEventDetail": AwsMarketplaceEventBridgeEventDetail.from_dict(obj["awsCppoEventDetail"]) if obj.get("awsCppoEventDetail") is not None else None,
            "awsCppoOpportunity": AwsMarketplaceCppoOpportunity.from_dict(obj["awsCppoOpportunity"]) if obj.get("awsCppoOpportunity") is not None else None,
            "awsMarkupPercentage": obj.get("awsMarkupPercentage"),
            "awsResaleAuthorizationId": obj.get("awsResaleAuthorizationId"),
            "azureOriginalPlan": AzureMarketplacePriceAndAvailabilityPrivateOfferPlan.from_dict(obj["azureOriginalPlan"]) if obj.get("azureOriginalPlan") is not None else None,
            "azurePrivateOffer": AzureMarketplacePrivateOffer.from_dict(obj["azurePrivateOffer"]) if obj.get("azurePrivateOffer") is not None else None,
            "azureProductVariant": AzureProductVariant.from_dict(obj["azureProductVariant"]) if obj.get("azureProductVariant") is not None else None,
            "billableDimensions": [BillableDimension.from_dict(_item) for _item in obj["billableDimensions"]] if obj.get("billableDimensions") is not None else None,
            "billingCycle": obj.get("billingCycle"),
            "buyerAwsAccountIds": obj.get("buyerAwsAccountIds"),
            "buyerAzureTenants": [AzureAudience.from_dict(_item) for _item in obj["buyerAzureTenants"]] if obj.get("buyerAzureTenants") is not None else None,
            "commitAmount": obj.get("commitAmount"),
            "commitBillingIntervalInMonths": obj.get("commitBillingIntervalInMonths"),
            "commits": [CommitDimension.from_dict(_item) for _item in obj["commits"]] if obj.get("commits") is not None else None,
            "currency": obj.get("currency"),
            "dimensions": [MeteringDimension.from_dict(_item) for _item in obj["dimensions"]] if obj.get("dimensions") is not None else None,
            "discountPercentage": obj.get("discountPercentage"),
            "eulaType": obj.get("eulaType"),
            "eulaUrl": obj.get("eulaUrl"),
            "gcpCustomerInfo": GcpMarketplacePrivateOfferCustomerInfo.from_dict(obj["gcpCustomerInfo"]) if obj.get("gcpCustomerInfo") is not None else None,
            "gcpDuration": obj.get("gcpDuration"),
            "gcpMetrics": [GcpMarketplaceProductMeteringMetric.from_dict(_item) for _item in obj["gcpMetrics"]] if obj.get("gcpMetrics") is not None else None,
            "gcpPaymentSchedule": obj.get("gcpPaymentSchedule"),
            "gcpPlans": [GcpMarketplaceProductPurchaseOptionSpec.from_dict(_item) for _item in obj["gcpPlans"]] if obj.get("gcpPlans") is not None else None,
            "gcpPrivateOffer": GcpMarketplacePrivateOffer.from_dict(obj["gcpPrivateOffer"]) if obj.get("gcpPrivateOffer") is not None else None,
            "gcpProviderInfo": GcpMarketplacePrivateOfferProviderInfo.from_dict(obj["gcpProviderInfo"]) if obj.get("gcpProviderInfo") is not None else None,
            "gcpProviderInternalNote": obj.get("gcpProviderInternalNote"),
            "gcpProviderPublicNote": obj.get("gcpProviderPublicNote"),
            "gcpResellerPrivateOfferPlan": GcpMarketplaceResellerPrivateOfferPlan.from_dict(obj["gcpResellerPrivateOfferPlan"]) if obj.get("gcpResellerPrivateOfferPlan") is not None else None,
            "gcpUsagePlanPriceModel": obj.get("gcpUsagePlanPriceModel"),
            "gracePeriodInDays": obj.get("gracePeriodInDays"),
            "netTermsInDays": obj.get("netTermsInDays"),
            "paymentInstallments": [PaymentInstallment.from_dict(_item) for _item in obj["paymentInstallments"]] if obj.get("paymentInstallments") is not None else None,
            "paymentSchedule": obj.get("paymentSchedule"),
            "privateOfferUrl": obj.get("privateOfferUrl"),
            "proratedBilling": obj.get("proratedBilling"),
            "refundCancellationPolicy": obj.get("refundCancellationPolicy"),
            "resellerAttachEulaType": obj.get("resellerAttachEulaType"),
            "resellerEulaType": obj.get("resellerEulaType"),
            "resellerEulaUrl": obj.get("resellerEulaUrl"),
            "sellerNotes": obj.get("sellerNotes"),
            "startTime": obj.get("startTime"),
            "taxIds": obj.get("taxIds"),
            "trialConfig": TrialConfig.from_dict(obj["trialConfig"]) if obj.get("trialConfig") is not None else None,
            "usageBillingIntervalInMonths": obj.get("usageBillingIntervalInMonths"),
            "visibility": obj.get("visibility")
        })
        return _obj


