# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.partner import Partner
from suger_sdk_python.models.usage_metering_dimension_mapping_value import UsageMeteringDimensionMappingValue
from typing import Optional, Set
from typing_extensions import Self

class PartnerUsageMeteringConfig(BaseModel):
    """
    PartnerUsageMeteringConfig
    """ # noqa: E501
    dimension_mapping: Optional[Dict[str, UsageMeteringDimensionMappingValue]] = Field(default=None, description="Deprecated: Use DimensionMappingV2 instead. The mapping of the source dimension key to the destination dimension key of the usage metering.", alias="dimensionMapping")
    dimension_mapping_v2: Optional[Dict[str, List[UsageMeteringDimensionMappingValue]]] = Field(default=None, description="The mapping of the source dimension key to the destination dimension keys of the usage metering. The destination dimension keys are the list of the destination dimension keys. So the source dimension key can be mapped to multiple destination dimension keys.", alias="dimensionMappingV2")
    enable_billable_dimension: Optional[StrictBool] = Field(default=None, alias="enableBillableDimension")
    enable_commit_with_additional_usage_at_list_price: Optional[StrictBool] = Field(default=None, description="Enable the commit (discount) with additional usage metering at list price. Only applicable if EnableCommitWithAdditionalUsageMetering is true. The default is false, which means the commit with additional usage metering at the discounted price in the private offer. If set to true, the additional usage is metered at the list price (the price in public product listing) instead of the discounted price.", alias="enableCommitWithAdditionalUsageAtListPrice")
    enable_commit_with_additional_usage_metering: Optional[StrictBool] = Field(default=None, description="Enable the commit with additional usage metering. The default is false, which means all usage records are reported to partner no matter how much is the commit. If set to true, the usage records will be reported to partner only if the current commit has been exhausted.", alias="enableCommitWithAdditionalUsageMetering")
    enable_dimension_mapping: Optional[StrictBool] = Field(default=None, description="Enable the dimension mapping for the usage metering. The default is false, which means no dimension conversion and just use the origin dimension.", alias="enableDimensionMapping")
    partner: Optional[Partner] = Field(default=None, description="The partner in this dimension mapping. Required. Such as AWS, AZURE or GCP.")
    __properties: ClassVar[List[str]] = ["dimensionMapping", "dimensionMappingV2", "enableBillableDimension", "enableCommitWithAdditionalUsageAtListPrice", "enableCommitWithAdditionalUsageMetering", "enableDimensionMapping", "partner"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PartnerUsageMeteringConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in dimension_mapping (dict)
        _field_dict = {}
        if self.dimension_mapping:
            for _key_dimension_mapping in self.dimension_mapping:
                if self.dimension_mapping[_key_dimension_mapping]:
                    _field_dict[_key_dimension_mapping] = self.dimension_mapping[_key_dimension_mapping].to_dict()
            _dict['dimensionMapping'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in dimension_mapping_v2 (dict of array)
        _field_dict_of_array = {}
        if self.dimension_mapping_v2:
            for _key_dimension_mapping_v2 in self.dimension_mapping_v2:
                if self.dimension_mapping_v2[_key_dimension_mapping_v2] is not None:
                    _field_dict_of_array[_key_dimension_mapping_v2] = [
                        _item.to_dict() for _item in self.dimension_mapping_v2[_key_dimension_mapping_v2]
                    ]
            _dict['dimensionMappingV2'] = _field_dict_of_array
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PartnerUsageMeteringConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dimensionMapping": dict(
                (_k, UsageMeteringDimensionMappingValue.from_dict(_v))
                for _k, _v in obj["dimensionMapping"].items()
            )
            if obj.get("dimensionMapping") is not None
            else None,
            "dimensionMappingV2": dict(
                (_k,
                        [UsageMeteringDimensionMappingValue.from_dict(_item) for _item in _v]
                        if _v is not None
                        else None
                )
                for _k, _v in obj.get("dimensionMappingV2", {}).items()
            ),
            "enableBillableDimension": obj.get("enableBillableDimension"),
            "enableCommitWithAdditionalUsageAtListPrice": obj.get("enableCommitWithAdditionalUsageAtListPrice"),
            "enableCommitWithAdditionalUsageMetering": obj.get("enableCommitWithAdditionalUsageMetering"),
            "enableDimensionMapping": obj.get("enableDimensionMapping"),
            "partner": obj.get("partner")
        })
        return _obj


