# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from suger_sdk_python.models.revenue_record_info import RevenueRecordInfo
from typing import Optional, Set
from typing_extensions import Self

class RevenueRecord(BaseModel):
    """
    RevenueRecord
    """ # noqa: E501
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The revenue amount for the revenue report")
    buyer_id: Optional[StrictStr] = Field(default=None, alias="buyerID")
    collectable_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The revenue amount that the seller/ISV can collect.", alias="collectableAmount")
    currency: Optional[StrictStr] = Field(default=None, description="The currency of the revenue in ISO 4217 format, such as \"USD\".")
    var_date: Optional[datetime] = Field(default=None, description="The date for the revenue report", alias="date")
    disburse_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="disburseAmount")
    disburse_date: Optional[datetime] = Field(default=None, alias="disburseDate")
    entitlement_id: Optional[StrictStr] = Field(default=None, alias="entitlementID")
    id: Optional[StrictStr] = None
    info: Optional[RevenueRecordInfo] = None
    invoice_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="invoiceAmount")
    invoice_date: Optional[datetime] = Field(default=None, alias="invoiceDate")
    organization_id: Optional[StrictStr] = Field(default=None, alias="organizationID")
    partner: Optional[StrictStr] = None
    payment_due_date: Optional[datetime] = Field(default=None, alias="paymentDueDate")
    product_id: Optional[StrictStr] = Field(default=None, alias="productID")
    refund_disburse_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="refundDisburseAmount")
    refund_disburse_date: Optional[datetime] = Field(default=None, alias="refundDisburseDate")
    refund_invoice_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="refundInvoiceAmount")
    refund_invoice_date: Optional[datetime] = Field(default=None, alias="refundInvoiceDate")
    tax_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="taxAmount")
    __properties: ClassVar[List[str]] = ["amount", "buyerID", "collectableAmount", "currency", "date", "disburseAmount", "disburseDate", "entitlementID", "id", "info", "invoiceAmount", "invoiceDate", "organizationID", "partner", "paymentDueDate", "productID", "refundDisburseAmount", "refundDisburseDate", "refundInvoiceAmount", "refundInvoiceDate", "taxAmount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RevenueRecord from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of info
        if self.info:
            _dict['info'] = self.info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RevenueRecord from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount": obj.get("amount"),
            "buyerID": obj.get("buyerID"),
            "collectableAmount": obj.get("collectableAmount"),
            "currency": obj.get("currency"),
            "date": obj.get("date"),
            "disburseAmount": obj.get("disburseAmount"),
            "disburseDate": obj.get("disburseDate"),
            "entitlementID": obj.get("entitlementID"),
            "id": obj.get("id"),
            "info": RevenueRecordInfo.from_dict(obj["info"]) if obj.get("info") is not None else None,
            "invoiceAmount": obj.get("invoiceAmount"),
            "invoiceDate": obj.get("invoiceDate"),
            "organizationID": obj.get("organizationID"),
            "partner": obj.get("partner"),
            "paymentDueDate": obj.get("paymentDueDate"),
            "productID": obj.get("productID"),
            "refundDisburseAmount": obj.get("refundDisburseAmount"),
            "refundDisburseDate": obj.get("refundDisburseDate"),
            "refundInvoiceAmount": obj.get("refundInvoiceAmount"),
            "refundInvoiceDate": obj.get("refundInvoiceDate"),
            "taxAmount": obj.get("taxAmount")
        })
        return _obj


