# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.github_com_sugerio_marketplace_service_rds_db_lib_billing_aws_billing_event import GithubComSugerioMarketplaceServiceRdsDbLibBillingAwsBillingEvent
from suger_sdk_python.models.github_com_sugerio_marketplace_service_rds_db_lib_billing_azure_cma_revenue import GithubComSugerioMarketplaceServiceRdsDbLibBillingAzureCmaRevenue
from suger_sdk_python.models.github_com_sugerio_marketplace_service_rds_db_lib_billing_gcp_charge_usage import GithubComSugerioMarketplaceServiceRdsDbLibBillingGcpChargeUsage
from typing import Optional, Set
from typing_extensions import Self

class RevenueRecordDetail(BaseModel):
    """
    RevenueRecordDetail
    """ # noqa: E501
    aws_revenue_record_detail: Optional[GithubComSugerioMarketplaceServiceRdsDbLibBillingAwsBillingEvent] = Field(default=None, description="For AWS Marketplace", alias="awsRevenueRecordDetail")
    azure_revenue_record_detail: Optional[GithubComSugerioMarketplaceServiceRdsDbLibBillingAzureCmaRevenue] = Field(default=None, description="For Azure Marketplace", alias="azureRevenueRecordDetail")
    gcp_revenue_record_detail: Optional[GithubComSugerioMarketplaceServiceRdsDbLibBillingGcpChargeUsage] = Field(default=None, description="For GCP Marketplace", alias="gcpRevenueRecordDetail")
    __properties: ClassVar[List[str]] = ["awsRevenueRecordDetail", "azureRevenueRecordDetail", "gcpRevenueRecordDetail"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RevenueRecordDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of aws_revenue_record_detail
        if self.aws_revenue_record_detail:
            _dict['awsRevenueRecordDetail'] = self.aws_revenue_record_detail.to_dict()
        # override the default output from pydantic by calling `to_dict()` of azure_revenue_record_detail
        if self.azure_revenue_record_detail:
            _dict['azureRevenueRecordDetail'] = self.azure_revenue_record_detail.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gcp_revenue_record_detail
        if self.gcp_revenue_record_detail:
            _dict['gcpRevenueRecordDetail'] = self.gcp_revenue_record_detail.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RevenueRecordDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "awsRevenueRecordDetail": GithubComSugerioMarketplaceServiceRdsDbLibBillingAwsBillingEvent.from_dict(obj["awsRevenueRecordDetail"]) if obj.get("awsRevenueRecordDetail") is not None else None,
            "azureRevenueRecordDetail": GithubComSugerioMarketplaceServiceRdsDbLibBillingAzureCmaRevenue.from_dict(obj["azureRevenueRecordDetail"]) if obj.get("azureRevenueRecordDetail") is not None else None,
            "gcpRevenueRecordDetail": GithubComSugerioMarketplaceServiceRdsDbLibBillingGcpChargeUsage.from_dict(obj["gcpRevenueRecordDetail"]) if obj.get("gcpRevenueRecordDetail") is not None else None
        })
        return _obj


