# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.revenue_record import RevenueRecord
from suger_sdk_python.models.revenue_report_type import RevenueReportType
from typing import Optional, Set
from typing_extensions import Self

class RevenueReport(BaseModel):
    """
    RevenueReport
    """ # noqa: E501
    buyer_id: Optional[StrictStr] = Field(default=None, alias="buyerID")
    entitlement_id: Optional[StrictStr] = Field(default=None, alias="entitlementID")
    organization_id: Optional[StrictStr] = Field(default=None, alias="organizationID")
    partner: Optional[StrictStr] = None
    product_id: Optional[StrictStr] = Field(default=None, alias="productID")
    report_date: Optional[datetime] = Field(default=None, alias="reportDate")
    report_type: Optional[RevenueReportType] = Field(default=None, alias="reportType")
    revenue_records: Optional[List[RevenueRecord]] = Field(default=None, alias="revenueRecords")
    service: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["buyerID", "entitlementID", "organizationID", "partner", "productID", "reportDate", "reportType", "revenueRecords", "service"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RevenueReport from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in revenue_records (list)
        _items = []
        if self.revenue_records:
            for _item_revenue_records in self.revenue_records:
                if _item_revenue_records:
                    _items.append(_item_revenue_records.to_dict())
            _dict['revenueRecords'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RevenueReport from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "buyerID": obj.get("buyerID"),
            "entitlementID": obj.get("entitlementID"),
            "organizationID": obj.get("organizationID"),
            "partner": obj.get("partner"),
            "productID": obj.get("productID"),
            "reportDate": obj.get("reportDate"),
            "reportType": obj.get("reportType"),
            "revenueRecords": [RevenueRecord.from_dict(_item) for _item in obj["revenueRecords"]] if obj.get("revenueRecords") is not None else None,
            "service": obj.get("service")
        })
        return _obj


