# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.servicecontrol_report_error import ServicecontrolReportError
from typing import Optional, Set
from typing_extensions import Self

class ServicecontrolReportResponse(BaseModel):
    """
    ServicecontrolReportResponse
    """ # noqa: E501
    report_errors: Optional[List[ServicecontrolReportError]] = Field(default=None, description="ReportErrors: Partial failures, one for each `Operation` in the request that failed processing. There are three possible combinations of the RPC status: 1. The combination of a successful RPC status and an empty `report_errors` list indicates a complete success where all `Operations` in the request are processed successfully. 2. The combination of a successful RPC status and a non-empty `report_errors` list indicates a partial success where some `Operations` in the request succeeded. Each `Operation` that failed processing has a corresponding item in this list. 3. A failed RPC status indicates a general non-deterministic failure. When this happens, it's impossible to know which of the 'Operations' in the request succeeded or failed.", alias="reportErrors")
    service_config_id: Optional[StrictStr] = Field(default=None, description="ServiceConfigId: The actual config id used to process the request.", alias="serviceConfigId")
    service_rollout_id: Optional[StrictStr] = Field(default=None, description="ServiceRolloutId: The current service rollout id used to process the request.", alias="serviceRolloutId")
    __properties: ClassVar[List[str]] = ["reportErrors", "serviceConfigId", "serviceRolloutId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ServicecontrolReportResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in report_errors (list)
        _items = []
        if self.report_errors:
            for _item_report_errors in self.report_errors:
                if _item_report_errors:
                    _items.append(_item_report_errors.to_dict())
            _dict['reportErrors'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ServicecontrolReportResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "reportErrors": [ServicecontrolReportError.from_dict(_item) for _item in obj["reportErrors"]] if obj.get("reportErrors") is not None else None,
            "serviceConfigId": obj.get("serviceConfigId"),
            "serviceRolloutId": obj.get("serviceRolloutId")
        })
        return _obj


