# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class StripeDispute(BaseModel):
    """
    StripeDispute
    """ # noqa: E501
    amount: Optional[StrictInt] = Field(default=None, description="Disputed amount. Usually the amount of the charge, but it can differ (usually because of currency fluctuation or because only part of the order is disputed).")
    charge_id: Optional[StrictStr] = Field(default=None, description="ID of the charge that's disputed.", alias="chargeId")
    created: Optional[StrictInt] = Field(default=None, description="Time at which the object was created. Measured in seconds since the Unix epoch.")
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the object.")
    is_charge_refundable: Optional[StrictBool] = Field(default=None, description="If true, it's still possible to refund the disputed payment. After the payment has been fully refunded, no further funds are withdrawn from your Stripe account as a result of this dispute.")
    livemode: Optional[StrictBool] = Field(default=None, description="Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.")
    payment_intent_id: Optional[StrictStr] = Field(default=None, description="ID of the PaymentIntent that's disputed.", alias="paymentIntentId")
    reason: Optional[StrictStr] = Field(default=None, description="Reason given by cardholder for dispute. Possible values are `bank_cannot_process`, `check_returned`, `credit_not_processed`, `customer_initiated`, `debit_not_authorized`, `duplicate`, `fraudulent`, `general`, `incorrect_account_details`, `insufficient_funds`, `product_not_received`, `product_unacceptable`, `subscription_canceled`, or `unrecognized`. Learn more about [dispute reasons](https://stripe.com/docs/disputes/categories).")
    status: Optional[StrictStr] = Field(default=None, description="Current status of dispute. Possible values are `warning_needs_response`, `warning_under_review`, `warning_closed`, `needs_response`, `under_review`, `won`, or `lost`.")
    __properties: ClassVar[List[str]] = ["amount", "chargeId", "created", "id", "is_charge_refundable", "livemode", "paymentIntentId", "reason", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StripeDispute from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StripeDispute from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount": obj.get("amount"),
            "chargeId": obj.get("chargeId"),
            "created": obj.get("created"),
            "id": obj.get("id"),
            "is_charge_refundable": obj.get("is_charge_refundable"),
            "livemode": obj.get("livemode"),
            "paymentIntentId": obj.get("paymentIntentId"),
            "reason": obj.get("reason"),
            "status": obj.get("status")
        })
        return _obj


