# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.stripe_error import StripeError
from suger_sdk_python.models.stripe_payment_intent_status import StripePaymentIntentStatus
from typing import Optional, Set
from typing_extensions import Self

class StripePaymentIntent(BaseModel):
    """
    StripePaymentIntent
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the object.")
    last_payment_error: Optional[StripeError] = Field(default=None, description="The payment error encountered in the previous PaymentIntent confirmation. It will be cleared if the PaymentIntent is later updated for any reason.")
    livemode: Optional[StrictBool] = Field(default=None, description="Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.")
    status: Optional[StripePaymentIntentStatus] = Field(default=None, description="Status of this PaymentIntent. Read more about each PaymentIntent [status](https://stripe.com/docs/payments/intents#intent-statuses).")
    __properties: ClassVar[List[str]] = ["id", "last_payment_error", "livemode", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StripePaymentIntent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of last_payment_error
        if self.last_payment_error:
            _dict['last_payment_error'] = self.last_payment_error.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StripePaymentIntent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "last_payment_error": StripeError.from_dict(obj["last_payment_error"]) if obj.get("last_payment_error") is not None else None,
            "livemode": obj.get("livemode"),
            "status": obj.get("status")
        })
        return _obj


