# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class StripePaymentMethodCard(BaseModel):
    """
    StripePaymentMethodCard
    """ # noqa: E501
    brand: Optional[StrictStr] = Field(default=None, description="Card brand.")
    country: Optional[StrictStr] = Field(default=None, description="Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.")
    display_brand: Optional[StrictStr] = Field(default=None, description="The brand to use when displaying the card, this accounts for customer's brand choice on dual-branded cards. Can be `american_express`, `cartes_bancaires`, `diners_club`, `discover`, `eftpos_australia`, `interac`, `jcb`, `mastercard`, `union_pay`, `visa`, or `other` and may contain more values in the future.")
    exp_month: Optional[StrictInt] = Field(default=None, description="Two-digit number representing the card's expiration month.")
    exp_year: Optional[StrictInt] = Field(default=None, description="Four-digit number representing the card's expiration year.")
    fingerprint: Optional[StrictStr] = Field(default=None, description="Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example. For payment methods that tokenize card information (Apple Pay, Google Pay), the tokenized number might be provided instead of the underlying card number.")
    funding: Optional[StrictStr] = Field(default=None, description="Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.")
    last4: Optional[StrictStr] = Field(default=None, description="The last four digits of the card.")
    __properties: ClassVar[List[str]] = ["brand", "country", "display_brand", "exp_month", "exp_year", "fingerprint", "funding", "last4"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StripePaymentMethodCard from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StripePaymentMethodCard from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "brand": obj.get("brand"),
            "country": obj.get("country"),
            "display_brand": obj.get("display_brand"),
            "exp_month": obj.get("exp_month"),
            "exp_year": obj.get("exp_year"),
            "fingerprint": obj.get("fingerprint"),
            "funding": obj.get("funding"),
            "last4": obj.get("last4")
        })
        return _obj


