# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class StripePaymentMethodUSBankAccount(BaseModel):
    """
    StripePaymentMethodUSBankAccount
    """ # noqa: E501
    account_holder_type: Optional[StrictStr] = Field(default=None, description="Account holder type: individual or company.")
    account_type: Optional[StrictStr] = Field(default=None, description="Account type: checkings or savings. Defaults to checking if omitted.")
    bank_name: Optional[StrictStr] = Field(default=None, description="The name of the bank.")
    fingerprint: Optional[StrictStr] = Field(default=None, description="Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.")
    last4: Optional[StrictStr] = Field(default=None, description="Last four digits of the bank account number.")
    routing_number: Optional[StrictStr] = Field(default=None, description="Routing number of the bank account.")
    __properties: ClassVar[List[str]] = ["account_holder_type", "account_type", "bank_name", "fingerprint", "last4", "routing_number"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StripePaymentMethodUSBankAccount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StripePaymentMethodUSBankAccount from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "account_holder_type": obj.get("account_holder_type"),
            "account_type": obj.get("account_type"),
            "bank_name": obj.get("bank_name"),
            "fingerprint": obj.get("fingerprint"),
            "last4": obj.get("last4"),
            "routing_number": obj.get("routing_number")
        })
        return _obj


