# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.stripe_product_marketing_feature import StripeProductMarketingFeature
from suger_sdk_python.models.stripe_product_package_dimensions import StripeProductPackageDimensions
from typing import Optional, Set
from typing_extensions import Self

class StripeProduct(BaseModel):
    """
    StripeProduct
    """ # noqa: E501
    active: Optional[StrictBool] = Field(default=None, description="Whether the product is currently available for purchase.")
    created: Optional[StrictInt] = Field(default=None, description="Time at which the object was created. Measured in seconds since the Unix epoch.")
    description: Optional[StrictStr] = Field(default=None, description="The product's description, meant to be displayable to the customer. Use this field to optionally store a long form explanation of the product being sold for your own rendering purposes.")
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the product in Stripe.")
    images: Optional[List[StrictStr]] = Field(default=None, description="A list of up to 8 URLs of images for this product, meant to be displayable to the customer.")
    livemode: Optional[StrictBool] = Field(default=None, description="Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.")
    marketing_features: Optional[List[StripeProductMarketingFeature]] = Field(default=None, description="A list of up to 15 marketing features for this product. These are displayed in [pricing tables](https://stripe.com/docs/payments/checkout/pricing-table).")
    metadata: Optional[Dict[str, StrictStr]] = Field(default=None, description="Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format.")
    name: Optional[StrictStr] = Field(default=None, description="The product's name, meant to be displayable to the customer.")
    object: Optional[StrictStr] = Field(default=None, description="String representing the object's type. Always has the value `product`.")
    package_dimensions: Optional[StripeProductPackageDimensions] = Field(default=None, description="The dimensions of this product for shipping purposes.")
    shippable: Optional[StrictBool] = Field(default=None, description="Whether this product is shipped (i.e., physical goods).")
    statement_descriptor: Optional[StrictStr] = Field(default=None, description="Extra information about a product which will appear on your customer's credit card statement. In the case that multiple products are billed at once, the first statement descriptor will be used.")
    tax_code: Optional[Dict[str, Any]] = Field(default=None, description="A [tax code](https://stripe.com/docs/tax/tax-categories) ID.")
    unit_label: Optional[StrictStr] = Field(default=None, description="A label that represents units of this product. When set, this will be included in customers' receipts, invoices, Checkout, and the customer portal.")
    updated: Optional[StrictInt] = Field(default=None, description="Time at which the product was last updated. Measured in seconds since the Unix epoch.")
    url: Optional[StrictStr] = Field(default=None, description="A URL of a publicly-accessible webpage for this product.")
    __properties: ClassVar[List[str]] = ["active", "created", "description", "id", "images", "livemode", "marketing_features", "metadata", "name", "object", "package_dimensions", "shippable", "statement_descriptor", "tax_code", "unit_label", "updated", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StripeProduct from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in marketing_features (list)
        _items = []
        if self.marketing_features:
            for _item_marketing_features in self.marketing_features:
                if _item_marketing_features:
                    _items.append(_item_marketing_features.to_dict())
            _dict['marketing_features'] = _items
        # override the default output from pydantic by calling `to_dict()` of package_dimensions
        if self.package_dimensions:
            _dict['package_dimensions'] = self.package_dimensions.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StripeProduct from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "active": obj.get("active"),
            "created": obj.get("created"),
            "description": obj.get("description"),
            "id": obj.get("id"),
            "images": obj.get("images"),
            "livemode": obj.get("livemode"),
            "marketing_features": [StripeProductMarketingFeature.from_dict(_item) for _item in obj["marketing_features"]] if obj.get("marketing_features") is not None else None,
            "metadata": obj.get("metadata"),
            "name": obj.get("name"),
            "object": obj.get("object"),
            "package_dimensions": StripeProductPackageDimensions.from_dict(obj["package_dimensions"]) if obj.get("package_dimensions") is not None else None,
            "shippable": obj.get("shippable"),
            "statement_descriptor": obj.get("statement_descriptor"),
            "tax_code": obj.get("tax_code"),
            "unit_label": obj.get("unit_label"),
            "updated": obj.get("updated"),
            "url": obj.get("url")
        })
        return _obj


