# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.support_ticket_attachment import SupportTicketAttachment
from suger_sdk_python.models.support_ticket_comment import SupportTicketComment
from suger_sdk_python.models.support_ticket_priority import SupportTicketPriority
from suger_sdk_python.models.support_ticket_status import SupportTicketStatus
from typing import Optional, Set
from typing_extensions import Self

class SupportTicket(BaseModel):
    """
    SupportTicket
    """ # noqa: E501
    attachments: Optional[List[SupportTicketAttachment]] = None
    close_time: Optional[StrictStr] = Field(default=None, alias="closeTime")
    comments: Optional[List[SupportTicketComment]] = None
    creation_time: Optional[StrictStr] = Field(default=None, alias="creationTime")
    creator: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    due_time: Optional[StrictStr] = Field(default=None, alias="dueTime")
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    organization_id: Optional[StrictStr] = Field(default=None, alias="organizationId")
    priority: Optional[SupportTicketPriority] = None
    status: Optional[SupportTicketStatus] = None
    watchers: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["attachments", "closeTime", "comments", "creationTime", "creator", "description", "dueTime", "id", "name", "organizationId", "priority", "status", "watchers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SupportTicket from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item_attachments in self.attachments:
                if _item_attachments:
                    _items.append(_item_attachments.to_dict())
            _dict['attachments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in comments (list)
        _items = []
        if self.comments:
            for _item_comments in self.comments:
                if _item_comments:
                    _items.append(_item_comments.to_dict())
            _dict['comments'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SupportTicket from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attachments": [SupportTicketAttachment.from_dict(_item) for _item in obj["attachments"]] if obj.get("attachments") is not None else None,
            "closeTime": obj.get("closeTime"),
            "comments": [SupportTicketComment.from_dict(_item) for _item in obj["comments"]] if obj.get("comments") is not None else None,
            "creationTime": obj.get("creationTime"),
            "creator": obj.get("creator"),
            "description": obj.get("description"),
            "dueTime": obj.get("dueTime"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "organizationId": obj.get("organizationId"),
            "priority": obj.get("priority"),
            "status": obj.get("status"),
            "watchers": obj.get("watchers")
        })
        return _obj


