# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.types_entitlement_value import TypesEntitlementValue
from typing import Optional, Set
from typing_extensions import Self

class TypesEntitlement(BaseModel):
    """
    TypesEntitlement
    """ # noqa: E501
    customer_identifier: Optional[StrictStr] = Field(default=None, description="The customer identifier is a handle to each unique customer in an application. Customer identifiers are obtained through the ResolveCustomer operation in AWS Marketplace Metering Service.", alias="customerIdentifier")
    dimension: Optional[StrictStr] = Field(default=None, description="The dimension for which the given entitlement applies. Dimensions represent categories of capacity in a product and are specified when the product is listed in AWS Marketplace.")
    expiration_date: Optional[StrictStr] = Field(default=None, description="The expiration date represents the minimum date through which this entitlement is expected to remain valid. For contractual products listed on AWS Marketplace, the expiration date is the date at which the customer will renew or cancel their contract. Customers who are opting to renew their contract will still have entitlements with an expiration date.", alias="expirationDate")
    product_code: Optional[StrictStr] = Field(default=None, description="The product code for which the given entitlement applies. Product codes are provided by AWS Marketplace when the product listing is created.", alias="productCode")
    value: Optional[TypesEntitlementValue] = Field(default=None, description="The EntitlementValue represents the amount of capacity that the customer is entitled to for the product.")
    __properties: ClassVar[List[str]] = ["customerIdentifier", "dimension", "expirationDate", "productCode", "value"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TypesEntitlement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of value
        if self.value:
            _dict['value'] = self.value.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TypesEntitlement from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "customerIdentifier": obj.get("customerIdentifier"),
            "dimension": obj.get("dimension"),
            "expirationDate": obj.get("expirationDate"),
            "productCode": obj.get("productCode"),
            "value": TypesEntitlementValue.from_dict(obj["value"]) if obj.get("value") is not None else None
        })
        return _obj


