# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.types_usage_record import TypesUsageRecord
from suger_sdk_python.models.types_usage_record_result_status import TypesUsageRecordResultStatus
from typing import Optional, Set
from typing_extensions import Self

class TypesUsageRecordResult(BaseModel):
    """
    TypesUsageRecordResult
    """ # noqa: E501
    metering_record_id: Optional[StrictStr] = Field(default=None, description="The MeteringRecordId is a unique identifier for this metering event.", alias="meteringRecordId")
    status: Optional[TypesUsageRecordResultStatus] = Field(default=None, description="The UsageRecordResult Status indicates the status of an individual UsageRecord processed by BatchMeterUsage .   - Success- The UsageRecord was accepted and honored by BatchMeterUsage .   - CustomerNotSubscribed- The CustomerIdentifier specified is not able to use   your product. The UsageRecord was not honored. There are three causes for this   result:   - The customer identifier is invalid.   - The customer identifier provided in the metering record does not have an   active agreement or subscription with this product. Future UsageRecords for   this customer will fail until the customer subscribes to your product.   - The customer's AWS account was suspended.   - DuplicateRecord- Indicates that the UsageRecord was invalid and not honored.   A previously metered UsageRecord had the same customer, dimension, and time,   but a different quantity.")
    usage_record: Optional[TypesUsageRecord] = Field(default=None, description="The UsageRecord that was part of the BatchMeterUsage request.", alias="usageRecord")
    __properties: ClassVar[List[str]] = ["meteringRecordId", "status", "usageRecord"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TypesUsageRecordResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of usage_record
        if self.usage_record:
            _dict['usageRecord'] = self.usage_record.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TypesUsageRecordResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "meteringRecordId": obj.get("meteringRecordId"),
            "status": obj.get("status"),
            "usageRecord": TypesUsageRecord.from_dict(obj["usageRecord"]) if obj.get("usageRecord") is not None else None
        })
        return _obj


