# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from suger_sdk_python.models.entitlement_info import EntitlementInfo
from suger_sdk_python.models.entitlement_term_info import EntitlementTermInfo
from suger_sdk_python.models.partner import Partner
from suger_sdk_python.models.partner_service import PartnerService
from typing import Optional, Set
from typing_extensions import Self

class WorkloadEntitlementTerm(BaseModel):
    """
    WorkloadEntitlementTerm
    """ # noqa: E501
    buyer_id: Optional[StrictStr] = Field(default=None, alias="buyerID")
    commit_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="commitAmount")
    credit_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="creditAmount")
    end_time: Optional[datetime] = Field(default=None, description="nullable", alias="endTime")
    entitlement_id: Optional[StrictStr] = Field(default=None, alias="entitlementID")
    entitlement_info: Optional[EntitlementInfo] = Field(default=None, alias="entitlementInfo")
    external_entitlement_id: Optional[StrictStr] = Field(default=None, alias="externalEntitlementID")
    id: Optional[StrictStr] = None
    info: Optional[EntitlementTermInfo] = None
    offer_id: Optional[StrictStr] = Field(default=None, alias="offerID")
    organization_id: Optional[StrictStr] = Field(default=None, alias="organizationID")
    partner: Optional[Partner] = None
    product_id: Optional[StrictStr] = Field(default=None, alias="productID")
    reported_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="reportedAmount")
    service: Optional[PartnerService] = None
    start_time: Optional[datetime] = Field(default=None, alias="startTime")
    used_commit_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="usedCommitAmount")
    used_credit_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="usedCreditAmount")
    __properties: ClassVar[List[str]] = ["buyerID", "commitAmount", "creditAmount", "endTime", "entitlementID", "entitlementInfo", "externalEntitlementID", "id", "info", "offerID", "organizationID", "partner", "productID", "reportedAmount", "service", "startTime", "usedCommitAmount", "usedCreditAmount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkloadEntitlementTerm from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of entitlement_info
        if self.entitlement_info:
            _dict['entitlementInfo'] = self.entitlement_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of info
        if self.info:
            _dict['info'] = self.info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkloadEntitlementTerm from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "buyerID": obj.get("buyerID"),
            "commitAmount": obj.get("commitAmount"),
            "creditAmount": obj.get("creditAmount"),
            "endTime": obj.get("endTime"),
            "entitlementID": obj.get("entitlementID"),
            "entitlementInfo": EntitlementInfo.from_dict(obj["entitlementInfo"]) if obj.get("entitlementInfo") is not None else None,
            "externalEntitlementID": obj.get("externalEntitlementID"),
            "id": obj.get("id"),
            "info": EntitlementTermInfo.from_dict(obj["info"]) if obj.get("info") is not None else None,
            "offerID": obj.get("offerID"),
            "organizationID": obj.get("organizationID"),
            "partner": obj.get("partner"),
            "productID": obj.get("productID"),
            "reportedAmount": obj.get("reportedAmount"),
            "service": obj.get("service"),
            "startTime": obj.get("startTime"),
            "usedCommitAmount": obj.get("usedCommitAmount"),
            "usedCreditAmount": obj.get("usedCreditAmount")
        })
        return _obj


