# coding: utf-8

"""
    Suger API

    CRUD operations on a set of resources, including organizations, products, offers, entitlements, usage record groups for meterting, etc.

    The version of the OpenAPI document: 1.0
    Contact: support@suger.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from suger_sdk_python.models.aws_product_dimension import AwsProductDimension
from suger_sdk_python.models.aws_renewal_offer_type import AwsRenewalOfferType
from suger_sdk_python.models.cancellation_schedule import CancellationSchedule
from suger_sdk_python.models.contact import Contact
from suger_sdk_python.models.last_modified_by import LastModifiedBy
from suger_sdk_python.models.notification_event import NotificationEvent
from typing import Optional, Set
from typing_extensions import Self

class WorkloadMetaInfo(BaseModel):
    """
    WorkloadMetaInfo
    """ # noqa: E501
    ace_apn_crm_unique_identifier: Optional[StrictStr] = Field(default=None, description="The linked ACE ApnCrmUniqueIdentifier of the private offer if available.", alias="aceApnCrmUniqueIdentifier")
    aws_saas_product_dimensions: Optional[List[AwsProductDimension]] = Field(default=None, description="The AWS SaaS product dimensions. Applicable for AWS SaaS products only. This is used to save price info when creating AWS SaaS product.", alias="awsSaasProductDimensions")
    base_agreement_id: Optional[StrictStr] = Field(default=None, description="Applicable for AWS Marketplace only, when the IsAgreementBasedOffer is true.", alias="baseAgreementId")
    buyer_ids: Optional[List[StrictStr]] = Field(default=None, description="The Suger buyer IDs of the private offer if available.", alias="buyerIds")
    contacts: Optional[List[Contact]] = Field(default=None, description="The contacts of the offer to notify if any updates.")
    cppo_in_offer_id: Optional[StrictStr] = Field(default=None, description="The Suger CPPO_IN offer ID.", alias="cppoInOfferId")
    cppo_offer_id: Optional[StrictStr] = Field(default=None, description="The Suger CPPO offer ID.", alias="cppoOfferId")
    cppo_out_offer_id: Optional[StrictStr] = Field(default=None, description="The Suger CPPO_OUT offer ID.", alias="cppoOutOfferId")
    custom_meta_info: Optional[Dict[str, StrictStr]] = Field(default=None, description="The custom meta info of the offer can be updated by seller via API or console.", alias="customMetaInfo")
    enable_test_usage_metering: Optional[StrictBool] = Field(default=None, description="If enabled, Suger will test metering the usage for this entitlement hourly.", alias="enableTestUsageMetering")
    entitlement_cancellation_schedule: Optional[CancellationSchedule] = Field(default=None, description="The cancellation schedule for the entitlement. It is nill if no cancellation schedule.", alias="entitlementCancellationSchedule")
    error_messages: Optional[List[StrictStr]] = Field(default=None, description="The error messages when the offer is invalid or offer related tasks failed. Populated by Suger service.", alias="errorMessages")
    hubspot_deal_id: Optional[StrictStr] = Field(default=None, description="Hubsport deal ID of the private offer if available.", alias="hubspotDealId")
    internal_note: Optional[StrictStr] = Field(default=None, description="The Internal note of the private offer. It is only visible to the seller/ISV, not visible to the buyer. Up to 1000 characters.", alias="internalNote")
    is_agreement_based_offer: Optional[StrictBool] = Field(default=None, description="Applicable for AWS Marketplace only, If this offer is agreement based offer.", alias="isAgreementBasedOffer")
    is_gross_revenue_full_sync: Optional[StrictBool] = Field(default=None, description="Whether the gross revenue is fully synced for the entitlement.", alias="isGrossRevenueFullSync")
    is_renewal_offer: Optional[StrictBool] = Field(default=None, description="Applicable for AWS Marketplace only. If this offer is renewal offer of existing agreement. The existing agreement can be within or outside AWS Marketplace. AWS may audit and verify your offer is a renewal. If AWS is unable to verify your offer, then AWS may revoke the offer and entitlements from your customer.", alias="isRenewalOffer")
    is_replacement_offer: Optional[StrictBool] = Field(default=None, description="If this offer is a GCP replacement offer. Applicable for GCP Marketplace replacement offer only.", alias="isReplacementOffer")
    last_modified_by: Optional[LastModifiedBy] = Field(default=None, description="The user who last modified the product/offer/buyer/contact.", alias="lastModifiedBy")
    notifications: Optional[List[NotificationEvent]] = Field(default=None, description="The notifications of the offer if any updates. In most cases, it is to notify contacts/buyers when the offer is pending acceptance.")
    offer_accept_date: Optional[datetime] = Field(default=None, description="The date when the offer is accepted by the buyer. Only available when the private offer has been accepted.", alias="offerAcceptDate")
    renewal_offer_type: Optional[AwsRenewalOfferType] = Field(default=None, description="Applicable for AWS Marketplace only, required when the IsRenewalOffer is true.", alias="renewalOfferType")
    replaced_offer_end_time: Optional[datetime] = Field(default=None, description="The end time of the replaced offer. Applicable for GCP Marketplace replacement offer only.", alias="replacedOfferEndTime")
    replaced_offer_resource_name: Optional[StrictStr] = Field(default=None, description="The resource name of the GCP Marketplace offer that this offer is replacing. In format of \"projects/{gcpProjectNumber}/services/{productServiceName}/privateOffers/{privateOfferId}\" Applicable for GCP Marketplace replacement offer only.", alias="replacedOfferResourceName")
    salesforce_entitlement_url: Optional[StrictStr] = Field(default=None, description="The Salesforce entitlement URL", alias="salesforceEntitlementURL")
    salesforce_opportunity_id: Optional[StrictStr] = Field(default=None, description="The Salesforce opportunity ID of the private offer if available.", alias="salesforceOpportunityId")
    test_usage_metering_end_time: Optional[datetime] = Field(default=None, description="The test usage metering end time. It is used for test usage metering only. Required if EnableTestUsageMetering is true.", alias="testUsageMeteringEndTime")
    update_message: Optional[StrictStr] = Field(default=None, description="The message to notify when the offer is updated.", alias="updateMessage")
    __properties: ClassVar[List[str]] = ["aceApnCrmUniqueIdentifier", "awsSaasProductDimensions", "baseAgreementId", "buyerIds", "contacts", "cppoInOfferId", "cppoOfferId", "cppoOutOfferId", "customMetaInfo", "enableTestUsageMetering", "entitlementCancellationSchedule", "errorMessages", "hubspotDealId", "internalNote", "isAgreementBasedOffer", "isGrossRevenueFullSync", "isRenewalOffer", "isReplacementOffer", "lastModifiedBy", "notifications", "offerAcceptDate", "renewalOfferType", "replacedOfferEndTime", "replacedOfferResourceName", "salesforceEntitlementURL", "salesforceOpportunityId", "testUsageMeteringEndTime", "updateMessage"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkloadMetaInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in aws_saas_product_dimensions (list)
        _items = []
        if self.aws_saas_product_dimensions:
            for _item_aws_saas_product_dimensions in self.aws_saas_product_dimensions:
                if _item_aws_saas_product_dimensions:
                    _items.append(_item_aws_saas_product_dimensions.to_dict())
            _dict['awsSaasProductDimensions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in contacts (list)
        _items = []
        if self.contacts:
            for _item_contacts in self.contacts:
                if _item_contacts:
                    _items.append(_item_contacts.to_dict())
            _dict['contacts'] = _items
        # override the default output from pydantic by calling `to_dict()` of entitlement_cancellation_schedule
        if self.entitlement_cancellation_schedule:
            _dict['entitlementCancellationSchedule'] = self.entitlement_cancellation_schedule.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_modified_by
        if self.last_modified_by:
            _dict['lastModifiedBy'] = self.last_modified_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in notifications (list)
        _items = []
        if self.notifications:
            for _item_notifications in self.notifications:
                if _item_notifications:
                    _items.append(_item_notifications.to_dict())
            _dict['notifications'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkloadMetaInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "aceApnCrmUniqueIdentifier": obj.get("aceApnCrmUniqueIdentifier"),
            "awsSaasProductDimensions": [AwsProductDimension.from_dict(_item) for _item in obj["awsSaasProductDimensions"]] if obj.get("awsSaasProductDimensions") is not None else None,
            "baseAgreementId": obj.get("baseAgreementId"),
            "buyerIds": obj.get("buyerIds"),
            "contacts": [Contact.from_dict(_item) for _item in obj["contacts"]] if obj.get("contacts") is not None else None,
            "cppoInOfferId": obj.get("cppoInOfferId"),
            "cppoOfferId": obj.get("cppoOfferId"),
            "cppoOutOfferId": obj.get("cppoOutOfferId"),
            "customMetaInfo": obj.get("customMetaInfo"),
            "enableTestUsageMetering": obj.get("enableTestUsageMetering"),
            "entitlementCancellationSchedule": CancellationSchedule.from_dict(obj["entitlementCancellationSchedule"]) if obj.get("entitlementCancellationSchedule") is not None else None,
            "errorMessages": obj.get("errorMessages"),
            "hubspotDealId": obj.get("hubspotDealId"),
            "internalNote": obj.get("internalNote"),
            "isAgreementBasedOffer": obj.get("isAgreementBasedOffer"),
            "isGrossRevenueFullSync": obj.get("isGrossRevenueFullSync"),
            "isRenewalOffer": obj.get("isRenewalOffer"),
            "isReplacementOffer": obj.get("isReplacementOffer"),
            "lastModifiedBy": LastModifiedBy.from_dict(obj["lastModifiedBy"]) if obj.get("lastModifiedBy") is not None else None,
            "notifications": [NotificationEvent.from_dict(_item) for _item in obj["notifications"]] if obj.get("notifications") is not None else None,
            "offerAcceptDate": obj.get("offerAcceptDate"),
            "renewalOfferType": obj.get("renewalOfferType"),
            "replacedOfferEndTime": obj.get("replacedOfferEndTime"),
            "replacedOfferResourceName": obj.get("replacedOfferResourceName"),
            "salesforceEntitlementURL": obj.get("salesforceEntitlementURL"),
            "salesforceOpportunityId": obj.get("salesforceOpportunityId"),
            "testUsageMeteringEndTime": obj.get("testUsageMeteringEndTime"),
            "updateMessage": obj.get("updateMessage")
        })
        return _obj


