# SuperCode 🚀

> "为什么要把简单的事情复杂化？" —— SuperCode 的设计哲学

## 这是什么鬼？🤔

SuperCode 是一个**极简脚本解释器**，让你用最直观的方式写代码。不需要复杂的语法，不需要记忆无数个函数，只需要你天马行空的想法！

想象一下，如果你能这样写代码：
say Hello World
if coffee_is_hot
wait a_while
end
drink coffee

text

嗯，SuperCode 就是这样的存在！它把编程变得像说话一样自然。

## 安装指南 🛠️

### 方法一：正经安装
```bash
pip install supercode
.
快速开始 🏃‍
5秒钟体验
python
from supercode import Compiler

# 创建你的专属编译器
compiler = Compiler()

# 教它认识新单词
compiler.set_func("greet", lambda name: f"Hello, {name}!")
compiler.set_func("add", lambda a, b: f"{a} + {b} = {int(a) + int(b)}")

# 开始对话！
code = """
greet World
add 1 1
"""

results = compiler.compile(code)
for output in results:
    print(output)
输出：

text
Hello, World!
1 + 1 = 2
看，编程就是这么简单！😎

详细教程 📚
第1课：让编译器学会新单词
python
from supercode import Compiler

compiler = Compiler()

# 教它说话
compiler.set_func("say", lambda *args: " ".join(args))

# 教它做数学
def add_numbers(num1, num2):
    result = int(num1) + int(num2)
    return f"{num1} + {num2} = {result}"

compiler.set_func("add", add_numbers)

# 现在可以这样写代码
code = """
say Beautiful day today
add 5 3
say Look, I can do math!
"""
第2课：条件判断（如果...那么...）
python
# 教它做判断
def if_handler(condition, all_statements, current_index, compiler):
    # 这里有点复杂，但原理很简单：
    # 如果条件成立，就执行缩进块里的代码
    condition_met = True  # 这里应该根据实际条件判断
    if condition_met:
        # 执行缩进块里的代码
        results = []
        # ... 执行逻辑 ...
        return "\n".join(results), skip_lines
    return None, skip_lines

compiler.set_block_handler("if", if_handler)
第3课：循环（重复做某事）
python
def loop_handler(condition, all_statements, current_index, compiler):
    # 原理：只要条件成立，就重复执行代码块
    loop_count = 0
    all_results = []
    while loop_count < 3:  # 防止无限循环
        # 执行代码块
        loop_count += 1
    return "\n".join(all_results), skip_lines

compiler.set_block_handler("loop", loop_handler)
完整示例 🎯
python
from supercode import Compiler, set_func, set_block_handler

# 定义一些实用功能
def set_var(*args):
    var_name = args[0]
    value = " ".join(args[1:])
    return f"Set {var_name} = {value}"

def display(*args):
    message = " ".join(args)
    return f"📢 {message}"

def calculate(*args):
    try:
        result = eval(" ".join(args))
        return f"🧮 {' '.join(args)} = {result}"
    except:
        return f"❌ Calculation error: {' '.join(args)}"

# 创建编译器并配置
compiler = Compiler([
    set_func("set", set_var),
    set_func("show", display), 
    set_func("calc", calculate)
])

# 写个有趣的程序
my_program = """
set name SuperProgrammer
show Hello, I am name
calc 2 * 3 + 4
show Look how smart I am!
calc 10 / 0
show Even errors won't crash me!
"""

print("🎬 Running my program:")
for output in compiler.compile(my_program):
    if output:
        print(output)
内置功能大全 🎁
基础命令
say [text] - 说点什么

show [message] - 显示消息

echo [text] - 回显文本

calc [expression] - 数学计算

set [var] [value] - 设置变量

块结构
if [condition] ... end - 条件判断

while [condition] ... end - 循环执行

loop [times] ... end - 指定次数循环

命令行使用 💻
安装后，直接在终端里玩：

bash
# 运行演示程序
supercode

# 或者执行自己的代码文件
python -c "
from supercode import Compiler
compiler = Compiler()
compiler.set_func('shout', lambda x: x.upper() + '!!!')
print(compiler.compile('shout hello world')[0])
"
为什么选择 SuperCode？🌟
Feature	SuperCode	Other Languages
Learning Curve	⭐ (One star)	⭐⭐⭐⭐⭐ (Five stars)
Code Lines	Very few	Too many to count
Debugging	Almost zero	Hair-pulling level
Fun Factor	🚀🚀🚀	😴
进阶玩法 🧙‍
自定义块处理器
python
def countdown_handler(args, all_statements, current_index, compiler):
    times = int(args[0]) if args else 3
    results = []
    for i in range(times, 0, -1):
        results.append(f"🎯 Countdown: {i}")
    return "\n".join(results), skip_lines

compiler.set_block_handler("countdown", countdown_handler)
变量系统
python
# Maintain variables in function
variables = {}

def store_var(name, value):
    variables[name] = value
    return f"💾 Saved {name} = {value}"

def get_var(name):
    value = variables.get(name, "❌ Undefined")
    return f"📖 {name} = {value}"
故障排除 🔧
问题1：我的函数不执行！

python
# ❌ Wrong way
compiler.set_func("echo", print)  # print returns None

# ✅ Correct way  
compiler.set_func("echo", lambda x: print(x) or x)
问题2：参数传递错误？

python
# 使用 *args 接收任意数量参数
def my_function(*args):
    return f"Received: {' '.join(args)}"
问题3：块处理器不工作？

python
# 确保返回正确的格式 (result, skip_lines)
def my_handler(args, statements, index, compiler):
    # 处理逻辑...
    return result, lines_to_skip  # ← 这很重要！

新功能(2.1.0)🛠️
今天想到了一个bug
好像无法处理print()呢！
（也就是括号）
改一下吧