<p align="center">
  <img src="https://raw.githubusercontent.com/superpandas-ai/superpython/main/assets/banner.png" alt="SuperPython Agent Banner" width="100%" />
</p>

<p align="center">
  <b>LLM-powered assistant for every Python package you import.</b><br/>
  Just add <code>.superpython.ask("your question")</code> to any module.
</p>

<p align="center">
  <a href="https://pypi.org/project/superpython/">
    <img src="https://img.shields.io/pypi/v/superpython.svg?color=blue" alt="PyPI version">
  </a>
  <a href="https://github.com/superpandas-ai/superpython/actions">
    <img src="https://github.com/superpandas-ai/superpython/workflows/Tests/badge.svg" alt="CI Status">
  </a>
  <a href="https://github.com/superpandas-ai/superpython">
    <img src="https://img.shields.io/github/stars/superpandas-ai/superpython?style=social" alt="GitHub stars">
  </a>
</p>

---

# 🧠 SuperPython Agent

SuperPython Agent automatically injects a `.superpython` assistant into every package you import. Ask questions about the library you're using, get help with errors, and explore code with syntax-highlighted answers — all powered by an LLM.

---

## 🎥 Demo

> _(Click to view full video)_

https://github.com/superpandas-ai/superpython/assets/demo.gif  
_or_  
https://loom.com/share/superpython-demo-link

---

## ❓ Why SuperPython?

There are thousands of Python libraries, but their docs aren't always intuitive. SuperPython fills that gap:

- You don't need to search Stack Overflow every time you forget a method.
- You get context-aware help, including recent exceptions and object summaries.
- It's built for exploration — whether you're using a notebook, REPL, or script.

---

## ✨ Features

- 💬 Ask any module `.superpython.ask("How do I do X?")`
- 💡 Smart context: recent errors + object summaries
- 🧩 Auto-attaches to every import
- 💾 Caches answers to avoid repeated API calls
- 🎨 Syntax-highlighted output with `pygments`
- 🧠 IPython magic: `%super pandas how to merge?`

---

## 🚀 Getting Started

### 1. Install

```bash
pip install superpython
```

### 2. Import It
```python
import superpython
```
It hooks into all future imports.

## 🧪 Usage Examples
### Inline Python
```python
import matplotlib

matplotlib.superpython.ask("how to make a scatter plot?")
```

### In Jupyter / IPython
```python
%load_ext superpython

%super numpy how to generate random numbers?
```

### Programmatic
```python
from superpython import agent

agent.ask("requests", "how do I send a POST request?")
```

## 🔧 Requirements
- openai
- ipywidgets
- pygments
- ipython

(Installed automatically.)

## 🧠 Project Structure
```text
superpython_agent/
├── superpython/
│   ├── agent.py
│   ├── cache.py
│   ├── context.py
│   ├── import_hook.py
│   ├── ipython_magics.py
│   ├── widgets.py
│   └── __init__.py
├── setup.py
├── pyproject.toml
└── README.md
```

## 🤝 Contributing
SuperPython is early-stage — PRs and ideas welcome!

- Want to support other LLMs?
- Want advanced caching or error tracing?
- Want to auto-annotate cells with answers?

Open an issue or submit a PR. 💥

## 🧷 License
MIT © 2025 SuperPandas Ltd 