# Swagger MCP Server (Python)

A Python implementation of a Model Context Protocol (MCP) server that transforms Swagger/OpenAPI documentation into AI-callable tools. This enables AI assistants (like Claude, Gemini) to interact with REST APIs through Swagger documentation.

## Features

- **7 MCP Tools**: Same functionality as the TypeScript version
- **Multi-service Support**: Configure multiple Swagger endpoints simultaneously
- **Auto-authentication**: Cache tokens from 401 responses and auto-inject
- **Smart Parameter Completion**: Fill required fields with reasonable defaults
- **Network Auto-correction**: Handle localhost vs 127.0.0.1 connectivity issues
- **Caching**: 5-minute TTL for Swagger documents with automatic refresh

## Installation

```bash
pip install -e .
```

## Usage

### As an MCP Server

Configure in your MCP client (Claude Desktop, Windsurf, etc.):

```json
{
  "mcpServers": {
    "swagger-python": {
      "command": "python",
      "args": [
        "-m",
        "swagger_mcp",
        "http://localhost:8090/v3/api-docs"
      ]
    }
  }
}
```

### Command Line Arguments

- Single service: `http://localhost:8090/v3/api-docs`
- Multiple services: `user=http://localhost:8090/v3/api-docs order=http://localhost:8091/v3/api-docs`
- Authentication: `auth=admin:123456` or `auth=/login/path:user:pass`

## Available Tools

1. **`list_services`** - List configured Swagger services
2. **`refresh_docs`** - Force refresh cached Swagger documentation
3. **`list_endpoints`** - List all available API endpoints
4. **`search_apis`** - Intelligent fuzzy search with weighted matching
5. **`get_endpoint_details`** - Get complete endpoint definition with parameters and schemas
6. **`debug_endpoint`** - Execute real HTTP requests with auto-authentication and smart parameter completion
7. **`generate_curl`** - Generate cURL commands for API calls

## Development

```bash
# Install development dependencies
pip install -e ".[dev]"

# Run tests
pytest

# Format code
black src/

# Lint code
ruff check src/
```

## Project Structure

```
src/swagger_mcp/
├── __main__.py          # Entry point
├── server.py           # MCP server implementation
├── services/
│   └── loader.py       # Swagger document loading, caching, auth management
├── tools/
│   └── __init__.py     # All MCP tool implementations
├── utils/
│   └── schema.py       # JSON Schema resolution utilities
└── types/
    └── swagger.py      # Pydantic models for Swagger documents
```

## License

MIT