#!/usr/bin/env python3
"""
Main entry point for the Swagger MCP Server.
"""

import asyncio
import sys
from .server import SwaggerMCPServer


async def main_async() -> None:
    """Async main entry point."""
    server = SwaggerMCPServer()
    await server.run()


def main() -> None:
    """Main entry point."""
    try:
        asyncio.run(main_async())
    except KeyboardInterrupt:
        print("\nShutting down...", file=sys.stderr)
        sys.exit(0)
    except Exception as e:
        print(f"Error: {e}", file=sys.stderr)
        sys.exit(1)


if __name__ == "__main__":
    main()