"""
Pydantic models for Swagger/OpenAPI documents.
"""

from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field


class Server(BaseModel):
    """Swagger server definition."""
    url: str
    description: Optional[str] = None


class Info(BaseModel):
    """Swagger info section."""
    title: str
    version: str


class Components(BaseModel):
    """Swagger components section."""
    schemas: Optional[Dict[str, Any]] = None


class SwaggerDoc(BaseModel):
    """Main Swagger/OpenAPI document model."""
    openapi: str
    servers: Optional[List[Server]] = None
    paths: Dict[str, Dict[str, Any]] = Field(default_factory=dict)
    components: Optional[Components] = None
    info: Optional[Info] = None

    class Config:
        """Pydantic config."""
        extra = "allow"  # Allow extra fields in Swagger docs