"""
    Authentication endpoints - OpenAPI 3.0

    The endpoints for the authentication API.  # noqa: E501

    The version of the OpenAPI document: DRAFT
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from swx_sdk.api_client import ApiClient, Endpoint as _Endpoint
from swx_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from swx_sdk.model.action_delay_list_response import ActionDelayListResponse
from swx_sdk.model.action_delete_response import ActionDeleteResponse
from swx_sdk.model.action_list_response import ActionListResponse
from swx_sdk.model.action_request import ActionRequest
from swx_sdk.model.action_response_element1 import ActionResponseElement1
from swx_sdk.model.action_update_request import ActionUpdateRequest
from swx_sdk.model.action_update_response import ActionUpdateResponse
from swx_sdk.model.thing_object_delete_response import ThingObjectDeleteResponse


class ActionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_accounts_things_action(
            self,
            account_id,
            thing_id,
            action,
            action_request,
            **kwargs
        ):
            """Request action  # noqa: E501

            Request action and add it to the action queue from a thing  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_accounts_things_action(account_id, thing_id, action, action_request, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str):
                thing_id (str):
                action (str):
                action_request (ActionRequest): Create a new action

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ActionResponseElement1
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            kwargs['thing_id'] = \
                thing_id
            kwargs['action'] = \
                action
            kwargs['action_request'] = \
                action_request
            return self.call_with_http_info(**kwargs)

        self.add_accounts_things_action = _Endpoint(
            settings={
                'response_type': (ActionResponseElement1,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account-id}/things/{thing-id}/actions/{action}',
                'operation_id': 'add_accounts_things_action',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'thing_id',
                    'action',
                    'action_request',
                ],
                'required': [
                    'account_id',
                    'thing_id',
                    'action',
                    'action_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'thing_id':
                        (str,),
                    'action':
                        (str,),
                    'action_request':
                        (ActionRequest,),
                },
                'attribute_map': {
                    'account_id': 'account-id',
                    'thing_id': 'thing-id',
                    'action': 'action',
                },
                'location_map': {
                    'account_id': 'path',
                    'thing_id': 'path',
                    'action': 'path',
                    'action_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_accounts_things_action
        )

        def __add_spaces_collections_things_action(
            self,
            space,
            collection_name,
            thing_id,
            action,
            action_request,
            **kwargs
        ):
            """Request action  # noqa: E501

            Request action and add it to the action queue from a thing  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_spaces_collections_things_action(space, collection_name, thing_id, action, action_request, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                collection_name (str):
                thing_id (str):
                action (str):
                action_request (ActionRequest): Create a new action

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ActionResponseElement1
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['collection_name'] = \
                collection_name
            kwargs['thing_id'] = \
                thing_id
            kwargs['action'] = \
                action
            kwargs['action_request'] = \
                action_request
            return self.call_with_http_info(**kwargs)

        self.add_spaces_collections_things_action = _Endpoint(
            settings={
                'response_type': (ActionResponseElement1,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action}',
                'operation_id': 'add_spaces_collections_things_action',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'collection_name',
                    'thing_id',
                    'action',
                    'action_request',
                ],
                'required': [
                    'space',
                    'collection_name',
                    'thing_id',
                    'action',
                    'action_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'collection_name':
                        (str,),
                    'thing_id':
                        (str,),
                    'action':
                        (str,),
                    'action_request':
                        (ActionRequest,),
                },
                'attribute_map': {
                    'space': 'space',
                    'collection_name': 'collection-name',
                    'thing_id': 'thing-id',
                    'action': 'action',
                },
                'location_map': {
                    'space': 'path',
                    'collection_name': 'path',
                    'thing_id': 'path',
                    'action': 'path',
                    'action_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_spaces_collections_things_action
        )

        def __delete_accounts_things_action(
            self,
            account_id,
            thing_id,
            action,
            action_id,
            **kwargs
        ):
            """Delete Action  # noqa: E501

            Deletes an existing action by Id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_accounts_things_action(account_id, thing_id, action, action_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str):
                thing_id (str):
                action (str):
                action_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ActionDeleteResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            kwargs['thing_id'] = \
                thing_id
            kwargs['action'] = \
                action
            kwargs['action_id'] = \
                action_id
            return self.call_with_http_info(**kwargs)

        self.delete_accounts_things_action = _Endpoint(
            settings={
                'response_type': (ActionDeleteResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account-id}/things/{thing-id}/actions/{action}/{action-id}',
                'operation_id': 'delete_accounts_things_action',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'thing_id',
                    'action',
                    'action_id',
                ],
                'required': [
                    'account_id',
                    'thing_id',
                    'action',
                    'action_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'thing_id':
                        (str,),
                    'action':
                        (str,),
                    'action_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'account-id',
                    'thing_id': 'thing-id',
                    'action': 'action',
                    'action_id': 'action-id',
                },
                'location_map': {
                    'account_id': 'path',
                    'thing_id': 'path',
                    'action': 'path',
                    'action_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_accounts_things_action
        )

        def __delete_spaces_collections_things_action(
            self,
            space,
            collection_name,
            thing_id,
            action,
            action_id,
            **kwargs
        ):
            """Delete Action  # noqa: E501

            Deletes an existing action by Id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_spaces_collections_things_action(space, collection_name, thing_id, action, action_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                collection_name (str):
                thing_id (str):
                action (str):
                action_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ThingObjectDeleteResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['collection_name'] = \
                collection_name
            kwargs['thing_id'] = \
                thing_id
            kwargs['action'] = \
                action
            kwargs['action_id'] = \
                action_id
            return self.call_with_http_info(**kwargs)

        self.delete_spaces_collections_things_action = _Endpoint(
            settings={
                'response_type': (ThingObjectDeleteResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action}/{action-id}',
                'operation_id': 'delete_spaces_collections_things_action',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'collection_name',
                    'thing_id',
                    'action',
                    'action_id',
                ],
                'required': [
                    'space',
                    'collection_name',
                    'thing_id',
                    'action',
                    'action_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'collection_name':
                        (str,),
                    'thing_id':
                        (str,),
                    'action':
                        (str,),
                    'action_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'collection_name': 'collection-name',
                    'thing_id': 'thing-id',
                    'action': 'action',
                    'action_id': 'action-id',
                },
                'location_map': {
                    'space': 'path',
                    'collection_name': 'path',
                    'thing_id': 'path',
                    'action': 'path',
                    'action_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_spaces_collections_things_action
        )

        def __list_accounts_things_actions(
            self,
            account_id,
            thing_id,
            **kwargs
        ):
            """Lists all the action queues for a thing  # noqa: E501

            Lists all the queues for the different actions within a thing.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_accounts_things_actions(account_id, thing_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str):
                thing_id (int):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ActionListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            kwargs['thing_id'] = \
                thing_id
            return self.call_with_http_info(**kwargs)

        self.list_accounts_things_actions = _Endpoint(
            settings={
                'response_type': (ActionListResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account-id}/things/{thing-id}/actions',
                'operation_id': 'list_accounts_things_actions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'thing_id',
                ],
                'required': [
                    'account_id',
                    'thing_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'thing_id':
                        (int,),
                },
                'attribute_map': {
                    'account_id': 'account-id',
                    'thing_id': 'thing-id',
                },
                'location_map': {
                    'account_id': 'path',
                    'thing_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_accounts_things_actions
        )

        def __list_accounts_things_actions_by_name(
            self,
            account_id,
            thing_id,
            action,
            **kwargs
        ):
            """List the queue of actions from a thing  # noqa: E501

            Lists the current queue of a specific action from a Thing  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_accounts_things_actions_by_name(account_id, thing_id, action, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str):
                thing_id (str):
                action (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ActionDelayListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            kwargs['thing_id'] = \
                thing_id
            kwargs['action'] = \
                action
            return self.call_with_http_info(**kwargs)

        self.list_accounts_things_actions_by_name = _Endpoint(
            settings={
                'response_type': (ActionDelayListResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account-id}/things/{thing-id}/actions/{action}',
                'operation_id': 'list_accounts_things_actions_by_name',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'thing_id',
                    'action',
                ],
                'required': [
                    'account_id',
                    'thing_id',
                    'action',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'thing_id':
                        (str,),
                    'action':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'account-id',
                    'thing_id': 'thing-id',
                    'action': 'action',
                },
                'location_map': {
                    'account_id': 'path',
                    'thing_id': 'path',
                    'action': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_accounts_things_actions_by_name
        )

        def __list_spaces_collections_things_actions(
            self,
            space,
            collection_name,
            thing_id,
            **kwargs
        ):
            """Lists all the action queues for a thing  # noqa: E501

            Lists all the queues for the different actions within a thing.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_spaces_collections_things_actions(space, collection_name, thing_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                collection_name (str):
                thing_id (int):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ActionListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['collection_name'] = \
                collection_name
            kwargs['thing_id'] = \
                thing_id
            return self.call_with_http_info(**kwargs)

        self.list_spaces_collections_things_actions = _Endpoint(
            settings={
                'response_type': (ActionListResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/collections/{collection-name}/things/{thing-id}/actions',
                'operation_id': 'list_spaces_collections_things_actions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'collection_name',
                    'thing_id',
                ],
                'required': [
                    'space',
                    'collection_name',
                    'thing_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'collection_name':
                        (str,),
                    'thing_id':
                        (int,),
                },
                'attribute_map': {
                    'space': 'space',
                    'collection_name': 'collection-name',
                    'thing_id': 'thing-id',
                },
                'location_map': {
                    'space': 'path',
                    'collection_name': 'path',
                    'thing_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_spaces_collections_things_actions
        )

        def __list_spaces_collections_things_actions_by_name(
            self,
            space,
            collection_name,
            thing_id,
            action,
            **kwargs
        ):
            """List the queue of actions from a thing  # noqa: E501

            Lists the current queue of a specific action from a Thing  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_spaces_collections_things_actions_by_name(space, collection_name, thing_id, action, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                collection_name (str):
                thing_id (str):
                action (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ActionDelayListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['collection_name'] = \
                collection_name
            kwargs['thing_id'] = \
                thing_id
            kwargs['action'] = \
                action
            return self.call_with_http_info(**kwargs)

        self.list_spaces_collections_things_actions_by_name = _Endpoint(
            settings={
                'response_type': (ActionDelayListResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action}',
                'operation_id': 'list_spaces_collections_things_actions_by_name',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'collection_name',
                    'thing_id',
                    'action',
                ],
                'required': [
                    'space',
                    'collection_name',
                    'thing_id',
                    'action',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'collection_name':
                        (str,),
                    'thing_id':
                        (str,),
                    'action':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'collection_name': 'collection-name',
                    'thing_id': 'thing-id',
                    'action': 'action',
                },
                'location_map': {
                    'space': 'path',
                    'collection_name': 'path',
                    'thing_id': 'path',
                    'action': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_spaces_collections_things_actions_by_name
        )

        def __show_accounts_things_action(
            self,
            account_id,
            thing_id,
            action,
            action_id,
            **kwargs
        ):
            """Show action requested  # noqa: E501

            Shows a requested action from the action queues of a thing.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.show_accounts_things_action(account_id, thing_id, action, action_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str):
                thing_id (str):
                action (str):
                action_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ActionResponseElement1
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            kwargs['thing_id'] = \
                thing_id
            kwargs['action'] = \
                action
            kwargs['action_id'] = \
                action_id
            return self.call_with_http_info(**kwargs)

        self.show_accounts_things_action = _Endpoint(
            settings={
                'response_type': (ActionResponseElement1,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account-id}/things/{thing-id}/actions/{action}/{action-id}',
                'operation_id': 'show_accounts_things_action',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'thing_id',
                    'action',
                    'action_id',
                ],
                'required': [
                    'account_id',
                    'thing_id',
                    'action',
                    'action_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'thing_id':
                        (str,),
                    'action':
                        (str,),
                    'action_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'account-id',
                    'thing_id': 'thing-id',
                    'action': 'action',
                    'action_id': 'action-id',
                },
                'location_map': {
                    'account_id': 'path',
                    'thing_id': 'path',
                    'action': 'path',
                    'action_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__show_accounts_things_action
        )

        def __show_spaces_collections_things_action(
            self,
            space,
            collection_name,
            thing_id,
            action,
            action_id,
            **kwargs
        ):
            """Show action requested  # noqa: E501

            Shows a requested action from the action queues of a thing.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.show_spaces_collections_things_action(space, collection_name, thing_id, action, action_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                collection_name (str):
                thing_id (str):
                action (str):
                action_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ActionResponseElement1
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['collection_name'] = \
                collection_name
            kwargs['thing_id'] = \
                thing_id
            kwargs['action'] = \
                action
            kwargs['action_id'] = \
                action_id
            return self.call_with_http_info(**kwargs)

        self.show_spaces_collections_things_action = _Endpoint(
            settings={
                'response_type': (ActionResponseElement1,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action}/{action-id}',
                'operation_id': 'show_spaces_collections_things_action',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'collection_name',
                    'thing_id',
                    'action',
                    'action_id',
                ],
                'required': [
                    'space',
                    'collection_name',
                    'thing_id',
                    'action',
                    'action_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'collection_name':
                        (str,),
                    'thing_id':
                        (str,),
                    'action':
                        (str,),
                    'action_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'collection_name': 'collection-name',
                    'thing_id': 'thing-id',
                    'action': 'action',
                    'action_id': 'action-id',
                },
                'location_map': {
                    'space': 'path',
                    'collection_name': 'path',
                    'thing_id': 'path',
                    'action': 'path',
                    'action_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__show_spaces_collections_things_action
        )

        def __update_accounts_things_action(
            self,
            account_id,
            thing_id,
            action,
            action_id,
            action_update_request,
            **kwargs
        ):
            """Update action inside a queue  # noqa: E501

            Update the status of an existing action by Id inside of the action queue from a thing  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_accounts_things_action(account_id, thing_id, action, action_id, action_update_request, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str):
                thing_id (str):
                action (str):
                action_id (str):
                action_update_request (ActionUpdateRequest): Update an existent thing by Id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ActionUpdateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            kwargs['thing_id'] = \
                thing_id
            kwargs['action'] = \
                action
            kwargs['action_id'] = \
                action_id
            kwargs['action_update_request'] = \
                action_update_request
            return self.call_with_http_info(**kwargs)

        self.update_accounts_things_action = _Endpoint(
            settings={
                'response_type': (ActionUpdateResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/accounts/{account-id}/things/{thing-id}/actions/{action}/{action-id}',
                'operation_id': 'update_accounts_things_action',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'thing_id',
                    'action',
                    'action_id',
                    'action_update_request',
                ],
                'required': [
                    'account_id',
                    'thing_id',
                    'action',
                    'action_id',
                    'action_update_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'thing_id':
                        (str,),
                    'action':
                        (str,),
                    'action_id':
                        (str,),
                    'action_update_request':
                        (ActionUpdateRequest,),
                },
                'attribute_map': {
                    'account_id': 'account-id',
                    'thing_id': 'thing-id',
                    'action': 'action',
                    'action_id': 'action-id',
                },
                'location_map': {
                    'account_id': 'path',
                    'thing_id': 'path',
                    'action': 'path',
                    'action_id': 'path',
                    'action_update_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_accounts_things_action
        )

        def __update_spaces_collections_things_action(
            self,
            space,
            collection_name,
            thing_id,
            action,
            action_id,
            action_update_request,
            **kwargs
        ):
            """Update action inside a queue  # noqa: E501

            Update the status of an existing action by Id inside of the action queue from a thing  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_spaces_collections_things_action(space, collection_name, thing_id, action, action_id, action_update_request, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                collection_name (str):
                thing_id (str):
                action (str):
                action_id (str):
                action_update_request (ActionUpdateRequest): Update an existent thing by Id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ActionUpdateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['collection_name'] = \
                collection_name
            kwargs['thing_id'] = \
                thing_id
            kwargs['action'] = \
                action
            kwargs['action_id'] = \
                action_id
            kwargs['action_update_request'] = \
                action_update_request
            return self.call_with_http_info(**kwargs)

        self.update_spaces_collections_things_action = _Endpoint(
            settings={
                'response_type': (ActionUpdateResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action}/{action-id}',
                'operation_id': 'update_spaces_collections_things_action',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'collection_name',
                    'thing_id',
                    'action',
                    'action_id',
                    'action_update_request',
                ],
                'required': [
                    'space',
                    'collection_name',
                    'thing_id',
                    'action',
                    'action_id',
                    'action_update_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'collection_name':
                        (str,),
                    'thing_id':
                        (str,),
                    'action':
                        (str,),
                    'action_id':
                        (str,),
                    'action_update_request':
                        (ActionUpdateRequest,),
                },
                'attribute_map': {
                    'space': 'space',
                    'collection_name': 'collection-name',
                    'thing_id': 'thing-id',
                    'action': 'action',
                    'action_id': 'action-id',
                },
                'location_map': {
                    'space': 'path',
                    'collection_name': 'path',
                    'thing_id': 'path',
                    'action': 'path',
                    'action_id': 'path',
                    'action_update_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_spaces_collections_things_action
        )
