"""
    Authentication endpoints - OpenAPI 3.0

    The endpoints for the authentication API.  # noqa: E501

    The version of the OpenAPI document: DRAFT
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from swx_sdk.api_client import ApiClient, Endpoint as _Endpoint
from swx_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from swx_sdk.model.create_data import CreateData
from swx_sdk.model.create_data_response import CreateDataResponse
from swx_sdk.model.data_delete_response import DataDeleteResponse
from swx_sdk.model.data_list_element3 import DataListElement3
from swx_sdk.model.data_list_response import DataListResponse


class DataApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_spaces_data(
            self,
            space,
            create_data,
            **kwargs
        ):
            """Create data  # noqa: E501

            Send a new data to the platform  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_spaces_data(space, create_data, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                create_data (CreateData):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateDataResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['create_data'] = \
                create_data
            return self.call_with_http_info(**kwargs)

        self.create_spaces_data = _Endpoint(
            settings={
                'response_type': (CreateDataResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/data',
                'operation_id': 'create_spaces_data',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'create_data',
                ],
                'required': [
                    'space',
                    'create_data',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'create_data':
                        (CreateData,),
                },
                'attribute_map': {
                    'space': 'space',
                },
                'location_map': {
                    'space': 'path',
                    'create_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__create_spaces_data
        )

        def __delete_spaces_data(
            self,
            space,
            data_id,
            **kwargs
        ):
            """Delete Data  # noqa: E501

            Deletes an existing data by Id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_spaces_data(space, data_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                data_id (int):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DataDeleteResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['data_id'] = \
                data_id
            return self.call_with_http_info(**kwargs)

        self.delete_spaces_data = _Endpoint(
            settings={
                'response_type': (DataDeleteResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/data/{data-id}',
                'operation_id': 'delete_spaces_data',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'data_id',
                ],
                'required': [
                    'space',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'data_id':
                        (int,),
                },
                'attribute_map': {
                    'space': 'space',
                    'data_id': 'data-id',
                },
                'location_map': {
                    'space': 'path',
                    'data_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_spaces_data
        )

        def __delete_spaces_data_from_source(
            self,
            space,
            source,
            **kwargs
        ):
            """Delete Data  # noqa: E501

            Deletes an existing data by source  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_spaces_data_from_source(space, source, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                source (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DataDeleteResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['source'] = \
                source
            return self.call_with_http_info(**kwargs)

        self.delete_spaces_data_from_source = _Endpoint(
            settings={
                'response_type': (DataDeleteResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/data',
                'operation_id': 'delete_spaces_data_from_source',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'source',
                ],
                'required': [
                    'space',
                    'source',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'source':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'source': 'source[]',
                },
                'location_map': {
                    'space': 'path',
                    'source': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_spaces_data_from_source
        )

        def __list_spaces_data(
            self,
            space,
            source,
            **kwargs
        ):
            """List Data  # noqa: E501

            List of all the data in array  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_spaces_data(space, source, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                source (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DataListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['source'] = \
                source
            return self.call_with_http_info(**kwargs)

        self.list_spaces_data = _Endpoint(
            settings={
                'response_type': (DataListResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/data',
                'operation_id': 'list_spaces_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'source',
                ],
                'required': [
                    'space',
                    'source',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'source':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'source': 'source[]',
                },
                'location_map': {
                    'space': 'path',
                    'source': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_spaces_data
        )

        def __show_spaces_data(
            self,
            space,
            data_id,
            **kwargs
        ):
            """Show Data  # noqa: E501

            Show an existing data by Id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.show_spaces_data(space, data_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                data_id (int):

            Keyword Args:
                download (bool): [optional]
                metadata (bool): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DataListElement3
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['data_id'] = \
                data_id
            return self.call_with_http_info(**kwargs)

        self.show_spaces_data = _Endpoint(
            settings={
                'response_type': (DataListElement3,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/data/{data-id}',
                'operation_id': 'show_spaces_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'data_id',
                    'download',
                    'metadata',
                ],
                'required': [
                    'space',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'data_id':
                        (int,),
                    'download':
                        (bool,),
                    'metadata':
                        (bool,),
                },
                'attribute_map': {
                    'space': 'space',
                    'data_id': 'data-id',
                    'download': 'download',
                    'metadata': 'metadata',
                },
                'location_map': {
                    'space': 'path',
                    'data_id': 'path',
                    'download': 'query',
                    'metadata': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__show_spaces_data
        )
