"""
    Authentication endpoints - OpenAPI 3.0

    The endpoints for the authentication API.  # noqa: E501

    The version of the OpenAPI document: DRAFT
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from swx_sdk.api_client import ApiClient, Endpoint as _Endpoint
from swx_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from swx_sdk.model.credentials_response_list import CredentialsResponseList
from swx_sdk.model.credentials_response_put import CredentialsResponsePUT
from swx_sdk.model.credentials_response_thing import CredentialsResponseThing
from swx_sdk.model.mqtt_label_credentials import MQTTLabelCredentials
from swx_sdk.model.mqtt_label_delete_response import MQTTLabelDeleteResponse
from swx_sdk.model.mqtt_label_show_response import MQTTLabelShowResponse
from swx_sdk.model.mqttpost_body import MQTTPOSTBody
from swx_sdk.model.mqttpost_response import MQTTPOSTResponse
from swx_sdk.model.mqttput_body import MQTTPUTBody
from swx_sdk.model.mqtt_password import MQTTPassword


class MQTTApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_spaces_mqtt_mqtt_label_credentials(
            self,
            space,
            **kwargs
        ):
            """Create MQTT credentials for a label  # noqa: E501

            Create MQTT credentials for a specific label  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_spaces_mqtt_mqtt_label_credentials(space, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):

            Keyword Args:
                mqttpost_body (MQTTPOSTBody): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MQTTPOSTResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            return self.call_with_http_info(**kwargs)

        self.create_spaces_mqtt_mqtt_label_credentials = _Endpoint(
            settings={
                'response_type': (MQTTPOSTResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/mqtt/labels',
                'operation_id': 'create_spaces_mqtt_mqtt_label_credentials',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'mqttpost_body',
                ],
                'required': [
                    'space',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'mqttpost_body':
                        (MQTTPOSTBody,),
                },
                'attribute_map': {
                    'space': 'space',
                },
                'location_map': {
                    'space': 'path',
                    'mqttpost_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_spaces_mqtt_mqtt_label_credentials
        )

        def __delete_spaces_mqtt_mqtt_label(
            self,
            space,
            label_id,
            **kwargs
        ):
            """Delete MQTT label  # noqa: E501

            Delete MQTT capabilities for a label  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_spaces_mqtt_mqtt_label(space, label_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                label_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MQTTLabelDeleteResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['label_id'] = \
                label_id
            return self.call_with_http_info(**kwargs)

        self.delete_spaces_mqtt_mqtt_label = _Endpoint(
            settings={
                'response_type': (MQTTLabelDeleteResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/mqtt/labels/{label-id}',
                'operation_id': 'delete_spaces_mqtt_mqtt_label',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'label_id',
                ],
                'required': [
                    'space',
                    'label_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'label_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'label_id': 'label-id',
                },
                'location_map': {
                    'space': 'path',
                    'label_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_spaces_mqtt_mqtt_label
        )

        def __list_spaces_mqtt_mqt_tcredentials(
            self,
            space,
            **kwargs
        ):
            """List space MQTT credentials  # noqa: E501

            List all MQTT credentials for a specific Account  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_spaces_mqtt_mqt_tcredentials(space, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CredentialsResponseList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            return self.call_with_http_info(**kwargs)

        self.list_spaces_mqtt_mqt_tcredentials = _Endpoint(
            settings={
                'response_type': (CredentialsResponseList,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/mqtt/credentials',
                'operation_id': 'list_spaces_mqtt_mqt_tcredentials',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                ],
                'required': [
                    'space',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                },
                'location_map': {
                    'space': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_spaces_mqtt_mqt_tcredentials
        )

        def __list_spaces_mqtt_thing_mqt_tcredentials(
            self,
            space,
            thing_id,
            **kwargs
        ):
            """List Thing MQTT credentials  # noqa: E501

            List all MQTT credentials for a specific Thing  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_spaces_mqtt_thing_mqt_tcredentials(space, thing_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                thing_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CredentialsResponseThing
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['thing_id'] = \
                thing_id
            return self.call_with_http_info(**kwargs)

        self.list_spaces_mqtt_thing_mqt_tcredentials = _Endpoint(
            settings={
                'response_type': (CredentialsResponseThing,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/mqtt/things/{thing-id}',
                'operation_id': 'list_spaces_mqtt_thing_mqt_tcredentials',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'thing_id',
                ],
                'required': [
                    'space',
                    'thing_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'thing_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'thing_id': 'thing-id',
                },
                'location_map': {
                    'space': 'path',
                    'thing_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_spaces_mqtt_thing_mqt_tcredentials
        )

        def __show_spaces_mqtt_mqt_tcredentials(
            self,
            space,
            credentials_id,
            **kwargs
        ):
            """Show MQTT credentials  # noqa: E501

            Show a specific MQTT credentials  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.show_spaces_mqtt_mqt_tcredentials(space, credentials_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                credentials_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CredentialsResponseThing
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['credentials_id'] = \
                credentials_id
            return self.call_with_http_info(**kwargs)

        self.show_spaces_mqtt_mqt_tcredentials = _Endpoint(
            settings={
                'response_type': (CredentialsResponseThing,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/mqtt/credentials/{credentials-id}',
                'operation_id': 'show_spaces_mqtt_mqt_tcredentials',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'credentials_id',
                ],
                'required': [
                    'space',
                    'credentials_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'credentials_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'credentials_id': 'credentials-id',
                },
                'location_map': {
                    'space': 'path',
                    'credentials_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__show_spaces_mqtt_mqt_tcredentials
        )

        def __show_spaces_mqtt_mqtt_label_info(
            self,
            space,
            label_id,
            **kwargs
        ):
            """Show MQTT label details  # noqa: E501

            Show MQTT label details for a specific label  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.show_spaces_mqtt_mqtt_label_info(space, label_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                label_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MQTTLabelShowResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['label_id'] = \
                label_id
            return self.call_with_http_info(**kwargs)

        self.show_spaces_mqtt_mqtt_label_info = _Endpoint(
            settings={
                'response_type': (MQTTLabelShowResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/mqtt/labels/{label-id}',
                'operation_id': 'show_spaces_mqtt_mqtt_label_info',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'label_id',
                ],
                'required': [
                    'space',
                    'label_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'label_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'label_id': 'label-id',
                },
                'location_map': {
                    'space': 'path',
                    'label_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__show_spaces_mqtt_mqtt_label_info
        )

        def __update_spaces_mqtt_mqt_tcredentials(
            self,
            space,
            credentials_id,
            **kwargs
        ):
            """Update MQTT credentials  # noqa: E501

            Update a specific MQTT credentials. If you send an empty body, a random password will be generated  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_spaces_mqtt_mqt_tcredentials(space, credentials_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                credentials_id (str):

            Keyword Args:
                mqttput_body (MQTTPUTBody): These are the fields that you can update. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CredentialsResponsePUT
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['credentials_id'] = \
                credentials_id
            return self.call_with_http_info(**kwargs)

        self.update_spaces_mqtt_mqt_tcredentials = _Endpoint(
            settings={
                'response_type': (CredentialsResponsePUT,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/mqtt/credentials/{credentials-id}',
                'operation_id': 'update_spaces_mqtt_mqt_tcredentials',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'credentials_id',
                    'mqttput_body',
                ],
                'required': [
                    'space',
                    'credentials_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'credentials_id':
                        (str,),
                    'mqttput_body':
                        (MQTTPUTBody,),
                },
                'attribute_map': {
                    'space': 'space',
                    'credentials_id': 'credentials-id',
                },
                'location_map': {
                    'space': 'path',
                    'credentials_id': 'path',
                    'mqttput_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_spaces_mqtt_mqt_tcredentials
        )

        def __update_spaces_mqtt_mqt_tpassword(
            self,
            space,
            mqtt_username,
            **kwargs
        ):
            """Update MQTT password  # noqa: E501

            Update the MQTT password for a specific mqtt-username.  If you send an empty body, a random password will be generated  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_spaces_mqtt_mqt_tpassword(space, mqtt_username, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                mqtt_username (str):

            Keyword Args:
                mqtt_password (MQTTPassword): This is the field that you can update. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CredentialsResponsePUT
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['mqtt_username'] = \
                mqtt_username
            return self.call_with_http_info(**kwargs)

        self.update_spaces_mqtt_mqt_tpassword = _Endpoint(
            settings={
                'response_type': (CredentialsResponsePUT,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/mqtt/credentials-username/{mqtt-username}',
                'operation_id': 'update_spaces_mqtt_mqt_tpassword',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'mqtt_username',
                    'mqtt_password',
                ],
                'required': [
                    'space',
                    'mqtt_username',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'mqtt_username':
                        (str,),
                    'mqtt_password':
                        (MQTTPassword,),
                },
                'attribute_map': {
                    'space': 'space',
                    'mqtt_username': 'mqtt-username',
                },
                'location_map': {
                    'space': 'path',
                    'mqtt_username': 'path',
                    'mqtt_password': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_spaces_mqtt_mqt_tpassword
        )

        def __update_spaces_mqtt_mqtt_label(
            self,
            space,
            label_id,
            mqtt_label_credentials,
            **kwargs
        ):
            """Update MQTT Label  # noqa: E501

            Update the MQTT Label credentials and / or state  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_spaces_mqtt_mqtt_label(space, label_id, mqtt_label_credentials, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                label_id (str):
                mqtt_label_credentials (MQTTLabelCredentials): This is the field that you can update

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MQTTPOSTResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['label_id'] = \
                label_id
            kwargs['mqtt_label_credentials'] = \
                mqtt_label_credentials
            return self.call_with_http_info(**kwargs)

        self.update_spaces_mqtt_mqtt_label = _Endpoint(
            settings={
                'response_type': (MQTTPOSTResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/mqtt/labels/{label-id}',
                'operation_id': 'update_spaces_mqtt_mqtt_label',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'label_id',
                    'mqtt_label_credentials',
                ],
                'required': [
                    'space',
                    'label_id',
                    'mqtt_label_credentials',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'label_id':
                        (str,),
                    'mqtt_label_credentials':
                        (MQTTLabelCredentials,),
                },
                'attribute_map': {
                    'space': 'space',
                    'label_id': 'label-id',
                },
                'location_map': {
                    'space': 'path',
                    'label_id': 'path',
                    'mqtt_label_credentials': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_spaces_mqtt_mqtt_label
        )
