"""
    Authentication endpoints - OpenAPI 3.0

    The endpoints for the authentication API.  # noqa: E501

    The version of the OpenAPI document: DRAFT
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from swx_sdk.api_client import ApiClient, Endpoint as _Endpoint
from swx_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from swx_sdk.model.subscriber_request import SubscriberRequest
from swx_sdk.model.subscriber_response import SubscriberResponse


class SubscribersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_cloud_connect_subscriber(
            self,
            subscriber_request,
            **kwargs
        ):
            """Add Subscriber  # noqa: E501

            Add a new subscriber to the platform  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_cloud_connect_subscriber(subscriber_request, async_req=True)
            >>> result = thread.get()

            Args:
                subscriber_request (SubscriberRequest): Create a new subscriber in the platform

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SubscriberResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['subscriber_request'] = \
                subscriber_request
            return self.call_with_http_info(**kwargs)

        self.add_cloud_connect_subscriber = _Endpoint(
            settings={
                'response_type': (SubscriberResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/cloud/connect/subscribers',
                'operation_id': 'add_cloud_connect_subscriber',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'subscriber_request',
                ],
                'required': [
                    'subscriber_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'subscriber_request':
                        (SubscriberRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'subscriber_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_cloud_connect_subscriber
        )

        def __delete_cloud_connect_subscriber(
            self,
            subscriber_id,
            **kwargs
        ):
            """Delete Subscriber  # noqa: E501

            Deletes an existing Subscriber by id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_cloud_connect_subscriber(subscriber_id, async_req=True)
            >>> result = thread.get()

            Args:
                subscriber_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['subscriber_id'] = \
                subscriber_id
            return self.call_with_http_info(**kwargs)

        self.delete_cloud_connect_subscriber = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/cloud/connect/subscribers/{subscriber_id}',
                'operation_id': 'delete_cloud_connect_subscriber',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'subscriber_id',
                ],
                'required': [
                    'subscriber_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'subscriber_id':
                        (str,),
                },
                'attribute_map': {
                    'subscriber_id': 'subscriber_id',
                },
                'location_map': {
                    'subscriber_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_cloud_connect_subscriber
        )

        def __list_cloud_connect_subscribers(
            self,
            **kwargs
        ):
            """List Subscribers  # noqa: E501

            List of subscribers in array  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_cloud_connect_subscribers(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [SubscriberResponse]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_cloud_connect_subscribers = _Endpoint(
            settings={
                'response_type': ([SubscriberResponse],),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/cloud/connect/subscribers',
                'operation_id': 'list_cloud_connect_subscribers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_cloud_connect_subscribers
        )

        def __show_cloud_connect_subscriber(
            self,
            subscriber_id,
            **kwargs
        ):
            """Show a Subscriber  # noqa: E501

            Show an existing subscribers by id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.show_cloud_connect_subscriber(subscriber_id, async_req=True)
            >>> result = thread.get()

            Args:
                subscriber_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SubscriberResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['subscriber_id'] = \
                subscriber_id
            return self.call_with_http_info(**kwargs)

        self.show_cloud_connect_subscriber = _Endpoint(
            settings={
                'response_type': (SubscriberResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/cloud/connect/subscribers/{subscriber_id}',
                'operation_id': 'show_cloud_connect_subscriber',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'subscriber_id',
                ],
                'required': [
                    'subscriber_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'subscriber_id':
                        (str,),
                },
                'attribute_map': {
                    'subscriber_id': 'subscriber_id',
                },
                'location_map': {
                    'subscriber_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__show_cloud_connect_subscriber
        )

        def __update_cloud_connect_subscriber(
            self,
            subscriber_id,
            subscriber_response,
            **kwargs
        ):
            """Update Subscriber  # noqa: E501

            Update an existing Subscriber by id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_cloud_connect_subscriber(subscriber_id, subscriber_response, async_req=True)
            >>> result = thread.get()

            Args:
                subscriber_id (str):
                subscriber_response (SubscriberResponse): Update an existing Subscriber by id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SubscriberResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['subscriber_id'] = \
                subscriber_id
            kwargs['subscriber_response'] = \
                subscriber_response
            return self.call_with_http_info(**kwargs)

        self.update_cloud_connect_subscriber = _Endpoint(
            settings={
                'response_type': (SubscriberResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/cloud/connect/subscribers/{subscriber_id}',
                'operation_id': 'update_cloud_connect_subscriber',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'subscriber_id',
                    'subscriber_response',
                ],
                'required': [
                    'subscriber_id',
                    'subscriber_response',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'subscriber_id':
                        (str,),
                    'subscriber_response':
                        (SubscriberResponse,),
                },
                'attribute_map': {
                    'subscriber_id': 'subscriber_id',
                },
                'location_map': {
                    'subscriber_id': 'path',
                    'subscriber_response': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_cloud_connect_subscriber
        )
