# swx_sdk
IN PROGRESS->This is the guide to use the different endpoints to manage the clusters.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.1
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swx_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swx_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import swx_sdk
from pprint import pprint
from swx_sdk.api import accounts_api
from swx_sdk.model.account import Account
from swx_sdk.model.accounts import Accounts
from swx_sdk.model.error_response import ErrorResponse
# Defining the host is optional and defaults to https://api.dev.altairsc.com
# See configuration.py for a list of all supported configuration parameters.
configuration = swx_sdk.Configuration(
    host = "https://api.dev.altairsc.com"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: OAuth2Security
configuration = swx_sdk.Configuration(
    host = "https://api.dev.altairsc.com"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# Configure OAuth2 access token for authorization: OAuth2Security
configuration = swx_sdk.Configuration(
    host = "https://api.dev.altairsc.com"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# Configure Bearer authorization (Opaque JWT): bearerAuth
configuration = swx_sdk.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with swx_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = accounts_api.AccountsApi(api_client)
    account = Account(
        created_at="2020-08-11T15:29:51",
        id="microsoft",
        name="Microsoft",
        owner="bgates",
        updated_at="2020-08-11T15:29:51",
    ) # Account | Body of a new Account

    try:
        # Create an Account
        api_response = api_instance.create_account(account)
        pprint(api_response)
    except swx_sdk.ApiException as e:
        print("Exception when calling AccountsApi->create_account: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.dev.altairsc.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountsApi* | [**create_account**](docs/AccountsApi.md#create_account) | **POST** /spaces | Create an Account
*AccountsApi* | [**delete_account**](docs/AccountsApi.md#delete_account) | **DELETE** /spaces/{space} | Delete an Account
*AccountsApi* | [**get_account**](docs/AccountsApi.md#get_account) | **GET** /spaces/{space} | Get an Account
*AccountsApi* | [**list_accounts**](docs/AccountsApi.md#list_accounts) | **GET** /spaces | List Accounts
*AccountsApi* | [**update_account**](docs/AccountsApi.md#update_account) | **PUT** /spaces/{space} | Update an Account
*AppsApi* | [**create_app**](docs/AppsApi.md#create_app) | **POST** /spaces/{space}/apps | Create an App
*AppsApi* | [**delete_app**](docs/AppsApi.md#delete_app) | **DELETE** /spaces/{space}/apps/{app_id} | Delete an App
*AppsApi* | [**get_app**](docs/AppsApi.md#get_app) | **GET** /spaces/{space}/apps/{app_id} | Get an App
*AppsApi* | [**list_apps**](docs/AppsApi.md#list_apps) | **GET** /spaces/{space}/apps | List Apps
*AppsApi* | [**patch_app**](docs/AppsApi.md#patch_app) | **PATCH** /spaces/{space}/apps/{app_id} | Patch an App
*AppsApi* | [**update_app**](docs/AppsApi.md#update_app) | **PUT** /spaces/{space}/apps/{app_id} | Update an App
*ClustersApi* | [**create_cluster**](docs/ClustersApi.md#create_cluster) | **POST** /spaces/{space}/clusters | Add a cluster
*ClustersApi* | [**delete_cluster**](docs/ClustersApi.md#delete_cluster) | **DELETE** /spaces/{space}/clusters/{cluster-id} | Delete cluster
*ClustersApi* | [**list_clusters**](docs/ClustersApi.md#list_clusters) | **GET** /spaces/{space}/clusters | List clusters
*ClustersApi* | [**reinstall_cluster**](docs/ClustersApi.md#reinstall_cluster) | **PUT** /spaces/{space}/clusters/{cluster-id}/reinstall | Regenerate configuration files
*ClustersApi* | [**reset_cluster_client_secret**](docs/ClustersApi.md#reset_cluster_client_secret) | **POST** /spaces/{space}/clusters/{cluster-id}/reset-secret | Reset Client Secret
*ClustersApi* | [**show_cluster**](docs/ClustersApi.md#show_cluster) | **GET** /spaces/{space}/clusters/{cluster-id} | Show cluster
*ClustersApi* | [**update_cluster**](docs/ClustersApi.md#update_cluster) | **PUT** /spaces/{space}/clusters/{cluster-id} | Update cluster
*DataApi* | [**create_data**](docs/DataApi.md#create_data) | **POST** /spaces/{space}/data | Create data
*DataApi* | [**delete_data**](docs/DataApi.md#delete_data) | **DELETE** /spaces/{space}/data/{data-id} | Delete Data
*DataApi* | [**delete_data_from_source**](docs/DataApi.md#delete_data_from_source) | **DELETE** /spaces/{space}/data | Delete Data
*DataApi* | [**list_data**](docs/DataApi.md#list_data) | **GET** /spaces/{space}/data | List Data
*DataApi* | [**show_data**](docs/DataApi.md#show_data) | **GET** /spaces/{space}/data/{data-id} | Show Data
*InvitationsApi* | [**create_invitation**](docs/InvitationsApi.md#create_invitation) | **POST** /spaces/{space}/invitations | Create a new Invitation
*InvitationsApi* | [**delete_sent_invitation**](docs/InvitationsApi.md#delete_sent_invitation) | **DELETE** /spaces/{space}/invitations/{invitation_id} | Delete an Invitation sent from Account
*InvitationsApi* | [**get_received_invitation**](docs/InvitationsApi.md#get_received_invitation) | **GET** /invitations/{invitation_id} | Get a received Invitation
*InvitationsApi* | [**get_sent_invitation**](docs/InvitationsApi.md#get_sent_invitation) | **GET** /spaces/{space}/invitations/{invitation_id} | Get an Invitation sent from an Account
*InvitationsApi* | [**list_received_invitations**](docs/InvitationsApi.md#list_received_invitations) | **GET** /invitations | List received Invitations
*InvitationsApi* | [**list_sent_invitations**](docs/InvitationsApi.md#list_sent_invitations) | **GET** /spaces/{space}/invitations | List Invitations sent from an Account
*InvitationsApi* | [**patch_received_invitation**](docs/InvitationsApi.md#patch_received_invitation) | **PATCH** /invitations/{invitation_id} | Accept / Reject a received Invitation
*InvitationsApi* | [**update_sent_invitation**](docs/InvitationsApi.md#update_sent_invitation) | **PUT** /spaces/{space}/invitations/{invitation_id} | Update an Invitation
*LabelApi* | [**create_label**](docs/LabelApi.md#create_label) | **POST** /spaces/{space}/labels | Create label
*LabelApi* | [**create_label_relation**](docs/LabelApi.md#create_label_relation) | **POST** /spaces/{space}/labels/{label-id}/relations | Create label relation
*LabelApi* | [**delete**](docs/LabelApi.md#delete) | **DELETE** /spaces/{space}/labels/{label-id}/relations | Delete Label relation
*LabelApi* | [**delete_label**](docs/LabelApi.md#delete_label) | **DELETE** /spaces/{space}/labels/{label-id} | Delete Label
*LabelApi* | [**list_label**](docs/LabelApi.md#list_label) | **GET** /spaces/{space}/labels | List Labels
*LabelApi* | [**show_label**](docs/LabelApi.md#show_label) | **GET** /spaces/{space}/labels/{label-id} | Show Label
*LabelApi* | [**show_label_items**](docs/LabelApi.md#show_label_items) | **GET** /spaces/{space}/labels/{label-id}/relations | Show Label Items
*LabelApi* | [**update_label**](docs/LabelApi.md#update_label) | **PUT** /spaces/{space}/labels/{label-id} | Update label
*LabeledEntitiesApi* | [**spaces_space_labeled_entities_get**](docs/LabeledEntitiesApi.md#spaces_space_labeled_entities_get) | **GET** /spaces/{space}/labeled-entities | 
*MQTTApi* | [**create_mqtt_label_credentials**](docs/MQTTApi.md#create_mqtt_label_credentials) | **POST** /spaces/{space}/mqtt/labels | Create MQTT credentials for a label
*MQTTApi* | [**delete_mqtt_label**](docs/MQTTApi.md#delete_mqtt_label) | **DELETE** /spaces/{space}/mqtt/labels/{label-id} | Delete MQTT label
*MQTTApi* | [**list_mqt_tcredentials**](docs/MQTTApi.md#list_mqt_tcredentials) | **GET** /spaces/{space}/mqtt/credentials | List space MQTT credentials
*MQTTApi* | [**list_thing_mqt_tcredentials**](docs/MQTTApi.md#list_thing_mqt_tcredentials) | **GET** /spaces/{space}/mqtt/things/{thing-id} | List Thing MQTT credentials
*MQTTApi* | [**show_mqt_tcredentials**](docs/MQTTApi.md#show_mqt_tcredentials) | **GET** /spaces/{space}/mqtt/credentials/{credentials-id} | Show MQTT credentials
*MQTTApi* | [**show_mqtt_label_info**](docs/MQTTApi.md#show_mqtt_label_info) | **GET** /spaces/{space}/mqtt/labels/{label-id} | Show MQTT label details
*MQTTApi* | [**update_mqt_tcredentials**](docs/MQTTApi.md#update_mqt_tcredentials) | **PUT** /spaces/{space}/mqtt/credentials/{credentials-id} | Update MQTT credentials
*MQTTApi* | [**update_mqt_tpassword**](docs/MQTTApi.md#update_mqt_tpassword) | **PATCH** /spaces/{space}/mqtt/credentials-username/{mqtt-username} | Update MQTT password
*MQTTApi* | [**update_mqtt_label**](docs/MQTTApi.md#update_mqtt_label) | **PUT** /spaces/{space}/mqtt/labels/{label-id} | Update MQTT Label
*OAuth2Api* | [**get_oauth2_auth**](docs/OAuth2Api.md#get_oauth2_auth) | **GET** /oauth2/auth | OAuth 2.0 Authorize Endpoint
*OAuth2Api* | [**get_oauth2_token**](docs/OAuth2Api.md#get_oauth2_token) | **POST** /oauth2/token | OAuth 2.0 Token Endpoint
*OAuth2Api* | [**post_oauth2_revoke**](docs/OAuth2Api.md#post_oauth2_revoke) | **POST** /oauth2/revoke | Revoke a token (Access or Refresh)
*OpenIDApi* | [**get_open_id_sessions_logout**](docs/OpenIDApi.md#get_open_id_sessions_logout) | **GET** /oauth2/sessions/logout | Initialize &amp; Complete User Logout
*OpenIDApi* | [**get_open_id_user_info**](docs/OpenIDApi.md#get_open_id_user_info) | **GET** /userinfo | Get the Payload of the ID Token.
*UsersApi* | [**delete_user_from_account**](docs/UsersApi.md#delete_user_from_account) | **DELETE** /spaces/{space}/users/{user_id} | Delete a User from an Account
*UsersApi* | [**get_user_from_account**](docs/UsersApi.md#get_user_from_account) | **GET** /spaces/{space}/users/{user_id} | Get a User from an Account
*UsersApi* | [**list_users_from_account**](docs/UsersApi.md#list_users_from_account) | **GET** /spaces/{space}/users | List Users from an Account
*ActionsApi* | [**add_action**](docs/ActionsApi.md#add_action) | **POST** /spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action} | Request action
*ActionsApi* | [**delete_action**](docs/ActionsApi.md#delete_action) | **DELETE** /spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action}/{action-id} | Delete Action
*ActionsApi* | [**list_actions**](docs/ActionsApi.md#list_actions) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/actions | Lists all the action queues for a thing
*ActionsApi* | [**list_actions_by_name**](docs/ActionsApi.md#list_actions_by_name) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action} | List the queue of actions from a thing
*ActionsApi* | [**show_action**](docs/ActionsApi.md#show_action) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action}/{action-id} | Show action requested
*ActionsApi* | [**update_action**](docs/ActionsApi.md#update_action) | **PUT** /spaces/{space}/collections/{collection-name}/things/{thing-id}/actions/{action}/{action-id} | Update action inside a queue
*BuildConfigsApi* | [**build_conf_create**](docs/BuildConfigsApi.md#build_conf_create) | **POST** /spaces/{space}/build-configs/ | Create Build Configuration
*BuildConfigsApi* | [**build_conf_delete**](docs/BuildConfigsApi.md#build_conf_delete) | **DELETE** /spaces/{space}/build-configs/{build-configID}/ | Delete Build Configuration
*BuildConfigsApi* | [**build_conf_get**](docs/BuildConfigsApi.md#build_conf_get) | **GET** /spaces/{space}/build-configs/{build-configID}/ | Get Build Configuration
*BuildConfigsApi* | [**build_conf_list**](docs/BuildConfigsApi.md#build_conf_list) | **GET** /spaces/{space}/build-configs/ | List Build Configuration
*BuildConfigsApi* | [**build_conf_update**](docs/BuildConfigsApi.md#build_conf_update) | **PUT** /spaces/{space}/build-configs/{build-configID}/ | Update Build Configuration
*BuildConfigsApi* | [**build_conf_update_parcialy**](docs/BuildConfigsApi.md#build_conf_update_parcialy) | **PATCH** /spaces/{space}/build-configs/{build-configID}/ | Update Build Configuration
*BuildConfigsApi* | [**build_generate_file**](docs/BuildConfigsApi.md#build_generate_file) | **POST** /spaces/{space}/build-configs/{build-configID}/generate-file | Create a temporary endpoint with the Build Configuration file
*CollectionsApi* | [**add_collection**](docs/CollectionsApi.md#add_collection) | **POST** /spaces/{space}/collections | Create collection
*CollectionsApi* | [**delete_collection**](docs/CollectionsApi.md#delete_collection) | **DELETE** /spaces/{space}/collections/{collection-name} | Delete collection
*CollectionsApi* | [**list_collections**](docs/CollectionsApi.md#list_collections) | **GET** /spaces/{space}/collections | List collections
*CollectionsApi* | [**show_collection**](docs/CollectionsApi.md#show_collection) | **GET** /spaces/{space}/collections/{collection-name} | Show collection
*CollectionsApi* | [**update_collection**](docs/CollectionsApi.md#update_collection) | **PUT** /spaces/{space}/collections/{collection-name} | Update collection
*EventsApi* | [**add_event**](docs/EventsApi.md#add_event) | **POST** /spaces/{space}/collections/{collection-name}/things/{thing-id}/events/{event} | Add event
*EventsApi* | [**list_events**](docs/EventsApi.md#list_events) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/events | List history of all events
*EventsApi* | [**list_events_by_name**](docs/EventsApi.md#list_events_by_name) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/events/{event} | List history of one type of event
*EventsApi* | [**show_event**](docs/EventsApi.md#show_event) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/events/{event}/{event-id} | Show event
*ModelVersionsApi* | [**add_version**](docs/ModelVersionsApi.md#add_version) | **POST** /spaces/{space}/collections/{collection-name}/models/{model-name}/versions | Create version
*ModelVersionsApi* | [**delete_version**](docs/ModelVersionsApi.md#delete_version) | **DELETE** /spaces/{space}/collections/{collection-name}/models/{model-name}/versions/{version-name} | Delete version
*ModelVersionsApi* | [**list_version**](docs/ModelVersionsApi.md#list_version) | **GET** /spaces/{space}/collections/{collection-name}/models/{model-name}/versions | List version
*ModelVersionsApi* | [**show_version**](docs/ModelVersionsApi.md#show_version) | **GET** /spaces/{space}/collections/{collection-name}/models/{model-name}/versions/{version-name} | Show version
*ModelVersionsApi* | [**update_version**](docs/ModelVersionsApi.md#update_version) | **PUT** /spaces/{space}/collections/{collection-name}/models/{model-name}/versions/{version-name} | Update version
*ModelsApi* | [**add_model**](docs/ModelsApi.md#add_model) | **POST** /spaces/{space}/collections/{collection-name}/models | Create model
*ModelsApi* | [**delete_model**](docs/ModelsApi.md#delete_model) | **DELETE** /spaces/{space}/collections/{collection-name}/models/{model-name} | Delete model
*ModelsApi* | [**list_models**](docs/ModelsApi.md#list_models) | **GET** /spaces/{space}/collections/{collection-name}/models | List models
*ModelsApi* | [**show_model**](docs/ModelsApi.md#show_model) | **GET** /spaces/{space}/collections/{collection-name}/models/{model-name} | Show model
*ModelsApi* | [**update_model**](docs/ModelsApi.md#update_model) | **PUT** /spaces/{space}/collections/{collection-name}/models/{model-name} | Update model
*PropertiesApi* | [**list_properties**](docs/PropertiesApi.md#list_properties) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/properties | List properties
*PropertiesApi* | [**show_property**](docs/PropertiesApi.md#show_property) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id}/properties/{property} | Show property
*PropertiesApi* | [**update_property**](docs/PropertiesApi.md#update_property) | **PUT** /spaces/{space}/collections/{collection-name}/things/{thing-id}/properties/{property} | Update property
*ResourcesApi* | [**resource_delete**](docs/ResourcesApi.md#resource_delete) | **DELETE** /spaces/{space}/resources/{resourceID}/ | Delete Resources
*ResourcesApi* | [**resources_create**](docs/ResourcesApi.md#resources_create) | **POST** /spaces/{space}/resources/ | Create Resources
*ResourcesApi* | [**resources_get**](docs/ResourcesApi.md#resources_get) | **GET** /spaces/{space}/resources/{resourceID}/ | Get Resources
*ResourcesApi* | [**resources_list**](docs/ResourcesApi.md#resources_list) | **GET** /spaces/{space}/resources/ | List Resources
*ResourcesApi* | [**service_delete_params**](docs/ResourcesApi.md#service_delete_params) | **DELETE** /spaces/{space}/resources/{resourceID}/params/{paramsID} | Delete params
*ResourcesApi* | [**service_set_params**](docs/ResourcesApi.md#service_set_params) | **PUT** /spaces/{space}/resources/{resourceID}/params | Set custom params
*ResourcesApi* | [**service_update**](docs/ResourcesApi.md#service_update) | **PUT** /spaces/{space}/resources/{resourceID}/ | Update Resources
*ResourcesApi* | [**service_update_params**](docs/ResourcesApi.md#service_update_params) | **PUT** /spaces/{space}/resources/{resourceID}/params/{paramsID} | Update custom params
*ThingsApi* | [**add_thing**](docs/ThingsApi.md#add_thing) | **POST** /spaces/{space}/collections/{collection-name}/things | Add a thing description
*ThingsApi* | [**delete_thing**](docs/ThingsApi.md#delete_thing) | **DELETE** /spaces/{space}/collections/{collection-name}/things/{thing-id} | Delete thing
*ThingsApi* | [**list_things**](docs/ThingsApi.md#list_things) | **GET** /spaces/{space}/collections/{collection-name}/things | List thing descriptions
*ThingsApi* | [**reset_thing_client_secret**](docs/ThingsApi.md#reset_thing_client_secret) | **POST** /spaces/{space}/collections/{collection-name}/things/{thing-id}/reset-secret | Reset Client Secret
*ThingsApi* | [**show_thing**](docs/ThingsApi.md#show_thing) | **GET** /spaces/{space}/collections/{collection-name}/things/{thing-id} | Show thing
*ThingsApi* | [**update_thing**](docs/ThingsApi.md#update_thing) | **PUT** /spaces/{space}/collections/{collection-name}/things/{thing-id} | Update thing description
*ThingsStatusApi* | [**list_items**](docs/ThingsStatusApi.md#list_items) | **GET** /spaces/{space}/collections/{collection-name}/things-status | List items
*ThingsStatusApi* | [**show_item**](docs/ThingsStatusApi.md#show_item) | **GET** /spaces/{space}/collections/{collection-name}/things-status/{thing-id} | Show item


## Documentation For Models

 - [Account](docs/Account.md)
 - [AccountUserInfo](docs/AccountUserInfo.md)
 - [Accounts](docs/Accounts.md)
 - [ActionDelay](docs/ActionDelay.md)
 - [ActionDelayInput](docs/ActionDelayInput.md)
 - [ActionDelayInputProperties](docs/ActionDelayInputProperties.md)
 - [ActionDelayInputPropertiesInput](docs/ActionDelayInputPropertiesInput.md)
 - [ActionDelayListResponse](docs/ActionDelayListResponse.md)
 - [ActionDelayListResponsePaging](docs/ActionDelayListResponsePaging.md)
 - [ActionDelayResponse](docs/ActionDelayResponse.md)
 - [ActionDelayResponseLinks](docs/ActionDelayResponseLinks.md)
 - [ActionListResponse](docs/ActionListResponse.md)
 - [ActionReboot](docs/ActionReboot.md)
 - [ActionRebootResponse](docs/ActionRebootResponse.md)
 - [ActionRequest](docs/ActionRequest.md)
 - [ActionResponse](docs/ActionResponse.md)
 - [ActionResponseElement1](docs/ActionResponseElement1.md)
 - [ActionResponseElement1Delay](docs/ActionResponseElement1Delay.md)
 - [ActionResponseElement1DelayInput](docs/ActionResponseElement1DelayInput.md)
 - [ActionResponseElement2](docs/ActionResponseElement2.md)
 - [ActionResponseElement2Delay](docs/ActionResponseElement2Delay.md)
 - [ActionResponseElement2DelayInput](docs/ActionResponseElement2DelayInput.md)
 - [ActionResponseElement3](docs/ActionResponseElement3.md)
 - [ActionResponseElement3Reboot](docs/ActionResponseElement3Reboot.md)
 - [ActionRunStats](docs/ActionRunStats.md)
 - [ActionRunStatsInput](docs/ActionRunStatsInput.md)
 - [ActionRunStatsInputProperties](docs/ActionRunStatsInputProperties.md)
 - [ActionRunStatsInputPropertiesInterval](docs/ActionRunStatsInputPropertiesInterval.md)
 - [ActionSendKubectl](docs/ActionSendKubectl.md)
 - [ActionSendKubectlInput](docs/ActionSendKubectlInput.md)
 - [ActionSendKubectlInputProperties](docs/ActionSendKubectlInputProperties.md)
 - [ActionSendKubectlInputPropertiesArguments](docs/ActionSendKubectlInputPropertiesArguments.md)
 - [ActionSendKubectlInputPropertiesCommand](docs/ActionSendKubectlInputPropertiesCommand.md)
 - [ActionStopStats](docs/ActionStopStats.md)
 - [ActionUpdateRequest](docs/ActionUpdateRequest.md)
 - [ActionUpdateResponse](docs/ActionUpdateResponse.md)
 - [App](docs/App.md)
 - [AppCreation](docs/AppCreation.md)
 - [AppType](docs/AppType.md)
 - [Apps](docs/Apps.md)
 - [AuthCodeConfig](docs/AuthCodeConfig.md)
 - [AuthZError](docs/AuthZError.md)
 - [AuthZErrorError](docs/AuthZErrorError.md)
 - [BaseError](docs/BaseError.md)
 - [BaseErrorError](docs/BaseErrorError.md)
 - [CollectionListResponse](docs/CollectionListResponse.md)
 - [CollectionRequest](docs/CollectionRequest.md)
 - [CollectionResponse](docs/CollectionResponse.md)
 - [CollectionUpdateRequest](docs/CollectionUpdateRequest.md)
 - [CollectionUpdateResponse](docs/CollectionUpdateResponse.md)
 - [CreateCluster](docs/CreateCluster.md)
 - [CreateClusterResponse](docs/CreateClusterResponse.md)
 - [CreateData](docs/CreateData.md)
 - [CreateDataResponse](docs/CreateDataResponse.md)
 - [CreateLabel](docs/CreateLabel.md)
 - [CreateLabelRelation](docs/CreateLabelRelation.md)
 - [CreateLabelResponse](docs/CreateLabelResponse.md)
 - [CredentialsResponseList](docs/CredentialsResponseList.md)
 - [CredentialsResponsePUT](docs/CredentialsResponsePUT.md)
 - [CredentialsResponseThing](docs/CredentialsResponseThing.md)
 - [CredentialsStudio](docs/CredentialsStudio.md)
 - [CredentialsThing](docs/CredentialsThing.md)
 - [DataElement](docs/DataElement.md)
 - [DataListElement1](docs/DataListElement1.md)
 - [DataListElement2](docs/DataListElement2.md)
 - [DataListElement3](docs/DataListElement3.md)
 - [DataPagingBuildConfigs](docs/DataPagingBuildConfigs.md)
 - [DataPagingResources](docs/DataPagingResources.md)
 - [DeleteClusterResponse](docs/DeleteClusterResponse.md)
 - [DeleteClusterResponseErrorClusterBackend](docs/DeleteClusterResponseErrorClusterBackend.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [ErrorResponseError](docs/ErrorResponseError.md)
 - [EventDeploymentStats](docs/EventDeploymentStats.md)
 - [EventHighCPU](docs/EventHighCPU.md)
 - [EventHighCPUData](docs/EventHighCPUData.md)
 - [EventHighCPUListResponse](docs/EventHighCPUListResponse.md)
 - [EventHighCPUResponse](docs/EventHighCPUResponse.md)
 - [EventKubectlLogs](docs/EventKubectlLogs.md)
 - [EventKubectlLogsData](docs/EventKubectlLogsData.md)
 - [EventListResponse](docs/EventListResponse.md)
 - [EventNodesStats](docs/EventNodesStats.md)
 - [EventRequest](docs/EventRequest.md)
 - [EventResponse](docs/EventResponse.md)
 - [EventResponse1](docs/EventResponse1.md)
 - [EventResponse1HighCPU](docs/EventResponse1HighCPU.md)
 - [EventResponse2](docs/EventResponse2.md)
 - [EventResponse2HighCPU](docs/EventResponse2HighCPU.md)
 - [Invitation](docs/Invitation.md)
 - [Invitations](docs/Invitations.md)
 - [LabelDeleteResponse](docs/LabelDeleteResponse.md)
 - [LabelListElement1](docs/LabelListElement1.md)
 - [LabelListElementRelations](docs/LabelListElementRelations.md)
 - [LabelListResponse](docs/LabelListResponse.md)
 - [LabelRelationElement1](docs/LabelRelationElement1.md)
 - [LabeledListItem1](docs/LabeledListItem1.md)
 - [LabeledListResponse](docs/LabeledListResponse.md)
 - [ListClustersResponse](docs/ListClustersResponse.md)
 - [ListClustersResponseElement1](docs/ListClustersResponseElement1.md)
 - [ListClustersResponseElement1Properties](docs/ListClustersResponseElement1Properties.md)
 - [ListClustersResponseElement2](docs/ListClustersResponseElement2.md)
 - [ListDataResponse](docs/ListDataResponse.md)
 - [MQTTAccountActions](docs/MQTTAccountActions.md)
 - [MQTTAccountData](docs/MQTTAccountData.md)
 - [MQTTAccountEvents](docs/MQTTAccountEvents.md)
 - [MQTTAccountPattern1](docs/MQTTAccountPattern1.md)
 - [MQTTAccountPattern2](docs/MQTTAccountPattern2.md)
 - [MQTTAccountPattern3](docs/MQTTAccountPattern3.md)
 - [MQTTAccountProperties](docs/MQTTAccountProperties.md)
 - [MQTTLabel](docs/MQTTLabel.md)
 - [MQTTLabelCredentials](docs/MQTTLabelCredentials.md)
 - [MQTTLabelDeleteResponse](docs/MQTTLabelDeleteResponse.md)
 - [MQTTLabelShowResponse](docs/MQTTLabelShowResponse.md)
 - [MQTTPOSTBody](docs/MQTTPOSTBody.md)
 - [MQTTPOSTResponse](docs/MQTTPOSTResponse.md)
 - [MQTTPUTBody](docs/MQTTPUTBody.md)
 - [MQTTPassword](docs/MQTTPassword.md)
 - [ModelListResponse](docs/ModelListResponse.md)
 - [ModelProperty](docs/ModelProperty.md)
 - [ModelRequest](docs/ModelRequest.md)
 - [ModelResponse](docs/ModelResponse.md)
 - [ModelUpdateRequest](docs/ModelUpdateRequest.md)
 - [ModelUpdateResponse](docs/ModelUpdateResponse.md)
 - [ModelVersionListResponse](docs/ModelVersionListResponse.md)
 - [ModelVersionRequest](docs/ModelVersionRequest.md)
 - [ModelVersionResponse](docs/ModelVersionResponse.md)
 - [ModelsBuildConfigGenerateFile](docs/ModelsBuildConfigGenerateFile.md)
 - [ModelsBuildConfigRequest](docs/ModelsBuildConfigRequest.md)
 - [ModelsBuildConfigResponse](docs/ModelsBuildConfigResponse.md)
 - [ModelsResourcesDeleteResponse](docs/ModelsResourcesDeleteResponse.md)
 - [ModelsResourcesFullJsonCustomBinder](docs/ModelsResourcesFullJsonCustomBinder.md)
 - [ModelsResourcesFullJsonValuesCustom1](docs/ModelsResourcesFullJsonValuesCustom1.md)
 - [ModelsResourcesFullJsonValuesCustom2](docs/ModelsResourcesFullJsonValuesCustom2.md)
 - [ModelsResourcesRequest](docs/ModelsResourcesRequest.md)
 - [ModelsResourcesResponse](docs/ModelsResourcesResponse.md)
 - [ModelsResourcesResponseList](docs/ModelsResourcesResponseList.md)
 - [ModelsResourcesResponseShow](docs/ModelsResourcesResponseShow.md)
 - [ModelsResourcesSetParams](docs/ModelsResourcesSetParams.md)
 - [ModelsResourcesSetParamsResponse](docs/ModelsResourcesSetParamsResponse.md)
 - [Properties](docs/Properties.md)
 - [PropertyBuildConfiguration](docs/PropertyBuildConfiguration.md)
 - [PropertyCPU](docs/PropertyCPU.md)
 - [PropertyCPUResponse](docs/PropertyCPUResponse.md)
 - [PropertyDisk](docs/PropertyDisk.md)
 - [PropertyDiskResponse](docs/PropertyDiskResponse.md)
 - [PropertyMasterNode](docs/PropertyMasterNode.md)
 - [PropertyMemory](docs/PropertyMemory.md)
 - [PropertyMemoryResponse](docs/PropertyMemoryResponse.md)
 - [PropertyStatus](docs/PropertyStatus.md)
 - [Secret](docs/Secret.md)
 - [ShowClusterResponse](docs/ShowClusterResponse.md)
 - [ThingCreateResponse](docs/ThingCreateResponse.md)
 - [ThingCreateResponseCredentials](docs/ThingCreateResponseCredentials.md)
 - [ThingCreateResponseCredentialsHttp](docs/ThingCreateResponseCredentialsHttp.md)
 - [ThingCreateResponseCredentialsMqtt](docs/ThingCreateResponseCredentialsMqtt.md)
 - [ThingCreateResponseCredentialsMqttData](docs/ThingCreateResponseCredentialsMqttData.md)
 - [ThingCreateResponseCredentialsMqttThing](docs/ThingCreateResponseCredentialsMqttThing.md)
 - [ThingCreateResponseLinks](docs/ThingCreateResponseLinks.md)
 - [ThingCreateResponseModel](docs/ThingCreateResponseModel.md)
 - [ThingListResponse](docs/ThingListResponse.md)
 - [ThingObjectDeleteResponse](docs/ThingObjectDeleteResponse.md)
 - [ThingRequest](docs/ThingRequest.md)
 - [ThingResponse](docs/ThingResponse.md)
 - [ThingStatusListResponse](docs/ThingStatusListResponse.md)
 - [ThingStatusResponse](docs/ThingStatusResponse.md)
 - [ThingUpdateRequest](docs/ThingUpdateRequest.md)
 - [ThingUpdateResponse](docs/ThingUpdateResponse.md)
 - [TokenResponse](docs/TokenResponse.md)
 - [UpdateCluster](docs/UpdateCluster.md)
 - [UpdateClusterResponse](docs/UpdateClusterResponse.md)
 - [UpdateClusterResponseActions](docs/UpdateClusterResponseActions.md)
 - [UpdateClusterResponseEvents](docs/UpdateClusterResponseEvents.md)
 - [UpdateClusterResponseProperties](docs/UpdateClusterResponseProperties.md)
 - [User](docs/User.md)
 - [Users](docs/Users.md)


## Documentation For Authorization


## OAuth2Security

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **offline**: Offline scope
 - **openid**: OpenId scope


## OAuth2Security

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: http://127.0.0.1:4444/oauth2/auth
- **Scopes**: 
 - **offline**: Offline scope
 - **openid**: OpenId scope


## bearerAuth

- **Type**: Bearer authentication (Opaque JWT)


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in swx_sdk.apis and swx_sdk.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from swx_sdk.api.default_api import DefaultApi`
- `from swx_sdk.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import swx_sdk
from swx_sdk.apis import *
from swx_sdk.models import *
```

LICENSE
This project is licensed under the MIT License - see the license file for details.
