"""
    Accounts & Users Service - Public API

    IN PROGRESS->This is the guide to use the different endpoints to manage the clusters.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from swx_sdk.api_client import ApiClient, Endpoint as _Endpoint
from swx_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from swx_sdk.model.create_cluster import CreateCluster
from swx_sdk.model.create_cluster_response import CreateClusterResponse
from swx_sdk.model.delete_cluster_response import DeleteClusterResponse
from swx_sdk.model.error_response import ErrorResponse
from swx_sdk.model.list_clusters_response import ListClustersResponse
from swx_sdk.model.secret import Secret
from swx_sdk.model.show_cluster_response import ShowClusterResponse
from swx_sdk.model.update_cluster import UpdateCluster
from swx_sdk.model.update_cluster_response import UpdateClusterResponse


class ClustersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_cluster(
            self,
            space,
            create_cluster,
            **kwargs
        ):
            """Add a cluster  # noqa: E501

            Add a new cluster to the platform  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_cluster(space, create_cluster, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                create_cluster (CreateCluster): Create a new cluster in the platform

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateClusterResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['create_cluster'] = \
                create_cluster
            return self.call_with_http_info(**kwargs)

        self.create_cluster = _Endpoint(
            settings={
                'response_type': (CreateClusterResponse,),
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/clusters',
                'operation_id': 'create_cluster',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'create_cluster',
                ],
                'required': [
                    'space',
                    'create_cluster',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'create_cluster':
                        (CreateCluster,),
                },
                'attribute_map': {
                    'space': 'space',
                },
                'location_map': {
                    'space': 'path',
                    'create_cluster': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_cluster
        )

        def __delete_cluster(
            self,
            space,
            cluster_id,
            **kwargs
        ):
            """Delete cluster  # noqa: E501

            Deletes all the existing information from a specific cluster  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_cluster(space, cluster_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                cluster_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DeleteClusterResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['cluster_id'] = \
                cluster_id
            return self.call_with_http_info(**kwargs)

        self.delete_cluster = _Endpoint(
            settings={
                'response_type': (DeleteClusterResponse,),
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/clusters/{cluster-id}',
                'operation_id': 'delete_cluster',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'cluster_id',
                ],
                'required': [
                    'space',
                    'cluster_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'cluster_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'cluster_id': 'cluster-id',
                },
                'location_map': {
                    'space': 'path',
                    'cluster_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_cluster
        )

        def __list_clusters(
            self,
            space,
            **kwargs
        ):
            """List clusters  # noqa: E501

            List all cluster of a specific space in an array  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_clusters(space, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListClustersResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            return self.call_with_http_info(**kwargs)

        self.list_clusters = _Endpoint(
            settings={
                'response_type': (ListClustersResponse,),
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/clusters',
                'operation_id': 'list_clusters',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                ],
                'required': [
                    'space',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                },
                'location_map': {
                    'space': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_clusters
        )

        def __reinstall_cluster(
            self,
            space,
            cluster_id,
            **kwargs
        ):
            """Regenerate configuration files  # noqa: E501

            Regenerate configuration files for a specific cluster  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.reinstall_cluster(space, cluster_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                cluster_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateClusterResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['cluster_id'] = \
                cluster_id
            return self.call_with_http_info(**kwargs)

        self.reinstall_cluster = _Endpoint(
            settings={
                'response_type': (CreateClusterResponse,),
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/clusters/{cluster-id}/reinstall',
                'operation_id': 'reinstall_cluster',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'cluster_id',
                ],
                'required': [
                    'space',
                    'cluster_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'cluster_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'cluster_id': 'cluster-id',
                },
                'location_map': {
                    'space': 'path',
                    'cluster_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__reinstall_cluster
        )

        def __reset_cluster_client_secret(
            self,
            space,
            cluster_id,
            **kwargs
        ):
            """Reset Client Secret  # noqa: E501

            Reset the Client Secret for a specific cluster  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.reset_cluster_client_secret(space, cluster_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                cluster_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Secret
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['cluster_id'] = \
                cluster_id
            return self.call_with_http_info(**kwargs)

        self.reset_cluster_client_secret = _Endpoint(
            settings={
                'response_type': (Secret,),
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/clusters/{cluster-id}/reset-secret',
                'operation_id': 'reset_cluster_client_secret',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'cluster_id',
                ],
                'required': [
                    'space',
                    'cluster_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'cluster_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'cluster_id': 'cluster-id',
                },
                'location_map': {
                    'space': 'path',
                    'cluster_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__reset_cluster_client_secret
        )

        def __show_cluster(
            self,
            space,
            cluster_id,
            **kwargs
        ):
            """Show cluster  # noqa: E501

            Show a specific cluster  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.show_cluster(space, cluster_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                cluster_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ShowClusterResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['cluster_id'] = \
                cluster_id
            return self.call_with_http_info(**kwargs)

        self.show_cluster = _Endpoint(
            settings={
                'response_type': (ShowClusterResponse,),
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/clusters/{cluster-id}',
                'operation_id': 'show_cluster',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'cluster_id',
                ],
                'required': [
                    'space',
                    'cluster_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'cluster_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'cluster_id': 'cluster-id',
                },
                'location_map': {
                    'space': 'path',
                    'cluster_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__show_cluster
        )

        def __update_cluster(
            self,
            space,
            cluster_id,
            update_cluster,
            **kwargs
        ):
            """Update cluster  # noqa: E501

            Update a specific cluster  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_cluster(space, cluster_id, update_cluster, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                cluster_id (str):
                update_cluster (UpdateCluster): Update a scpecific cluster

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpdateClusterResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['cluster_id'] = \
                cluster_id
            kwargs['update_cluster'] = \
                update_cluster
            return self.call_with_http_info(**kwargs)

        self.update_cluster = _Endpoint(
            settings={
                'response_type': (UpdateClusterResponse,),
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/clusters/{cluster-id}',
                'operation_id': 'update_cluster',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'cluster_id',
                    'update_cluster',
                ],
                'required': [
                    'space',
                    'cluster_id',
                    'update_cluster',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'cluster_id':
                        (str,),
                    'update_cluster':
                        (UpdateCluster,),
                },
                'attribute_map': {
                    'space': 'space',
                    'cluster_id': 'cluster-id',
                },
                'location_map': {
                    'space': 'path',
                    'cluster_id': 'path',
                    'update_cluster': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_cluster
        )
