"""
    Accounts & Users Service - Public API

    IN PROGRESS->This is the guide to use the different endpoints to manage the clusters.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from swx_sdk.api_client import ApiClient, Endpoint as _Endpoint
from swx_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from swx_sdk.model.labeled_list_response import LabeledListResponse


class LabeledEntitiesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __spaces_space_labeled_entities_get(
            self,
            space,
            entity_id,
            label_id,
            label_name,
            entity_type,
            **kwargs
        ):
            """spaces_space_labeled_entities_get  # noqa: E501

            Show entity_ids and their labels. At least one of the following parameters must be present **entity_id, entity_type, label_id, label_name**  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.spaces_space_labeled_entities_get(space, entity_id, label_id, label_name, entity_type, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                entity_id ([str]):
                label_id ([str]):
                label_name ([str]):
                entity_type (str): filter that shows only a certain type of entity

            Keyword Args:
                collection_name (str): filter that shows entities and their labels of a certain collection. **Only available for thing entity type**. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LabeledListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['entity_id'] = \
                entity_id
            kwargs['label_id'] = \
                label_id
            kwargs['label_name'] = \
                label_name
            kwargs['entity_type'] = \
                entity_type
            return self.call_with_http_info(**kwargs)

        self.spaces_space_labeled_entities_get = _Endpoint(
            settings={
                'response_type': (LabeledListResponse,),
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/labeled-entities',
                'operation_id': 'spaces_space_labeled_entities_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'entity_id',
                    'label_id',
                    'label_name',
                    'entity_type',
                    'collection_name',
                ],
                'required': [
                    'space',
                    'entity_id',
                    'label_id',
                    'label_name',
                    'entity_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'entity_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('entity_type',): {

                        "THING": "thing",
                        "FUNCTION": "function",
                        "BUILD_CONFIG": "build_config",
                        "RESOURCE": "resource"
                    },
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'entity_id':
                        ([str],),
                    'label_id':
                        ([str],),
                    'label_name':
                        ([str],),
                    'entity_type':
                        (str,),
                    'collection_name':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'entity_id': 'entity_id',
                    'label_id': 'label_id',
                    'label_name': 'label_name',
                    'entity_type': 'entity_type',
                    'collection_name': 'collection_name',
                },
                'location_map': {
                    'space': 'path',
                    'entity_id': 'query',
                    'label_id': 'query',
                    'label_name': 'query',
                    'entity_type': 'query',
                    'collection_name': 'query',
                },
                'collection_format_map': {
                    'entity_id': 'multi',
                    'label_id': 'multi',
                    'label_name': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__spaces_space_labeled_entities_get
        )
