"""
    Accounts & Users Service - Public API

    IN PROGRESS->This is the guide to use the different endpoints to manage the clusters.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from swx_sdk.api_client import ApiClient, Endpoint as _Endpoint
from swx_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)


class OpenIDApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __get_open_id_sessions_logout(
            self,
            **kwargs
        ):
            """Initialize & Complete User Logout  # noqa: E501

            This endpoint initiates and completes user logout at ORY Hydra and initiates OpenID Connect Front-/Back-channel logout.<br/> A logout request may be initiated by the OpenID Provider (OP - **you**) or by the Relying Party (RP - the OAuth2 Client): - The OP-initiated flow does not need an `id_token_hint`, and it may neither define a state nor a `post_logout_redirect_uri`. (**You need a valid session cookie!!**) - The RP-initiated flow needs an `id_token_hint` and may optionally define state and `post_logout_redirect_uri`.<br/> Before the logout is completed, the user is redirected to the Logout UI to confirm the logout request.<br/> There are several possible pathways for executing this flow, explained in the following diagram:<br/><br/> <center><img width=\"60%\" src=\"https://mermaid.ink/img/eyJjb2RlIjoiZ3JhcGggVEQ7XG4gICAgSVtHRVQgL29hdXRoMi9zZXNzaW9uL2xvZ291dF0tLT58aGFzIGlkX3Rva2VuX2hpbnQqfFJQSVtSUC1pbml0aWF0ZWQgbG9nb3V0XTtcbiAgICBJW0dFVCAvb2F1dGgyL3Nlc3Npb24vbG9nb3V0XS0tPnxkb2VzIG5vdCBoYXZlIGlkX3Rva2VuX2hpbnQqfE9QSVtPUC1pbml0aWF0ZWQgbG9nb3V0XVxuT1BJLS0-fGhhcyBzdGF0ZSp8RVtFcnJvcl1cbk9QSS0tPnxoYXMgcG9zdF9sb2dvdXRfdXJpKnxFW0Vycm9yXVxuT1BJLS0-fGhhcyB2YWxpZCBzZXNzaW9uIGNvb2tpZXxMVUlbTG9nb3V0IFVJIHdpdGggP2xvZ291dF9jaGFsbGVuZ2U9Li4uXVxuT1BJLS0-fGhhcyBubyB2YWxpZCBzZXNpb24gY29va2llfEVuZFtSZXR1cm4gdG8gcG9zdF9sb2dvdXRfdXJsKioqXVxuUlBJLS0-fGhhcyBhY3RpdmUgc2Vzc2lvbioqKip8TFVJXG5SUEktLT58bm8gYWN0aXZlIHNlc3Npb24qKioqfFJQSTJcbkxVSS0tPnx2ZXJpZnkgbG9nb3V0IHJlcXVlc3R8TFVJXG5MVUktLT58cmVkaXJlY3Qgd2l0aCBsb2dvdXRfdmVyaWZpZXIqfFJQSTJbIC9vYXV0aDIvc2Vzc2lvbnMvbG9nb3V0P2xvZ291dF92ZXJpZmllcj0uLi5dXG5SUEkyLS0-fGV4ZWN1dGUgZnJvbnQvYmFja2NoYW5uZWwgbG9nb3V0LCByZXZva2UgY29va2llfFJQSTJcblJQSTItLT58UmVkaXJlY3QgdG98RW5kIiwibWVybWFpZCI6eyJ0aGVtZSI6ImRlZmF1bHQifX0\"></center><br/> **Legend**: - **\\***: This is a query parameter, for example <b>/oauth2/sessions/logout?id_token_hint=...</b> - **\\*\\*** Here, an **\"active session\"** implies that there has been at least one login request completed with `remember: true` for that user. If that's not the case, the system **\"does not know\"** what to do (because there has never been a session issued that was remembered - hence it's not possible to forget it). - **\\*\\*\\***: Here, the **\"valid session cookies\"** implies that the browser has a valid authentication cookie when calling `/oauth2/sessions/logout`. If you have problems at this step, check if there is a cookie `oauth2_authentication_session` for the domain ORY Hydra is running at!! - **\\*\\*\\*\\***: The `post_logout_redirect` defaults to the configuration value of `urls.post_logout_redirect`. If it's an RP-initiated flow and a `post_logout_redirect_uri` was set and that URL is in the array of the OAuth2 Client's `urls.post_logout_redirect`, the browser will be redirected there instead.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_open_id_sessions_logout(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                id_token_hint (str): When the user is redirected to the logout endpoint in a web site or similar, they will be prompted if they really want to sign-out.<br/> This prompt can be bypassed by a client sending the original `id_token` received from authentication.<br/> This is passed as a query string parameter called `id_token_hint`. . [optional]
                post_logout_redirect_uri (str): If a valid `id_token_hint` is passed, then the client may also send a `post_logout_redirect_uri` parameter.<br/> This can be used to allow the user to redirect back to the client after sign-out.<br/> The value must match one of the client’s pre-configured `post_logout_redirect_uri`. . [optional]
                state (str): The `state` is an value that is carried through the whole flow and returned to the client.<br/> This is used to prevent [CSRF attacks](https://www.owasp.org/index.php/Cross-Site_Request_Forgery_%28CSRF%29).. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_open_id_sessions_logout = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/oauth2/sessions/logout',
                'operation_id': 'get_open_id_sessions_logout',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id_token_hint',
                    'post_logout_redirect_uri',
                    'state',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id_token_hint':
                        (str,),
                    'post_logout_redirect_uri':
                        (str,),
                    'state':
                        (str,),
                },
                'attribute_map': {
                    'id_token_hint': 'id_token_hint',
                    'post_logout_redirect_uri': 'post_logout_redirect_uri',
                    'state': 'state',
                },
                'location_map': {
                    'id_token_hint': 'query',
                    'post_logout_redirect_uri': 'query',
                    'state': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_open_id_sessions_logout
        )

        def __get_open_id_user_info(
            self,
            **kwargs
        ):
            """Get the Payload of the ID Token.  # noqa: E501

            This endpoint returns the payload of the ID Token, including the idTokenExtra values, of the provided OAuth 2.0 Access Token.<br/> **NOT all info of this example is really included, this endpoint is high customizable, this is need added in the backend!**   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_open_id_user_info(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_open_id_user_info = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/userinfo',
                'operation_id': 'get_open_id_user_info',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/jwt',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_open_id_user_info
        )
