"""
    Accounts & Users Service - Public API

    IN PROGRESS->This is the guide to use the different endpoints to manage the clusters.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from swx_sdk.api_client import ApiClient, Endpoint as _Endpoint
from swx_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from swx_sdk.model.auth_z_error import AuthZError
from swx_sdk.model.base_error import BaseError
from swx_sdk.model.create_data_response import CreateDataResponse
from swx_sdk.model.list_data_response import ListDataResponse


class DataApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_data(
            self,
            space,
            body,
            **kwargs
        ):
            """Create data  # noqa: E501

            Send a new data to the platform  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_data(space, body, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                body (bool, date, datetime, dict, float, int, list, str, none_type):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateDataResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.create_data = _Endpoint(
            settings={
                'response_type': (CreateDataResponse,),
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/data',
                'operation_id': 'create_data',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'body',
                ],
                'required': [
                    'space',
                    'body',
                ],
                'nullable': [
                    'body',
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'body':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                },
                'attribute_map': {
                    'space': 'space',
                },
                'location_map': {
                    'space': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__create_data
        )

        def __delete_data(
            self,
            space,
            data_id,
            **kwargs
        ):
            """Delete Data  # noqa: E501

            Deletes an existing data by Id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_data(space, data_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                data_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['data_id'] = \
                data_id
            return self.call_with_http_info(**kwargs)

        self.delete_data = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/data/{data-id}',
                'operation_id': 'delete_data',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'data_id',
                ],
                'required': [
                    'space',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'data_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'data_id': 'data-id',
                },
                'location_map': {
                    'space': 'path',
                    'data_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_data
        )

        def __delete_data_from_source(
            self,
            space,
            source,
            **kwargs
        ):
            """Delete Data  # noqa: E501

            Deletes an existing data by source  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_data_from_source(space, source, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                source (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['source'] = \
                source
            return self.call_with_http_info(**kwargs)

        self.delete_data_from_source = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/data',
                'operation_id': 'delete_data_from_source',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'source',
                ],
                'required': [
                    'space',
                    'source',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'source':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'source': 'source[]',
                },
                'location_map': {
                    'space': 'path',
                    'source': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_data_from_source
        )

        def __list_data(
            self,
            space,
            source,
            **kwargs
        ):
            """List Data  # noqa: E501

            List of all the data in array  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_data(space, source, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                source (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListDataResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['source'] = \
                source
            return self.call_with_http_info(**kwargs)

        self.list_data = _Endpoint(
            settings={
                'response_type': (ListDataResponse,),
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/data',
                'operation_id': 'list_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'source',
                ],
                'required': [
                    'space',
                    'source',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'source':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'source': 'source[]',
                },
                'location_map': {
                    'space': 'path',
                    'source': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_data
        )

        def __show_data(
            self,
            space,
            data_id,
            **kwargs
        ):
            """Show Data  # noqa: E501

            Show an existing data by Id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.show_data(space, data_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                data_id (str):

            Keyword Args:
                download (bool): [optional]
                metadata (bool): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                bool, date, datetime, dict, float, int, list, str, none_type
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['data_id'] = \
                data_id
            return self.call_with_http_info(**kwargs)

        self.show_data = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/data/{data-id}',
                'operation_id': 'show_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'data_id',
                    'download',
                    'metadata',
                ],
                'required': [
                    'space',
                    'data_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'data_id':
                        (str,),
                    'download':
                        (bool,),
                    'metadata':
                        (bool,),
                },
                'attribute_map': {
                    'space': 'space',
                    'data_id': 'data-id',
                    'download': 'download',
                    'metadata': 'metadata',
                },
                'location_map': {
                    'space': 'path',
                    'data_id': 'path',
                    'download': 'query',
                    'metadata': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__show_data
        )
