"""
    Accounts & Users Service - Public API

    IN PROGRESS->This is the guide to use the different endpoints to manage the clusters.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from swx_sdk.api_client import ApiClient, Endpoint as _Endpoint
from swx_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from swx_sdk.model.error_response import ErrorResponse
from swx_sdk.model.invitation import Invitation
from swx_sdk.model.invitations import Invitations


class InvitationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_invitation(
            self,
            space,
            invitation,
            **kwargs
        ):
            """Create a new Invitation  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_invitation(space, invitation, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                invitation (Invitation): Body of a new Invitation

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Invitation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['invitation'] = \
                invitation
            return self.call_with_http_info(**kwargs)

        self.create_invitation = _Endpoint(
            settings={
                'response_type': (Invitation,),
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/invitations',
                'operation_id': 'create_invitation',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'invitation',
                ],
                'required': [
                    'space',
                    'invitation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'invitation':
                        (Invitation,),
                },
                'attribute_map': {
                    'space': 'space',
                },
                'location_map': {
                    'space': 'path',
                    'invitation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_invitation
        )

        def __delete_sent_invitation(
            self,
            space,
            invitation_id,
            **kwargs
        ):
            """Delete an Invitation sent from Account  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_sent_invitation(space, invitation_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                invitation_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['invitation_id'] = \
                invitation_id
            return self.call_with_http_info(**kwargs)

        self.delete_sent_invitation = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/invitations/{invitation_id}',
                'operation_id': 'delete_sent_invitation',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'invitation_id',
                ],
                'required': [
                    'space',
                    'invitation_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'invitation_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'invitation_id': 'invitation_id',
                },
                'location_map': {
                    'space': 'path',
                    'invitation_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_sent_invitation
        )

        def __get_received_invitation(
            self,
            invitation_id,
            **kwargs
        ):
            """Get a received Invitation  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_received_invitation(invitation_id, async_req=True)
            >>> result = thread.get()

            Args:
                invitation_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Invitation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['invitation_id'] = \
                invitation_id
            return self.call_with_http_info(**kwargs)

        self.get_received_invitation = _Endpoint(
            settings={
                'response_type': (Invitation,),
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/invitations/{invitation_id}',
                'operation_id': 'get_received_invitation',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'invitation_id',
                ],
                'required': [
                    'invitation_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'invitation_id':
                        (str,),
                },
                'attribute_map': {
                    'invitation_id': 'invitation_id',
                },
                'location_map': {
                    'invitation_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_received_invitation
        )

        def __get_sent_invitation(
            self,
            space,
            invitation_id,
            **kwargs
        ):
            """Get an Invitation sent from an Account  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_sent_invitation(space, invitation_id, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                invitation_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Invitation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['invitation_id'] = \
                invitation_id
            return self.call_with_http_info(**kwargs)

        self.get_sent_invitation = _Endpoint(
            settings={
                'response_type': (Invitation,),
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/invitations/{invitation_id}',
                'operation_id': 'get_sent_invitation',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'invitation_id',
                ],
                'required': [
                    'space',
                    'invitation_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'invitation_id':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'invitation_id': 'invitation_id',
                },
                'location_map': {
                    'space': 'path',
                    'invitation_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_sent_invitation
        )

        def __list_received_invitations(
            self,
            **kwargs
        ):
            """List received Invitations  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_received_invitations(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Invitations
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_received_invitations = _Endpoint(
            settings={
                'response_type': (Invitations,),
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/invitations',
                'operation_id': 'list_received_invitations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_received_invitations
        )

        def __list_sent_invitations(
            self,
            space,
            **kwargs
        ):
            """List Invitations sent from an Account  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_sent_invitations(space, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Invitations
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            return self.call_with_http_info(**kwargs)

        self.list_sent_invitations = _Endpoint(
            settings={
                'response_type': (Invitations,),
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/invitations',
                'operation_id': 'list_sent_invitations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                ],
                'required': [
                    'space',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                },
                'location_map': {
                    'space': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_sent_invitations
        )

        def __patch_received_invitation(
            self,
            invitation_id,
            invitation,
            **kwargs
        ):
            """Accept / Reject a received Invitation  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.patch_received_invitation(invitation_id, invitation, async_req=True)
            >>> result = thread.get()

            Args:
                invitation_id (str):
                invitation (Invitation): Body accepting/rejecting the Invitation

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Invitation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['invitation_id'] = \
                invitation_id
            kwargs['invitation'] = \
                invitation
            return self.call_with_http_info(**kwargs)

        self.patch_received_invitation = _Endpoint(
            settings={
                'response_type': (Invitation,),
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/invitations/{invitation_id}',
                'operation_id': 'patch_received_invitation',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'invitation_id',
                    'invitation',
                ],
                'required': [
                    'invitation_id',
                    'invitation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'invitation_id':
                        (str,),
                    'invitation':
                        (Invitation,),
                },
                'attribute_map': {
                    'invitation_id': 'invitation_id',
                },
                'location_map': {
                    'invitation_id': 'path',
                    'invitation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__patch_received_invitation
        )

        def __update_sent_invitation(
            self,
            space,
            invitation_id,
            invitation,
            **kwargs
        ):
            """Update an Invitation  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_sent_invitation(space, invitation_id, invitation, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                invitation_id (str):
                invitation (Invitation): Body of a the updated Invitation

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Invitation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['invitation_id'] = \
                invitation_id
            kwargs['invitation'] = \
                invitation
            return self.call_with_http_info(**kwargs)

        self.update_sent_invitation = _Endpoint(
            settings={
                'response_type': (Invitation,),
                'auth': [
                    'OAuth2Security',
                    'OAuth2Security',
                    'bearerAuth'
                ],
                'endpoint_path': '/spaces/{space}/invitations/{invitation_id}',
                'operation_id': 'update_sent_invitation',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'invitation_id',
                    'invitation',
                ],
                'required': [
                    'space',
                    'invitation_id',
                    'invitation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'invitation_id':
                        (str,),
                    'invitation':
                        (Invitation,),
                },
                'attribute_map': {
                    'space': 'space',
                    'invitation_id': 'invitation_id',
                },
                'location_map': {
                    'space': 'path',
                    'invitation_id': 'path',
                    'invitation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_sent_invitation
        )
