"""
    Digital Model API (WIP)

    Digital Model API documentation  # noqa: E501

    The version of the OpenAPI document: 0.8.12
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from openapi_client.api_client import ApiClient, Endpoint as _Endpoint
from openapi_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from openapi_client.model.model_version_list_response import ModelVersionListResponse
from openapi_client.model.model_version_request import ModelVersionRequest
from openapi_client.model.model_version_response import ModelVersionResponse


class ModelVersionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_version(
            self,
            space,
            collection_name,
            model_name,
            model_version_request,
            **kwargs
        ):
            """Create version  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_version(space, collection_name, model_name, model_version_request, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                collection_name (str):
                model_name (str):
                model_version_request (ModelVersionRequest): Create a new collection in the platform

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ModelVersionResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['collection_name'] = \
                collection_name
            kwargs['model_name'] = \
                model_name
            kwargs['model_version_request'] = \
                model_version_request
            return self.call_with_http_info(**kwargs)

        self.add_version = _Endpoint(
            settings={
                'response_type': (ModelVersionResponse,),
                'auth': [],
                'endpoint_path': '/spaces/{space}/collections/{collection-name}/models/{model-name}/versions',
                'operation_id': 'add_version',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'collection_name',
                    'model_name',
                    'model_version_request',
                ],
                'required': [
                    'space',
                    'collection_name',
                    'model_name',
                    'model_version_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'collection_name':
                        (str,),
                    'model_name':
                        (str,),
                    'model_version_request':
                        (ModelVersionRequest,),
                },
                'attribute_map': {
                    'space': 'space',
                    'collection_name': 'collection-name',
                    'model_name': 'model-name',
                },
                'location_map': {
                    'space': 'path',
                    'collection_name': 'path',
                    'model_name': 'path',
                    'model_version_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_version
        )

        def __delete_version(
            self,
            space,
            collection_name,
            model_name,
            version_name,
            **kwargs
        ):
            """Delete version  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_version(space, collection_name, model_name, version_name, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                collection_name (str):
                model_name (str):
                version_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['collection_name'] = \
                collection_name
            kwargs['model_name'] = \
                model_name
            kwargs['version_name'] = \
                version_name
            return self.call_with_http_info(**kwargs)

        self.delete_version = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/spaces/{space}/collections/{collection-name}/models/{model-name}/versions/{version-name}',
                'operation_id': 'delete_version',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'collection_name',
                    'model_name',
                    'version_name',
                ],
                'required': [
                    'space',
                    'collection_name',
                    'model_name',
                    'version_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'collection_name':
                        (str,),
                    'model_name':
                        (str,),
                    'version_name':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'collection_name': 'collection-name',
                    'model_name': 'model-name',
                    'version_name': 'version-name',
                },
                'location_map': {
                    'space': 'path',
                    'collection_name': 'path',
                    'model_name': 'path',
                    'version_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_version
        )

        def __list_version(
            self,
            space,
            collection_name,
            model_name,
            **kwargs
        ):
            """List version  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_version(space, collection_name, model_name, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                collection_name (str):
                model_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ModelVersionListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['collection_name'] = \
                collection_name
            kwargs['model_name'] = \
                model_name
            return self.call_with_http_info(**kwargs)

        self.list_version = _Endpoint(
            settings={
                'response_type': (ModelVersionListResponse,),
                'auth': [],
                'endpoint_path': '/spaces/{space}/collections/{collection-name}/models/{model-name}/versions',
                'operation_id': 'list_version',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'collection_name',
                    'model_name',
                ],
                'required': [
                    'space',
                    'collection_name',
                    'model_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'collection_name':
                        (str,),
                    'model_name':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'collection_name': 'collection-name',
                    'model_name': 'model-name',
                },
                'location_map': {
                    'space': 'path',
                    'collection_name': 'path',
                    'model_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_version
        )

        def __show_version(
            self,
            space,
            collection_name,
            model_name,
            version_name,
            **kwargs
        ):
            """Show version  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.show_version(space, collection_name, model_name, version_name, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                collection_name (str):
                model_name (str):
                version_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ModelVersionResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['collection_name'] = \
                collection_name
            kwargs['model_name'] = \
                model_name
            kwargs['version_name'] = \
                version_name
            return self.call_with_http_info(**kwargs)

        self.show_version = _Endpoint(
            settings={
                'response_type': (ModelVersionResponse,),
                'auth': [],
                'endpoint_path': '/spaces/{space}/collections/{collection-name}/models/{model-name}/versions/{version-name}',
                'operation_id': 'show_version',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'collection_name',
                    'model_name',
                    'version_name',
                ],
                'required': [
                    'space',
                    'collection_name',
                    'model_name',
                    'version_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'collection_name':
                        (str,),
                    'model_name':
                        (str,),
                    'version_name':
                        (str,),
                },
                'attribute_map': {
                    'space': 'space',
                    'collection_name': 'collection-name',
                    'model_name': 'model-name',
                    'version_name': 'version-name',
                },
                'location_map': {
                    'space': 'path',
                    'collection_name': 'path',
                    'model_name': 'path',
                    'version_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__show_version
        )

        def __update_version(
            self,
            space,
            collection_name,
            model_name,
            version_name,
            model_version_response,
            **kwargs
        ):
            """Update version  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_version(space, collection_name, model_name, version_name, model_version_response, async_req=True)
            >>> result = thread.get()

            Args:
                space (str):
                collection_name (str):
                model_name (str):
                version_name (str):
                model_version_response (ModelVersionResponse): Update an existent model by name

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ModelVersionResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['space'] = \
                space
            kwargs['collection_name'] = \
                collection_name
            kwargs['model_name'] = \
                model_name
            kwargs['version_name'] = \
                version_name
            kwargs['model_version_response'] = \
                model_version_response
            return self.call_with_http_info(**kwargs)

        self.update_version = _Endpoint(
            settings={
                'response_type': (ModelVersionResponse,),
                'auth': [],
                'endpoint_path': '/spaces/{space}/collections/{collection-name}/models/{model-name}/versions/{version-name}',
                'operation_id': 'update_version',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'space',
                    'collection_name',
                    'model_name',
                    'version_name',
                    'model_version_response',
                ],
                'required': [
                    'space',
                    'collection_name',
                    'model_name',
                    'version_name',
                    'model_version_response',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'space':
                        (str,),
                    'collection_name':
                        (str,),
                    'model_name':
                        (str,),
                    'version_name':
                        (str,),
                    'model_version_response':
                        (ModelVersionResponse,),
                },
                'attribute_map': {
                    'space': 'space',
                    'collection_name': 'collection-name',
                    'model_name': 'model-name',
                    'version_name': 'version-name',
                },
                'location_map': {
                    'space': 'path',
                    'collection_name': 'path',
                    'model_name': 'path',
                    'version_name': 'path',
                    'model_version_response': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_version
        )
