"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X.   # noqa: E501

    The version of the OpenAPI document: 20.10.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from symphony.bdk.gen.api_client import ApiClient, Endpoint
from symphony.bdk.gen.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from symphony.bdk.gen.pod_model.error import Error
from symphony.bdk.gen.pod_model.file_extension import FileExtension
from symphony.bdk.gen.pod_model.file_extensions_response import FileExtensionsResponse
from symphony.bdk.gen.pod_model.message_details import MessageDetails
from symphony.bdk.gen.pod_model.message_ids import MessageIds
from symphony.bdk.gen.pod_model.message_ids_from_stream import MessageIdsFromStream
from symphony.bdk.gen.pod_model.message_metadata_response import MessageMetadataResponse
from symphony.bdk.gen.pod_model.message_receipt_detail_response import MessageReceiptDetailResponse


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __delete_allowed_file_extension(
            self,
            session_token,
            extension,
            **kwargs
        ):
            """Allows deletion of a specific file extension supported for upload  # noqa: E501

            Provides a method to delete a specific file extension configured for upload support via an admin. The file extension identifying the resource is treated case-insensitively by the API.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.delete_allowed_file_extension(session_token, extension, async_req=True)
            >>> result = thread.get()

            Args:
                session_token (str): Session authentication token.
                extension (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['session_token'] = \
                session_token
            kwargs['extension'] = \
                extension
            return self.call_with_http_info(**kwargs)

        self.delete_allowed_file_extension = Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/file_ext/v1/allowed_extensions/{extension}',
                'operation_id': 'delete_allowed_file_extension',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'extension',
                ],
                'required': [
                    'session_token',
                    'extension',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'extension':
                        (str,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'extension': 'extension',
                },
                'location_map': {
                    'session_token': 'header',
                    'extension': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_allowed_file_extension
        )

        def __list_allowed_file_extensions(
            self,
            **kwargs
        ):
            """Allows iteration of all file extensions supported for upload  # noqa: E501

            Provides a RESTful API to iterate all file extensions configured by the tenant admin that are allowed for the upload.  Pagination of this list is managed through a combination of the optional request parameters and service-side managed maximums.  Pagination of the results is provided through the before or after input paramters and presented through the opaque cursor values provided as output from a previous response.  Only one of before or after or neither may be provided.  DO NOT store cursors. Cursors can quickly become invalid if items are added or deleted. Use them only during a short-period of time that you are traversing the list.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.list_allowed_file_extensions(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): This is the maximum number of objects that may be returned. A query may return fewer than the value of limit due to filtering or service-side maximums. Do not depend on the number of results being fewer than the limit value to indicate your query reached the end of the list of data, use the absence of next instead as described below. For example, if you set limit to 10 and 9 results are returned, there may be more data available, but one item was removed due to privacy filtering. Some maximums for limit may be enforced for performance reasons. In all cases, the API returns the correct pagination links. . [optional]
                before (str): Returns results from an opaque \"before\" cursor value as presented via a response cursor . [optional]
                after (str): Returns results from an opaque \"after\" cursor value as presented via a response cursor . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FileExtensionsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_allowed_file_extensions = Endpoint(
            settings={
                'response_type': (FileExtensionsResponse,),
                'auth': [],
                'endpoint_path': '/file_ext/v1/allowed_extensions',
                'operation_id': 'list_allowed_file_extensions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'before',
                    'after',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'before':
                        (str,),
                    'after':
                        (str,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'before': 'before',
                    'after': 'after',
                },
                'location_map': {
                    'limit': 'query',
                    'before': 'query',
                    'after': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_allowed_file_extensions
        )

        def __put_allowed_file_extension(
            self,
            session_token,
            extension,
            v3_file_extension,
            **kwargs
        ):
            """Allows replacement or creation of a specific file extension supported for upload  # noqa: E501

            Provides a method to create or replace a specific file extension configured for upload support via an admin. The API treats the file extension in the path case-insensitively by converting it to lowecase.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.put_allowed_file_extension(session_token, extension, v3_file_extension, async_req=True)
            >>> result = thread.get()

            Args:
                session_token (str): Session authentication token.
                extension (str):
                v3_file_extension (FileExtension):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FileExtension
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['session_token'] = \
                session_token
            kwargs['extension'] = \
                extension
            kwargs['v3_file_extension'] = \
                v3_file_extension
            return self.call_with_http_info(**kwargs)

        self.put_allowed_file_extension = Endpoint(
            settings={
                'response_type': (FileExtension,),
                'auth': [],
                'endpoint_path': '/file_ext/v1/allowed_extensions/{extension}',
                'operation_id': 'put_allowed_file_extension',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'extension',
                    'v3_file_extension',
                ],
                'required': [
                    'session_token',
                    'extension',
                    'v3_file_extension',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'extension':
                        (str,),
                    'v3_file_extension':
                        (FileExtension,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'extension': 'extension',
                },
                'location_map': {
                    'session_token': 'header',
                    'extension': 'path',
                    'v3_file_extension': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__put_allowed_file_extension
        )

        def __v1_admin_messages_message_id_metadata_relationships_get(
            self,
            session_token,
            user_agent,
            message_id,
            **kwargs
        ):
            """Get the message metadata relationship  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.v1_admin_messages_message_id_metadata_relationships_get(session_token, user_agent, message_id, async_req=True)
            >>> result = thread.get()

            Args:
                session_token (str): Session authentication token.
                user_agent (str): Request user agent.
                message_id (str): Valid id of a SOCIALMESSAGE

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MessageMetadataResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['session_token'] = \
                session_token
            kwargs['user_agent'] = \
                user_agent
            kwargs['message_id'] = \
                message_id
            return self.call_with_http_info(**kwargs)

        self.v1_admin_messages_message_id_metadata_relationships_get = Endpoint(
            settings={
                'response_type': (MessageMetadataResponse,),
                'auth': [],
                'endpoint_path': '/v1/admin/messages/{messageId}/metadata/relationships',
                'operation_id': 'v1_admin_messages_message_id_metadata_relationships_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'user_agent',
                    'message_id',
                ],
                'required': [
                    'session_token',
                    'user_agent',
                    'message_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'user_agent':
                        (str,),
                    'message_id':
                        (str,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'user_agent': 'User-Agent',
                    'message_id': 'messageId',
                },
                'location_map': {
                    'session_token': 'header',
                    'user_agent': 'header',
                    'message_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__v1_admin_messages_message_id_metadata_relationships_get
        )

        def __v1_admin_messages_message_id_receipts_get(
            self,
            session_token,
            message_id,
            **kwargs
        ):
            """Fetch receipts details from a specific message.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.v1_admin_messages_message_id_receipts_get(session_token, message_id, async_req=True)
            >>> result = thread.get()

            Args:
                session_token (str): Session authentication token.
                message_id (str): The message ID

            Keyword Args:
                before (str): Returns results from an opaque “before” cursor value as presented via a response cursor.. [optional]
                after (str): Returns results from an opaque “after” cursor value as presented via a response cursor.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MessageReceiptDetailResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['session_token'] = \
                session_token
            kwargs['message_id'] = \
                message_id
            return self.call_with_http_info(**kwargs)

        self.v1_admin_messages_message_id_receipts_get = Endpoint(
            settings={
                'response_type': (MessageReceiptDetailResponse,),
                'auth': [],
                'endpoint_path': '/v1/admin/messages/{messageId}/receipts',
                'operation_id': 'v1_admin_messages_message_id_receipts_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'message_id',
                    'before',
                    'after',
                ],
                'required': [
                    'session_token',
                    'message_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'message_id':
                        (str,),
                    'before':
                        (str,),
                    'after':
                        (str,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'message_id': 'messageId',
                    'before': 'before',
                    'after': 'after',
                },
                'location_map': {
                    'session_token': 'header',
                    'message_id': 'path',
                    'before': 'query',
                    'after': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__v1_admin_messages_message_id_receipts_get
        )

        def __v1_admin_messages_post(
            self,
            session_token,
            message_ids,
            **kwargs
        ):
            """Fetch message details  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.v1_admin_messages_post(session_token, message_ids, async_req=True)
            >>> result = thread.get()

            Args:
                session_token (str): Session authentication token
                message_ids (MessageIds): the ids of the messages to be fetched

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MessageDetails
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['session_token'] = \
                session_token
            kwargs['message_ids'] = \
                message_ids
            return self.call_with_http_info(**kwargs)

        self.v1_admin_messages_post = Endpoint(
            settings={
                'response_type': (MessageDetails,),
                'auth': [],
                'endpoint_path': '/v1/admin/messages',
                'operation_id': 'v1_admin_messages_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'message_ids',
                ],
                'required': [
                    'session_token',
                    'message_ids',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'message_ids':
                        (MessageIds,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                },
                'location_map': {
                    'session_token': 'header',
                    'message_ids': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__v1_admin_messages_post
        )

        def __v2_admin_streams_stream_id_message_ids_get(
            self,
            session_token,
            stream_id,
            **kwargs
        ):
            """Fetch message ids using timestamp.  # noqa: E501

            Gets all message Ids that matches a given stream defined by a streamId in a specified time frame   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.v2_admin_streams_stream_id_message_ids_get(session_token, stream_id, async_req=True)
            >>> result = thread.get()

            Args:
                session_token (str): Session authentication token.
                stream_id (str): The stream from which messages are going to be fetched.

            Keyword Args:
                since (int): A timestamp in milisseconds that defines the initial time the search will consider when getting the messageIds. . [optional]
                to (int): A timestamp in milisseconds that defines the final time the search will consider when getting the messageIds. . [optional]
                limit (int): The limit of how many messageIds will be retrieved at a time. . [optional]
                offset (int): The pagination offset related to the messageIds search. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MessageIdsFromStream
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['session_token'] = \
                session_token
            kwargs['stream_id'] = \
                stream_id
            return self.call_with_http_info(**kwargs)

        self.v2_admin_streams_stream_id_message_ids_get = Endpoint(
            settings={
                'response_type': (MessageIdsFromStream,),
                'auth': [],
                'endpoint_path': '/v2/admin/streams/{streamId}/messageIds',
                'operation_id': 'v2_admin_streams_stream_id_message_ids_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'stream_id',
                    'since',
                    'to',
                    'limit',
                    'offset',
                ],
                'required': [
                    'session_token',
                    'stream_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'stream_id':
                        (str,),
                    'since':
                        (int,),
                    'to':
                        (int,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'stream_id': 'streamId',
                    'since': 'since',
                    'to': 'to',
                    'limit': 'limit',
                    'offset': 'offset',
                },
                'location_map': {
                    'session_token': 'header',
                    'stream_id': 'path',
                    'since': 'query',
                    'to': 'query',
                    'limit': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__v2_admin_streams_stream_id_message_ids_get
        )
