# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest 2.1.0  # noqa: E501
    The version of the OpenAPI document: 0.10.0
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class MultisigAccountModificationTransactionBodyDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'min_removal_delta': 'int',
        'min_approval_delta': 'int',
        'address_additions': 'list[str]',
        'address_deletions': 'list[str]'
    }

    attribute_map = {
        'min_removal_delta': 'minRemovalDelta',
        'min_approval_delta': 'minApprovalDelta',
        'address_additions': 'addressAdditions',
        'address_deletions': 'addressDeletions'
    }

    def __init__(self, min_removal_delta=None, min_approval_delta=None, address_additions=None, address_deletions=None, local_vars_configuration=None):  # noqa: E501
        """MultisigAccountModificationTransactionBodyDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._min_removal_delta = None
        self._min_approval_delta = None
        self._address_additions = None
        self._address_deletions = None
        self.discriminator = None

        self.min_removal_delta = min_removal_delta
        self.min_approval_delta = min_approval_delta
        self.address_additions = address_additions
        self.address_deletions = address_deletions

    @property
    def min_removal_delta(self):
        """Gets the min_removal_delta of this MultisigAccountModificationTransactionBodyDTO.  # noqa: E501

        Number of signatures needed to remove a cosignatory. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories.   # noqa: E501

        :return: The min_removal_delta of this MultisigAccountModificationTransactionBodyDTO.  # noqa: E501
        :rtype: int
        """
        return self._min_removal_delta

    @min_removal_delta.setter
    def min_removal_delta(self, min_removal_delta):
        """Sets the min_removal_delta of this MultisigAccountModificationTransactionBodyDTO.

        Number of signatures needed to remove a cosignatory. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories.   # noqa: E501

        :param min_removal_delta: The min_removal_delta of this MultisigAccountModificationTransactionBodyDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and min_removal_delta is None:  # noqa: E501
            raise ValueError("Invalid value for `min_removal_delta`, must not be `None`")  # noqa: E501

        self._min_removal_delta = min_removal_delta

    @property
    def min_approval_delta(self):
        """Gets the min_approval_delta of this MultisigAccountModificationTransactionBodyDTO.  # noqa: E501

        Number of signatures needed to approve a transaction. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories.   # noqa: E501

        :return: The min_approval_delta of this MultisigAccountModificationTransactionBodyDTO.  # noqa: E501
        :rtype: int
        """
        return self._min_approval_delta

    @min_approval_delta.setter
    def min_approval_delta(self, min_approval_delta):
        """Sets the min_approval_delta of this MultisigAccountModificationTransactionBodyDTO.

        Number of signatures needed to approve a transaction. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories.   # noqa: E501

        :param min_approval_delta: The min_approval_delta of this MultisigAccountModificationTransactionBodyDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and min_approval_delta is None:  # noqa: E501
            raise ValueError("Invalid value for `min_approval_delta`, must not be `None`")  # noqa: E501

        self._min_approval_delta = min_approval_delta

    @property
    def address_additions(self):
        """Gets the address_additions of this MultisigAccountModificationTransactionBodyDTO.  # noqa: E501

        Array of cosignatory accounts to add.  # noqa: E501

        :return: The address_additions of this MultisigAccountModificationTransactionBodyDTO.  # noqa: E501
        :rtype: list[str]
        """
        return self._address_additions

    @address_additions.setter
    def address_additions(self, address_additions):
        """Sets the address_additions of this MultisigAccountModificationTransactionBodyDTO.

        Array of cosignatory accounts to add.  # noqa: E501

        :param address_additions: The address_additions of this MultisigAccountModificationTransactionBodyDTO.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and address_additions is None:  # noqa: E501
            raise ValueError("Invalid value for `address_additions`, must not be `None`")  # noqa: E501

        self._address_additions = address_additions

    @property
    def address_deletions(self):
        """Gets the address_deletions of this MultisigAccountModificationTransactionBodyDTO.  # noqa: E501

        Array of cosignatory accounts to delete.  # noqa: E501

        :return: The address_deletions of this MultisigAccountModificationTransactionBodyDTO.  # noqa: E501
        :rtype: list[str]
        """
        return self._address_deletions

    @address_deletions.setter
    def address_deletions(self, address_deletions):
        """Sets the address_deletions of this MultisigAccountModificationTransactionBodyDTO.

        Array of cosignatory accounts to delete.  # noqa: E501

        :param address_deletions: The address_deletions of this MultisigAccountModificationTransactionBodyDTO.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and address_deletions is None:  # noqa: E501
            raise ValueError("Invalid value for `address_deletions`, must not be `None`")  # noqa: E501

        self._address_deletions = address_deletions

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MultisigAccountModificationTransactionBodyDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MultisigAccountModificationTransactionBodyDTO):
            return True

        return self.to_dict() != other.to_dict()
