# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest 2.3.0  # noqa: E501
    The version of the OpenAPI document: 0.11.0
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class StorageInfoDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'num_blocks': 'int',
        'num_transactions': 'int',
        'num_accounts': 'int'
    }

    attribute_map = {
        'num_blocks': 'numBlocks',
        'num_transactions': 'numTransactions',
        'num_accounts': 'numAccounts'
    }

    def __init__(self, num_blocks=None, num_transactions=None, num_accounts=None, local_vars_configuration=None):  # noqa: E501
        """StorageInfoDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._num_blocks = None
        self._num_transactions = None
        self._num_accounts = None
        self.discriminator = None

        self.num_blocks = num_blocks
        self.num_transactions = num_transactions
        self.num_accounts = num_accounts

    @property
    def num_blocks(self):
        """Gets the num_blocks of this StorageInfoDTO.  # noqa: E501

        Number of blocks stored.  # noqa: E501

        :return: The num_blocks of this StorageInfoDTO.  # noqa: E501
        :rtype: int
        """
        return self._num_blocks

    @num_blocks.setter
    def num_blocks(self, num_blocks):
        """Sets the num_blocks of this StorageInfoDTO.

        Number of blocks stored.  # noqa: E501

        :param num_blocks: The num_blocks of this StorageInfoDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and num_blocks is None:  # noqa: E501
            raise ValueError("Invalid value for `num_blocks`, must not be `None`")  # noqa: E501

        self._num_blocks = num_blocks

    @property
    def num_transactions(self):
        """Gets the num_transactions of this StorageInfoDTO.  # noqa: E501

        Number of transactions stored.  # noqa: E501

        :return: The num_transactions of this StorageInfoDTO.  # noqa: E501
        :rtype: int
        """
        return self._num_transactions

    @num_transactions.setter
    def num_transactions(self, num_transactions):
        """Sets the num_transactions of this StorageInfoDTO.

        Number of transactions stored.  # noqa: E501

        :param num_transactions: The num_transactions of this StorageInfoDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and num_transactions is None:  # noqa: E501
            raise ValueError("Invalid value for `num_transactions`, must not be `None`")  # noqa: E501

        self._num_transactions = num_transactions

    @property
    def num_accounts(self):
        """Gets the num_accounts of this StorageInfoDTO.  # noqa: E501

        Number of accounts created.  # noqa: E501

        :return: The num_accounts of this StorageInfoDTO.  # noqa: E501
        :rtype: int
        """
        return self._num_accounts

    @num_accounts.setter
    def num_accounts(self, num_accounts):
        """Sets the num_accounts of this StorageInfoDTO.

        Number of accounts created.  # noqa: E501

        :param num_accounts: The num_accounts of this StorageInfoDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and num_accounts is None:  # noqa: E501
            raise ValueError("Invalid value for `num_accounts`, must not be `None`")  # noqa: E501

        self._num_accounts = num_accounts

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StorageInfoDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, StorageInfoDTO):
            return True

        return self.to_dict() != other.to_dict()
