# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest 2.3.0  # noqa: E501
    The version of the OpenAPI document: 0.11.1
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class AggregateNetworkPropertiesDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'max_transactions_per_aggregate': 'str',
        'max_cosignatures_per_aggregate': 'str',
        'enable_strict_cosignature_check': 'bool',
        'enable_bonded_aggregate_support': 'bool',
        'max_bonded_transaction_lifetime': 'str'
    }

    attribute_map = {
        'max_transactions_per_aggregate': 'maxTransactionsPerAggregate',
        'max_cosignatures_per_aggregate': 'maxCosignaturesPerAggregate',
        'enable_strict_cosignature_check': 'enableStrictCosignatureCheck',
        'enable_bonded_aggregate_support': 'enableBondedAggregateSupport',
        'max_bonded_transaction_lifetime': 'maxBondedTransactionLifetime'
    }

    def __init__(self, max_transactions_per_aggregate=None, max_cosignatures_per_aggregate=None, enable_strict_cosignature_check=None, enable_bonded_aggregate_support=None, max_bonded_transaction_lifetime=None, local_vars_configuration=None):  # noqa: E501
        """AggregateNetworkPropertiesDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._max_transactions_per_aggregate = None
        self._max_cosignatures_per_aggregate = None
        self._enable_strict_cosignature_check = None
        self._enable_bonded_aggregate_support = None
        self._max_bonded_transaction_lifetime = None
        self.discriminator = None

        if max_transactions_per_aggregate is not None:
            self.max_transactions_per_aggregate = max_transactions_per_aggregate
        if max_cosignatures_per_aggregate is not None:
            self.max_cosignatures_per_aggregate = max_cosignatures_per_aggregate
        if enable_strict_cosignature_check is not None:
            self.enable_strict_cosignature_check = enable_strict_cosignature_check
        if enable_bonded_aggregate_support is not None:
            self.enable_bonded_aggregate_support = enable_bonded_aggregate_support
        if max_bonded_transaction_lifetime is not None:
            self.max_bonded_transaction_lifetime = max_bonded_transaction_lifetime

    @property
    def max_transactions_per_aggregate(self):
        """Gets the max_transactions_per_aggregate of this AggregateNetworkPropertiesDTO.  # noqa: E501

        Maximum number of transactions per aggregate.  # noqa: E501

        :return: The max_transactions_per_aggregate of this AggregateNetworkPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._max_transactions_per_aggregate

    @max_transactions_per_aggregate.setter
    def max_transactions_per_aggregate(self, max_transactions_per_aggregate):
        """Sets the max_transactions_per_aggregate of this AggregateNetworkPropertiesDTO.

        Maximum number of transactions per aggregate.  # noqa: E501

        :param max_transactions_per_aggregate: The max_transactions_per_aggregate of this AggregateNetworkPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._max_transactions_per_aggregate = max_transactions_per_aggregate

    @property
    def max_cosignatures_per_aggregate(self):
        """Gets the max_cosignatures_per_aggregate of this AggregateNetworkPropertiesDTO.  # noqa: E501

        Maximum number of cosignatures per aggregate.  # noqa: E501

        :return: The max_cosignatures_per_aggregate of this AggregateNetworkPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._max_cosignatures_per_aggregate

    @max_cosignatures_per_aggregate.setter
    def max_cosignatures_per_aggregate(self, max_cosignatures_per_aggregate):
        """Sets the max_cosignatures_per_aggregate of this AggregateNetworkPropertiesDTO.

        Maximum number of cosignatures per aggregate.  # noqa: E501

        :param max_cosignatures_per_aggregate: The max_cosignatures_per_aggregate of this AggregateNetworkPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._max_cosignatures_per_aggregate = max_cosignatures_per_aggregate

    @property
    def enable_strict_cosignature_check(self):
        """Gets the enable_strict_cosignature_check of this AggregateNetworkPropertiesDTO.  # noqa: E501

        Set to true if cosignatures must exactly match component signers. Set to false if cosignatures should be validated externally.  # noqa: E501

        :return: The enable_strict_cosignature_check of this AggregateNetworkPropertiesDTO.  # noqa: E501
        :rtype: bool
        """
        return self._enable_strict_cosignature_check

    @enable_strict_cosignature_check.setter
    def enable_strict_cosignature_check(self, enable_strict_cosignature_check):
        """Sets the enable_strict_cosignature_check of this AggregateNetworkPropertiesDTO.

        Set to true if cosignatures must exactly match component signers. Set to false if cosignatures should be validated externally.  # noqa: E501

        :param enable_strict_cosignature_check: The enable_strict_cosignature_check of this AggregateNetworkPropertiesDTO.  # noqa: E501
        :type: bool
        """

        self._enable_strict_cosignature_check = enable_strict_cosignature_check

    @property
    def enable_bonded_aggregate_support(self):
        """Gets the enable_bonded_aggregate_support of this AggregateNetworkPropertiesDTO.  # noqa: E501

        Set to true if bonded aggregates should be allowed. Set to false if bonded aggregates should be rejected.  # noqa: E501

        :return: The enable_bonded_aggregate_support of this AggregateNetworkPropertiesDTO.  # noqa: E501
        :rtype: bool
        """
        return self._enable_bonded_aggregate_support

    @enable_bonded_aggregate_support.setter
    def enable_bonded_aggregate_support(self, enable_bonded_aggregate_support):
        """Sets the enable_bonded_aggregate_support of this AggregateNetworkPropertiesDTO.

        Set to true if bonded aggregates should be allowed. Set to false if bonded aggregates should be rejected.  # noqa: E501

        :param enable_bonded_aggregate_support: The enable_bonded_aggregate_support of this AggregateNetworkPropertiesDTO.  # noqa: E501
        :type: bool
        """

        self._enable_bonded_aggregate_support = enable_bonded_aggregate_support

    @property
    def max_bonded_transaction_lifetime(self):
        """Gets the max_bonded_transaction_lifetime of this AggregateNetworkPropertiesDTO.  # noqa: E501

        Maximum lifetime a bonded transaction can have before it expires.  # noqa: E501

        :return: The max_bonded_transaction_lifetime of this AggregateNetworkPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._max_bonded_transaction_lifetime

    @max_bonded_transaction_lifetime.setter
    def max_bonded_transaction_lifetime(self, max_bonded_transaction_lifetime):
        """Sets the max_bonded_transaction_lifetime of this AggregateNetworkPropertiesDTO.

        Maximum lifetime a bonded transaction can have before it expires.  # noqa: E501

        :param max_bonded_transaction_lifetime: The max_bonded_transaction_lifetime of this AggregateNetworkPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._max_bonded_transaction_lifetime = max_bonded_transaction_lifetime

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AggregateNetworkPropertiesDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AggregateNetworkPropertiesDTO):
            return True

        return self.to_dict() != other.to_dict()
