# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest 1.0.20.34  # noqa: E501
    The version of the OpenAPI document: 0.8.11
    Contact: ravi@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class MosaicNetworkPropertiesDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'max_mosaics_per_account': 'str',
        'max_mosaic_duration': 'str',
        'max_mosaic_divisibility': 'str',
        'mosaic_rental_fee_sink_public_key': 'str',
        'mosaic_rental_fee': 'str'
    }

    attribute_map = {
        'max_mosaics_per_account': 'maxMosaicsPerAccount',
        'max_mosaic_duration': 'maxMosaicDuration',
        'max_mosaic_divisibility': 'maxMosaicDivisibility',
        'mosaic_rental_fee_sink_public_key': 'mosaicRentalFeeSinkPublicKey',
        'mosaic_rental_fee': 'mosaicRentalFee'
    }

    def __init__(self, max_mosaics_per_account=None, max_mosaic_duration=None, max_mosaic_divisibility=None, mosaic_rental_fee_sink_public_key=None, mosaic_rental_fee=None, local_vars_configuration=None):  # noqa: E501
        """MosaicNetworkPropertiesDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._max_mosaics_per_account = None
        self._max_mosaic_duration = None
        self._max_mosaic_divisibility = None
        self._mosaic_rental_fee_sink_public_key = None
        self._mosaic_rental_fee = None
        self.discriminator = None

        if max_mosaics_per_account is not None:
            self.max_mosaics_per_account = max_mosaics_per_account
        if max_mosaic_duration is not None:
            self.max_mosaic_duration = max_mosaic_duration
        if max_mosaic_divisibility is not None:
            self.max_mosaic_divisibility = max_mosaic_divisibility
        if mosaic_rental_fee_sink_public_key is not None:
            self.mosaic_rental_fee_sink_public_key = mosaic_rental_fee_sink_public_key
        if mosaic_rental_fee is not None:
            self.mosaic_rental_fee = mosaic_rental_fee

    @property
    def max_mosaics_per_account(self):
        """Gets the max_mosaics_per_account of this MosaicNetworkPropertiesDTO.  # noqa: E501

        Maximum number of mosaics that an account can own.  # noqa: E501

        :return: The max_mosaics_per_account of this MosaicNetworkPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._max_mosaics_per_account

    @max_mosaics_per_account.setter
    def max_mosaics_per_account(self, max_mosaics_per_account):
        """Sets the max_mosaics_per_account of this MosaicNetworkPropertiesDTO.

        Maximum number of mosaics that an account can own.  # noqa: E501

        :param max_mosaics_per_account: The max_mosaics_per_account of this MosaicNetworkPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._max_mosaics_per_account = max_mosaics_per_account

    @property
    def max_mosaic_duration(self):
        """Gets the max_mosaic_duration of this MosaicNetworkPropertiesDTO.  # noqa: E501

        Maximum mosaic duration.  # noqa: E501

        :return: The max_mosaic_duration of this MosaicNetworkPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._max_mosaic_duration

    @max_mosaic_duration.setter
    def max_mosaic_duration(self, max_mosaic_duration):
        """Sets the max_mosaic_duration of this MosaicNetworkPropertiesDTO.

        Maximum mosaic duration.  # noqa: E501

        :param max_mosaic_duration: The max_mosaic_duration of this MosaicNetworkPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._max_mosaic_duration = max_mosaic_duration

    @property
    def max_mosaic_divisibility(self):
        """Gets the max_mosaic_divisibility of this MosaicNetworkPropertiesDTO.  # noqa: E501

        Maximum mosaic divisibility.  # noqa: E501

        :return: The max_mosaic_divisibility of this MosaicNetworkPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._max_mosaic_divisibility

    @max_mosaic_divisibility.setter
    def max_mosaic_divisibility(self, max_mosaic_divisibility):
        """Sets the max_mosaic_divisibility of this MosaicNetworkPropertiesDTO.

        Maximum mosaic divisibility.  # noqa: E501

        :param max_mosaic_divisibility: The max_mosaic_divisibility of this MosaicNetworkPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._max_mosaic_divisibility = max_mosaic_divisibility

    @property
    def mosaic_rental_fee_sink_public_key(self):
        """Gets the mosaic_rental_fee_sink_public_key of this MosaicNetworkPropertiesDTO.  # noqa: E501

        Public key.  # noqa: E501

        :return: The mosaic_rental_fee_sink_public_key of this MosaicNetworkPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._mosaic_rental_fee_sink_public_key

    @mosaic_rental_fee_sink_public_key.setter
    def mosaic_rental_fee_sink_public_key(self, mosaic_rental_fee_sink_public_key):
        """Sets the mosaic_rental_fee_sink_public_key of this MosaicNetworkPropertiesDTO.

        Public key.  # noqa: E501

        :param mosaic_rental_fee_sink_public_key: The mosaic_rental_fee_sink_public_key of this MosaicNetworkPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._mosaic_rental_fee_sink_public_key = mosaic_rental_fee_sink_public_key

    @property
    def mosaic_rental_fee(self):
        """Gets the mosaic_rental_fee of this MosaicNetworkPropertiesDTO.  # noqa: E501

        Mosaic rental fee.  # noqa: E501

        :return: The mosaic_rental_fee of this MosaicNetworkPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._mosaic_rental_fee

    @mosaic_rental_fee.setter
    def mosaic_rental_fee(self, mosaic_rental_fee):
        """Sets the mosaic_rental_fee of this MosaicNetworkPropertiesDTO.

        Mosaic rental fee.  # noqa: E501

        :param mosaic_rental_fee: The mosaic_rental_fee of this MosaicNetworkPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._mosaic_rental_fee = mosaic_rental_fee

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MosaicNetworkPropertiesDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MosaicNetworkPropertiesDTO):
            return True

        return self.to_dict() != other.to_dict()
