# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest 1.2.0  # noqa: E501
    The version of the OpenAPI document: 0.9.6
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class MultisigNetworkPropertiesDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'max_multisig_depth': 'str',
        'max_cosignatories_per_account': 'str',
        'max_cosigned_accounts_per_account': 'str'
    }

    attribute_map = {
        'max_multisig_depth': 'maxMultisigDepth',
        'max_cosignatories_per_account': 'maxCosignatoriesPerAccount',
        'max_cosigned_accounts_per_account': 'maxCosignedAccountsPerAccount'
    }

    def __init__(self, max_multisig_depth=None, max_cosignatories_per_account=None, max_cosigned_accounts_per_account=None, local_vars_configuration=None):  # noqa: E501
        """MultisigNetworkPropertiesDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._max_multisig_depth = None
        self._max_cosignatories_per_account = None
        self._max_cosigned_accounts_per_account = None
        self.discriminator = None

        if max_multisig_depth is not None:
            self.max_multisig_depth = max_multisig_depth
        if max_cosignatories_per_account is not None:
            self.max_cosignatories_per_account = max_cosignatories_per_account
        if max_cosigned_accounts_per_account is not None:
            self.max_cosigned_accounts_per_account = max_cosigned_accounts_per_account

    @property
    def max_multisig_depth(self):
        """Gets the max_multisig_depth of this MultisigNetworkPropertiesDTO.  # noqa: E501

        Maximum number of multisig levels.  # noqa: E501

        :return: The max_multisig_depth of this MultisigNetworkPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._max_multisig_depth

    @max_multisig_depth.setter
    def max_multisig_depth(self, max_multisig_depth):
        """Sets the max_multisig_depth of this MultisigNetworkPropertiesDTO.

        Maximum number of multisig levels.  # noqa: E501

        :param max_multisig_depth: The max_multisig_depth of this MultisigNetworkPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._max_multisig_depth = max_multisig_depth

    @property
    def max_cosignatories_per_account(self):
        """Gets the max_cosignatories_per_account of this MultisigNetworkPropertiesDTO.  # noqa: E501

        Maximum number of cosignatories per account.  # noqa: E501

        :return: The max_cosignatories_per_account of this MultisigNetworkPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._max_cosignatories_per_account

    @max_cosignatories_per_account.setter
    def max_cosignatories_per_account(self, max_cosignatories_per_account):
        """Sets the max_cosignatories_per_account of this MultisigNetworkPropertiesDTO.

        Maximum number of cosignatories per account.  # noqa: E501

        :param max_cosignatories_per_account: The max_cosignatories_per_account of this MultisigNetworkPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._max_cosignatories_per_account = max_cosignatories_per_account

    @property
    def max_cosigned_accounts_per_account(self):
        """Gets the max_cosigned_accounts_per_account of this MultisigNetworkPropertiesDTO.  # noqa: E501

        Maximum number of accounts a single account can cosign.  # noqa: E501

        :return: The max_cosigned_accounts_per_account of this MultisigNetworkPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._max_cosigned_accounts_per_account

    @max_cosigned_accounts_per_account.setter
    def max_cosigned_accounts_per_account(self, max_cosigned_accounts_per_account):
        """Sets the max_cosigned_accounts_per_account of this MultisigNetworkPropertiesDTO.

        Maximum number of accounts a single account can cosign.  # noqa: E501

        :param max_cosigned_accounts_per_account: The max_cosigned_accounts_per_account of this MultisigNetworkPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._max_cosigned_accounts_per_account = max_cosigned_accounts_per_account

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MultisigNetworkPropertiesDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MultisigNetworkPropertiesDTO):
            return True

        return self.to_dict() != other.to_dict()
