# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest  # noqa: E501
    The version of the OpenAPI document: 1.0.0
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class MerkleStateInfoDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'raw': 'str',
        'tree': 'list[AnyOfMerkleTreeBranchDTOMerkleTreeLeafDTO]'
    }

    attribute_map = {
        'raw': 'raw',
        'tree': 'tree'
    }

    def __init__(self, raw=None, tree=None, local_vars_configuration=None):  # noqa: E501
        """MerkleStateInfoDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._raw = None
        self._tree = None
        self.discriminator = None

        self.raw = raw
        self.tree = tree

    @property
    def raw(self):
        """Gets the raw of this MerkleStateInfoDTO.  # noqa: E501

        The hex information of the complete merkle tree as returned by server api. More information can be found in chapter 4.3 of the catapult whitepaper.   # noqa: E501

        :return: The raw of this MerkleStateInfoDTO.  # noqa: E501
        :rtype: str
        """
        return self._raw

    @raw.setter
    def raw(self, raw):
        """Sets the raw of this MerkleStateInfoDTO.

        The hex information of the complete merkle tree as returned by server api. More information can be found in chapter 4.3 of the catapult whitepaper.   # noqa: E501

        :param raw: The raw of this MerkleStateInfoDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and raw is None:  # noqa: E501
            raise ValueError("Invalid value for `raw`, must not be `None`")  # noqa: E501

        self._raw = raw

    @property
    def tree(self):
        """Gets the tree of this MerkleStateInfoDTO.  # noqa: E501

        Merkle tree parsed from merkle tree raw.  # noqa: E501

        :return: The tree of this MerkleStateInfoDTO.  # noqa: E501
        :rtype: list[AnyOfMerkleTreeBranchDTOMerkleTreeLeafDTO]
        """
        return self._tree

    @tree.setter
    def tree(self, tree):
        """Sets the tree of this MerkleStateInfoDTO.

        Merkle tree parsed from merkle tree raw.  # noqa: E501

        :param tree: The tree of this MerkleStateInfoDTO.  # noqa: E501
        :type: list[AnyOfMerkleTreeBranchDTOMerkleTreeLeafDTO]
        """
        if self.local_vars_configuration.client_side_validation and tree is None:  # noqa: E501
            raise ValueError("Invalid value for `tree`, must not be `None`")  # noqa: E501

        self._tree = tree

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MerkleStateInfoDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MerkleStateInfoDTO):
            return True

        return self.to_dict() != other.to_dict()
