# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest  # noqa: E501
    The version of the OpenAPI document: 1.0.1
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class ChainInfoDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'height': 'str',
        'score_high': 'str',
        'score_low': 'str',
        'latest_finalized_block': 'FinalizedBlockDTO'
    }

    attribute_map = {
        'height': 'height',
        'score_high': 'scoreHigh',
        'score_low': 'scoreLow',
        'latest_finalized_block': 'latestFinalizedBlock'
    }

    def __init__(self, height=None, score_high=None, score_low=None, latest_finalized_block=None, local_vars_configuration=None):  # noqa: E501
        """ChainInfoDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._height = None
        self._score_high = None
        self._score_low = None
        self._latest_finalized_block = None
        self.discriminator = None

        self.height = height
        self.score_high = score_high
        self.score_low = score_low
        self.latest_finalized_block = latest_finalized_block

    @property
    def height(self):
        """Gets the height of this ChainInfoDTO.  # noqa: E501

        Height of the blockchain.  # noqa: E501

        :return: The height of this ChainInfoDTO.  # noqa: E501
        :rtype: str
        """
        return self._height

    @height.setter
    def height(self, height):
        """Sets the height of this ChainInfoDTO.

        Height of the blockchain.  # noqa: E501

        :param height: The height of this ChainInfoDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and height is None:  # noqa: E501
            raise ValueError("Invalid value for `height`, must not be `None`")  # noqa: E501

        self._height = height

    @property
    def score_high(self):
        """Gets the score_high of this ChainInfoDTO.  # noqa: E501

        Score of the blockchain. During synchronization, nodes try to get the blockchain with highest score in the network.   # noqa: E501

        :return: The score_high of this ChainInfoDTO.  # noqa: E501
        :rtype: str
        """
        return self._score_high

    @score_high.setter
    def score_high(self, score_high):
        """Sets the score_high of this ChainInfoDTO.

        Score of the blockchain. During synchronization, nodes try to get the blockchain with highest score in the network.   # noqa: E501

        :param score_high: The score_high of this ChainInfoDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and score_high is None:  # noqa: E501
            raise ValueError("Invalid value for `score_high`, must not be `None`")  # noqa: E501

        self._score_high = score_high

    @property
    def score_low(self):
        """Gets the score_low of this ChainInfoDTO.  # noqa: E501

        Score of the blockchain. During synchronization, nodes try to get the blockchain with highest score in the network.   # noqa: E501

        :return: The score_low of this ChainInfoDTO.  # noqa: E501
        :rtype: str
        """
        return self._score_low

    @score_low.setter
    def score_low(self, score_low):
        """Sets the score_low of this ChainInfoDTO.

        Score of the blockchain. During synchronization, nodes try to get the blockchain with highest score in the network.   # noqa: E501

        :param score_low: The score_low of this ChainInfoDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and score_low is None:  # noqa: E501
            raise ValueError("Invalid value for `score_low`, must not be `None`")  # noqa: E501

        self._score_low = score_low

    @property
    def latest_finalized_block(self):
        """Gets the latest_finalized_block of this ChainInfoDTO.  # noqa: E501


        :return: The latest_finalized_block of this ChainInfoDTO.  # noqa: E501
        :rtype: FinalizedBlockDTO
        """
        return self._latest_finalized_block

    @latest_finalized_block.setter
    def latest_finalized_block(self, latest_finalized_block):
        """Sets the latest_finalized_block of this ChainInfoDTO.


        :param latest_finalized_block: The latest_finalized_block of this ChainInfoDTO.  # noqa: E501
        :type: FinalizedBlockDTO
        """
        if self.local_vars_configuration.client_side_validation and latest_finalized_block is None:  # noqa: E501
            raise ValueError("Invalid value for `latest_finalized_block`, must not be `None`")  # noqa: E501

        self._latest_finalized_block = latest_finalized_block

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ChainInfoDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ChainInfoDTO):
            return True

        return self.to_dict() != other.to_dict()
