# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest  # noqa: E501
    The version of the OpenAPI document: 1.0.2
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class SecretProofTransactionBodyDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'recipient_address': 'str',
        'secret': 'str',
        'hash_algorithm': 'LockHashAlgorithmEnum',
        'proof': 'str'
    }

    attribute_map = {
        'recipient_address': 'recipientAddress',
        'secret': 'secret',
        'hash_algorithm': 'hashAlgorithm',
        'proof': 'proof'
    }

    def __init__(self, recipient_address=None, secret=None, hash_algorithm=None, proof=None, local_vars_configuration=None):  # noqa: E501
        """SecretProofTransactionBodyDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._recipient_address = None
        self._secret = None
        self._hash_algorithm = None
        self._proof = None
        self.discriminator = None

        self.recipient_address = recipient_address
        self.secret = secret
        self.hash_algorithm = hash_algorithm
        self.proof = proof

    @property
    def recipient_address(self):
        """Gets the recipient_address of this SecretProofTransactionBodyDTO.  # noqa: E501

        Address expressed in Base32 format. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Example: TAOXUJOTTW3W5XTBQMQEX3SQNA6MCUVGXLXR3TA.  Otherwise (e.g. 0x91) it represents a namespace id which starts at byte 1. Example: THBIMC3THGH5RUYAAAAAAAAAAAAAAAAAAAAAAAA   # noqa: E501

        :return: The recipient_address of this SecretProofTransactionBodyDTO.  # noqa: E501
        :rtype: str
        """
        return self._recipient_address

    @recipient_address.setter
    def recipient_address(self, recipient_address):
        """Sets the recipient_address of this SecretProofTransactionBodyDTO.

        Address expressed in Base32 format. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Example: TAOXUJOTTW3W5XTBQMQEX3SQNA6MCUVGXLXR3TA.  Otherwise (e.g. 0x91) it represents a namespace id which starts at byte 1. Example: THBIMC3THGH5RUYAAAAAAAAAAAAAAAAAAAAAAAA   # noqa: E501

        :param recipient_address: The recipient_address of this SecretProofTransactionBodyDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and recipient_address is None:  # noqa: E501
            raise ValueError("Invalid value for `recipient_address`, must not be `None`")  # noqa: E501

        self._recipient_address = recipient_address

    @property
    def secret(self):
        """Gets the secret of this SecretProofTransactionBodyDTO.  # noqa: E501


        :return: The secret of this SecretProofTransactionBodyDTO.  # noqa: E501
        :rtype: str
        """
        return self._secret

    @secret.setter
    def secret(self, secret):
        """Sets the secret of this SecretProofTransactionBodyDTO.


        :param secret: The secret of this SecretProofTransactionBodyDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and secret is None:  # noqa: E501
            raise ValueError("Invalid value for `secret`, must not be `None`")  # noqa: E501

        self._secret = secret

    @property
    def hash_algorithm(self):
        """Gets the hash_algorithm of this SecretProofTransactionBodyDTO.  # noqa: E501


        :return: The hash_algorithm of this SecretProofTransactionBodyDTO.  # noqa: E501
        :rtype: LockHashAlgorithmEnum
        """
        return self._hash_algorithm

    @hash_algorithm.setter
    def hash_algorithm(self, hash_algorithm):
        """Sets the hash_algorithm of this SecretProofTransactionBodyDTO.


        :param hash_algorithm: The hash_algorithm of this SecretProofTransactionBodyDTO.  # noqa: E501
        :type: LockHashAlgorithmEnum
        """
        if self.local_vars_configuration.client_side_validation and hash_algorithm is None:  # noqa: E501
            raise ValueError("Invalid value for `hash_algorithm`, must not be `None`")  # noqa: E501

        self._hash_algorithm = hash_algorithm

    @property
    def proof(self):
        """Gets the proof of this SecretProofTransactionBodyDTO.  # noqa: E501

        Original random set of bytes.  # noqa: E501

        :return: The proof of this SecretProofTransactionBodyDTO.  # noqa: E501
        :rtype: str
        """
        return self._proof

    @proof.setter
    def proof(self, proof):
        """Sets the proof of this SecretProofTransactionBodyDTO.

        Original random set of bytes.  # noqa: E501

        :param proof: The proof of this SecretProofTransactionBodyDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and proof is None:  # noqa: E501
            raise ValueError("Invalid value for `proof`, must not be `None`")  # noqa: E501

        self._proof = proof

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SecretProofTransactionBodyDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SecretProofTransactionBodyDTO):
            return True

        return self.to_dict() != other.to_dict()
