# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest  # noqa: E501
    The version of the OpenAPI document: 1.0.3
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class SecretLockNetworkPropertiesDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'max_secret_lock_duration': 'str',
        'min_proof_size': 'str',
        'max_proof_size': 'str'
    }

    attribute_map = {
        'max_secret_lock_duration': 'maxSecretLockDuration',
        'min_proof_size': 'minProofSize',
        'max_proof_size': 'maxProofSize'
    }

    def __init__(self, max_secret_lock_duration=None, min_proof_size=None, max_proof_size=None, local_vars_configuration=None):  # noqa: E501
        """SecretLockNetworkPropertiesDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._max_secret_lock_duration = None
        self._min_proof_size = None
        self._max_proof_size = None
        self.discriminator = None

        if max_secret_lock_duration is not None:
            self.max_secret_lock_duration = max_secret_lock_duration
        if min_proof_size is not None:
            self.min_proof_size = min_proof_size
        if max_proof_size is not None:
            self.max_proof_size = max_proof_size

    @property
    def max_secret_lock_duration(self):
        """Gets the max_secret_lock_duration of this SecretLockNetworkPropertiesDTO.  # noqa: E501

        Maximum number of blocks for which a secret lock can exist.  # noqa: E501

        :return: The max_secret_lock_duration of this SecretLockNetworkPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._max_secret_lock_duration

    @max_secret_lock_duration.setter
    def max_secret_lock_duration(self, max_secret_lock_duration):
        """Sets the max_secret_lock_duration of this SecretLockNetworkPropertiesDTO.

        Maximum number of blocks for which a secret lock can exist.  # noqa: E501

        :param max_secret_lock_duration: The max_secret_lock_duration of this SecretLockNetworkPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._max_secret_lock_duration = max_secret_lock_duration

    @property
    def min_proof_size(self):
        """Gets the min_proof_size of this SecretLockNetworkPropertiesDTO.  # noqa: E501

        Minimum size of a proof in bytes.  # noqa: E501

        :return: The min_proof_size of this SecretLockNetworkPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._min_proof_size

    @min_proof_size.setter
    def min_proof_size(self, min_proof_size):
        """Sets the min_proof_size of this SecretLockNetworkPropertiesDTO.

        Minimum size of a proof in bytes.  # noqa: E501

        :param min_proof_size: The min_proof_size of this SecretLockNetworkPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._min_proof_size = min_proof_size

    @property
    def max_proof_size(self):
        """Gets the max_proof_size of this SecretLockNetworkPropertiesDTO.  # noqa: E501

        Maximum size of a proof in bytes.  # noqa: E501

        :return: The max_proof_size of this SecretLockNetworkPropertiesDTO.  # noqa: E501
        :rtype: str
        """
        return self._max_proof_size

    @max_proof_size.setter
    def max_proof_size(self, max_proof_size):
        """Sets the max_proof_size of this SecretLockNetworkPropertiesDTO.

        Maximum size of a proof in bytes.  # noqa: E501

        :param max_proof_size: The max_proof_size of this SecretLockNetworkPropertiesDTO.  # noqa: E501
        :type: str
        """

        self._max_proof_size = max_proof_size

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SecretLockNetworkPropertiesDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SecretLockNetworkPropertiesDTO):
            return True

        return self.to_dict() != other.to_dict()
