# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest  # noqa: E501
    The version of the OpenAPI document: 1.0.3
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class HashLockEntryDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'version': 'int',
        'owner_address': 'str',
        'mosaic_id': 'str',
        'amount': 'str',
        'end_height': 'str',
        'status': 'LockStatus',
        'hash': 'str'
    }

    attribute_map = {
        'version': 'version',
        'owner_address': 'ownerAddress',
        'mosaic_id': 'mosaicId',
        'amount': 'amount',
        'end_height': 'endHeight',
        'status': 'status',
        'hash': 'hash'
    }

    def __init__(self, version=None, owner_address=None, mosaic_id=None, amount=None, end_height=None, status=None, hash=None, local_vars_configuration=None):  # noqa: E501
        """HashLockEntryDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._version = None
        self._owner_address = None
        self._mosaic_id = None
        self._amount = None
        self._end_height = None
        self._status = None
        self._hash = None
        self.discriminator = None

        self.version = version
        self.owner_address = owner_address
        self.mosaic_id = mosaic_id
        self.amount = amount
        self.end_height = end_height
        self.status = status
        self.hash = hash

    @property
    def version(self):
        """Gets the version of this HashLockEntryDTO.  # noqa: E501

        The version of the state  # noqa: E501

        :return: The version of this HashLockEntryDTO.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this HashLockEntryDTO.

        The version of the state  # noqa: E501

        :param version: The version of this HashLockEntryDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and version is None:  # noqa: E501
            raise ValueError("Invalid value for `version`, must not be `None`")  # noqa: E501

        self._version = version

    @property
    def owner_address(self):
        """Gets the owner_address of this HashLockEntryDTO.  # noqa: E501

        Address encoded using a 32-character set.  # noqa: E501

        :return: The owner_address of this HashLockEntryDTO.  # noqa: E501
        :rtype: str
        """
        return self._owner_address

    @owner_address.setter
    def owner_address(self, owner_address):
        """Sets the owner_address of this HashLockEntryDTO.

        Address encoded using a 32-character set.  # noqa: E501

        :param owner_address: The owner_address of this HashLockEntryDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and owner_address is None:  # noqa: E501
            raise ValueError("Invalid value for `owner_address`, must not be `None`")  # noqa: E501

        self._owner_address = owner_address

    @property
    def mosaic_id(self):
        """Gets the mosaic_id of this HashLockEntryDTO.  # noqa: E501

        Mosaic identifier.  # noqa: E501

        :return: The mosaic_id of this HashLockEntryDTO.  # noqa: E501
        :rtype: str
        """
        return self._mosaic_id

    @mosaic_id.setter
    def mosaic_id(self, mosaic_id):
        """Sets the mosaic_id of this HashLockEntryDTO.

        Mosaic identifier.  # noqa: E501

        :param mosaic_id: The mosaic_id of this HashLockEntryDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and mosaic_id is None:  # noqa: E501
            raise ValueError("Invalid value for `mosaic_id`, must not be `None`")  # noqa: E501

        self._mosaic_id = mosaic_id

    @property
    def amount(self):
        """Gets the amount of this HashLockEntryDTO.  # noqa: E501

        Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).  # noqa: E501

        :return: The amount of this HashLockEntryDTO.  # noqa: E501
        :rtype: str
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this HashLockEntryDTO.

        Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).  # noqa: E501

        :param amount: The amount of this HashLockEntryDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and amount is None:  # noqa: E501
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def end_height(self):
        """Gets the end_height of this HashLockEntryDTO.  # noqa: E501

        Height of the blockchain.  # noqa: E501

        :return: The end_height of this HashLockEntryDTO.  # noqa: E501
        :rtype: str
        """
        return self._end_height

    @end_height.setter
    def end_height(self, end_height):
        """Sets the end_height of this HashLockEntryDTO.

        Height of the blockchain.  # noqa: E501

        :param end_height: The end_height of this HashLockEntryDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and end_height is None:  # noqa: E501
            raise ValueError("Invalid value for `end_height`, must not be `None`")  # noqa: E501

        self._end_height = end_height

    @property
    def status(self):
        """Gets the status of this HashLockEntryDTO.  # noqa: E501


        :return: The status of this HashLockEntryDTO.  # noqa: E501
        :rtype: LockStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this HashLockEntryDTO.


        :param status: The status of this HashLockEntryDTO.  # noqa: E501
        :type: LockStatus
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def hash(self):
        """Gets the hash of this HashLockEntryDTO.  # noqa: E501


        :return: The hash of this HashLockEntryDTO.  # noqa: E501
        :rtype: str
        """
        return self._hash

    @hash.setter
    def hash(self, hash):
        """Sets the hash of this HashLockEntryDTO.


        :param hash: The hash of this HashLockEntryDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and hash is None:  # noqa: E501
            raise ValueError("Invalid value for `hash`, must not be `None`")  # noqa: E501

        self._hash = hash

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HashLockEntryDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HashLockEntryDTO):
            return True

        return self.to_dict() != other.to_dict()
