import enum


class RoleId(enum.Enum):
    """Static roles that have special logic attached to them.
    See: `Symphony Roles <https://developers.symphony.com/restapi/reference/roles-object>`_
    """

    ADMINISTRATOR = "ADMINISTRATOR"
    SUPER_ADMINISTRATOR = "SUPER_ADMINISTRATOR"
    COMPLIANCE_OFFICER = "COMPLIANCE_OFFICER"
    SUPER_COMPLIANCE_OFFICER = "SUPER_COMPLIANCE_OFFICER"
    L1_SUPPORT = "L1_SUPPORT"
    L2_SUPPORT = "L2_SUPPORT"
    USER_PROVISIONING = "USER_PROVISIONING"
    CONTENT_EXPORT_SERVICE = "CONTENT_EXPORT_SERVICE"
    INDIVIDUAL = "INDIVIDUAL"
    SYMPHONY_ADMIN = "SYMPHONY_ADMIN"
    KEY_MANAGER = "KEY_MANAGER"
    CONTENT_MANAGEMENT = "CONTENT_MANAGEMENT"
    EF_POLICY_MANAGEMENT = "EF_POLICY_MANAGEMENT"
    MALWARE_SCAN_MANAGER = "MALWARE_SCAN_MANAGER"
    MALWARE_SCAN_STATE_USER = "MALWARE_SCAN_STATE_USER"
    AGENT = "AGENT"
    SCOPE_MANAGEMENT = "SCOPE_MANAGEMENT"
    AUDIT_TRAIL_MANAGEMENT = "AUDIT_TRAIL_MANAGEMENT"
    CEP_VISIBILITY_GROUP_MANAGEMENT = "CEP_VISIBILITY_GROUP_MANAGEMENT"
