"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X.   # noqa: E501

    The version of the OpenAPI document: 20.13.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from symphony.bdk.gen.api_client import ApiClient, Endpoint as _Endpoint
from symphony.bdk.gen.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from symphony.bdk.gen.pod_model.error import Error
from symphony.bdk.gen.pod_model.room_detail import RoomDetail
from symphony.bdk.gen.pod_model.stream import Stream
from symphony.bdk.gen.pod_model.stream_attachment_response import StreamAttachmentResponse
from symphony.bdk.gen.pod_model.stream_filter import StreamFilter
from symphony.bdk.gen.pod_model.stream_list import StreamList
from symphony.bdk.gen.pod_model.user_id_list import UserIdList
from symphony.bdk.gen.pod_model.v1_im_attributes import V1IMAttributes
from symphony.bdk.gen.pod_model.v1_im_detail import V1IMDetail
from symphony.bdk.gen.pod_model.v2_admin_stream_filter import V2AdminStreamFilter
from symphony.bdk.gen.pod_model.v2_admin_stream_list import V2AdminStreamList
from symphony.bdk.gen.pod_model.v2_membership_list import V2MembershipList
from symphony.bdk.gen.pod_model.v2_room_search_criteria import V2RoomSearchCriteria
from symphony.bdk.gen.pod_model.v2_stream_attributes import V2StreamAttributes
from symphony.bdk.gen.pod_model.v3_room_attributes import V3RoomAttributes
from symphony.bdk.gen.pod_model.v3_room_detail import V3RoomDetail
from symphony.bdk.gen.pod_model.v3_room_search_results import V3RoomSearchResults


class StreamsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __v1_admin_im_create_post(
            self,
            session_token,
            uid_list,
            **kwargs
        ):
            """Create a new single or multi party instant message conversation  # noqa: E501

            At least two user IDs must be provided or an error response will be sent.  The caller is not included in the members of the created chat.  Duplicate users will be included in the membership of the chat but the duplication will be silently ignored.  If there is an existing IM conversation with the same set of participants then the id of that existing stream will be returned.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.v1_admin_im_create_post(session_token, uid_list, async_req=True)
            >>> result = thread.get()

            Args:
                session_token (str): Session authentication token.
                uid_list (UserIdList): List of (integer) User IDs of participants

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Stream
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['session_token'] = \
                session_token
            kwargs['uid_list'] = \
                uid_list
            return self.call_with_http_info(**kwargs)

        self.v1_admin_im_create_post = _Endpoint(
            settings={
                'response_type': (Stream,),
                'auth': [],
                'endpoint_path': '/v1/admin/im/create',
                'operation_id': 'v1_admin_im_create_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'uid_list',
                ],
                'required': [
                    'session_token',
                    'uid_list',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'uid_list':
                        (UserIdList,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                },
                'location_map': {
                    'session_token': 'header',
                    'uid_list': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__v1_admin_im_create_post
        )

        def __v1_admin_room_id_set_active_post(
            self,
            id,
            active,
            session_token,
            **kwargs
        ):
            """Deactivate or reactivate a chatroom via AC Portal.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.v1_admin_room_id_set_active_post(id, active, session_token, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Room streamId
                active (bool):
                session_token (str): Session authentication token.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RoomDetail
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['active'] = \
                active
            kwargs['session_token'] = \
                session_token
            return self.call_with_http_info(**kwargs)

        self.v1_admin_room_id_set_active_post = _Endpoint(
            settings={
                'response_type': (RoomDetail,),
                'auth': [],
                'endpoint_path': '/v1/admin/room/{id}/setActive',
                'operation_id': 'v1_admin_room_id_set_active_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'active',
                    'session_token',
                ],
                'required': [
                    'id',
                    'active',
                    'session_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'active':
                        (bool,),
                    'session_token':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'active': 'active',
                    'session_token': 'sessionToken',
                },
                'location_map': {
                    'id': 'path',
                    'active': 'query',
                    'session_token': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__v1_admin_room_id_set_active_post
        )

        def __v1_admin_stream_id_membership_list_get(
            self,
            id,
            session_token,
            **kwargs
        ):
            """List the current members of an existing stream.  The stream can be of type IM, MIM, or ROOM  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.v1_admin_stream_id_membership_list_get(id, session_token, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): stream Id
                session_token (str): Session authentication token.

            Keyword Args:
                skip (int): Number of items to skip. Default is 0.. [optional]
                limit (int): Maximum number of items to return. Default is 100 and not to exceed 1000.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V2MembershipList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['session_token'] = \
                session_token
            return self.call_with_http_info(**kwargs)

        self.v1_admin_stream_id_membership_list_get = _Endpoint(
            settings={
                'response_type': (V2MembershipList,),
                'auth': [],
                'endpoint_path': '/v1/admin/stream/{id}/membership/list',
                'operation_id': 'v1_admin_stream_id_membership_list_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'session_token',
                    'skip',
                    'limit',
                ],
                'required': [
                    'id',
                    'session_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'session_token':
                        (str,),
                    'skip':
                        (int,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                    'session_token': 'sessionToken',
                    'skip': 'skip',
                    'limit': 'limit',
                },
                'location_map': {
                    'id': 'path',
                    'session_token': 'header',
                    'skip': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__v1_admin_stream_id_membership_list_get
        )

        def __v1_im_create_post(
            self,
            session_token,
            uid_list,
            **kwargs
        ):
            """Create a new single or multi party instant message conversation between the caller and specified users.  # noqa: E501

            At least one user ID must be provided or an error response will be sent.  The caller is implicitly included in the members of the created chat.  Duplicate users will be included in the membership of the chat but the duplication will be silently ignored.  If there is an existing IM conversation with the same set of participants then the id of that existing stream will be returned.  This method was incorrectly specified to take a query parameter in version 1.0 of this specification but now expects a JSON array of user IDs in the body of the request.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.v1_im_create_post(session_token, uid_list, async_req=True)
            >>> result = thread.get()

            Args:
                session_token (str): Session authentication token.
                uid_list (UserIdList): List of (integer) User IDs of participants

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Stream
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['session_token'] = \
                session_token
            kwargs['uid_list'] = \
                uid_list
            return self.call_with_http_info(**kwargs)

        self.v1_im_create_post = _Endpoint(
            settings={
                'response_type': (Stream,),
                'auth': [],
                'endpoint_path': '/v1/im/create',
                'operation_id': 'v1_im_create_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'uid_list',
                ],
                'required': [
                    'session_token',
                    'uid_list',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'uid_list':
                        (UserIdList,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                },
                'location_map': {
                    'session_token': 'header',
                    'uid_list': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__v1_im_create_post
        )

        def __v1_im_id_info_get(
            self,
            id,
            session_token,
            **kwargs
        ):
            """Get information about a partcular IM.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.v1_im_id_info_get(id, session_token, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): IM streamId
                session_token (str): Session authentication token.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V1IMDetail
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['session_token'] = \
                session_token
            return self.call_with_http_info(**kwargs)

        self.v1_im_id_info_get = _Endpoint(
            settings={
                'response_type': (V1IMDetail,),
                'auth': [],
                'endpoint_path': '/v1/im/{id}/info',
                'operation_id': 'v1_im_id_info_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'session_token',
                ],
                'required': [
                    'id',
                    'session_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'session_token':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'session_token': 'sessionToken',
                },
                'location_map': {
                    'id': 'path',
                    'session_token': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__v1_im_id_info_get
        )

        def __v1_im_id_update_post(
            self,
            id,
            session_token,
            payload,
            **kwargs
        ):
            """Update the attributes of an existing IM.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.v1_im_id_update_post(id, session_token, payload, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): IM streamID
                session_token (str): Session authentication token.
                payload (V1IMAttributes):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V1IMDetail
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['session_token'] = \
                session_token
            kwargs['payload'] = \
                payload
            return self.call_with_http_info(**kwargs)

        self.v1_im_id_update_post = _Endpoint(
            settings={
                'response_type': (V1IMDetail,),
                'auth': [],
                'endpoint_path': '/v1/im/{id}/update',
                'operation_id': 'v1_im_id_update_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'session_token',
                    'payload',
                ],
                'required': [
                    'id',
                    'session_token',
                    'payload',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'session_token':
                        (str,),
                    'payload':
                        (V1IMAttributes,),
                },
                'attribute_map': {
                    'id': 'id',
                    'session_token': 'sessionToken',
                },
                'location_map': {
                    'id': 'path',
                    'session_token': 'header',
                    'payload': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__v1_im_id_update_post
        )

        def __v1_room_id_set_active_post(
            self,
            id,
            active,
            session_token,
            **kwargs
        ):
            """Deactivate or reactivate a chatroom. At creation, a new chatroom is active.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.v1_room_id_set_active_post(id, active, session_token, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Room streamId
                active (bool):
                session_token (str): Session authentication token.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RoomDetail
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['active'] = \
                active
            kwargs['session_token'] = \
                session_token
            return self.call_with_http_info(**kwargs)

        self.v1_room_id_set_active_post = _Endpoint(
            settings={
                'response_type': (RoomDetail,),
                'auth': [],
                'endpoint_path': '/v1/room/{id}/setActive',
                'operation_id': 'v1_room_id_set_active_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'active',
                    'session_token',
                ],
                'required': [
                    'id',
                    'active',
                    'session_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'active':
                        (bool,),
                    'session_token':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'active': 'active',
                    'session_token': 'sessionToken',
                },
                'location_map': {
                    'id': 'path',
                    'active': 'query',
                    'session_token': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__v1_room_id_set_active_post
        )

        def __v1_streams_list_post(
            self,
            session_token,
            **kwargs
        ):
            """Retrieve a list of all streams of which the requesting user is a member, sorted by creation date (ascending).   # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.v1_streams_list_post(session_token, async_req=True)
            >>> result = thread.get()

            Args:
                session_token (str): Session authentication token.

            Keyword Args:
                skip (int): No. of results to skip. . [optional]
                limit (int): Max no. of results to return. If no value is provided, 50 is the default. . [optional]
                filter (StreamFilter): Stream filtering criteria.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StreamList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['session_token'] = \
                session_token
            return self.call_with_http_info(**kwargs)

        self.v1_streams_list_post = _Endpoint(
            settings={
                'response_type': (StreamList,),
                'auth': [],
                'endpoint_path': '/v1/streams/list',
                'operation_id': 'v1_streams_list_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'skip',
                    'limit',
                    'filter',
                ],
                'required': [
                    'session_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'skip':
                        (int,),
                    'limit':
                        (int,),
                    'filter':
                        (StreamFilter,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'skip': 'skip',
                    'limit': 'limit',
                },
                'location_map': {
                    'session_token': 'header',
                    'skip': 'query',
                    'limit': 'query',
                    'filter': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__v1_streams_list_post
        )

        def __v1_streams_sid_attachments_get(
            self,
            sid,
            session_token,
            **kwargs
        ):
            """Get attachments in a particular stream.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.v1_streams_sid_attachments_get(sid, session_token, async_req=True)
            >>> result = thread.get()

            Args:
                sid (str): Stream Id
                session_token (str): Session authentication token.

            Keyword Args:
                since (int): Timestamp of first required attachment. This is a long integer value representing milliseconds since Jan 1 1970 . [optional]
                to (int): Timestamp of last required attachment. This is a long integer value representing milliseconds since Jan 1 1970 . [optional]
                limit (int): Maximum number of attachments to return. Default is 50. Must be a positive integer and must not exceed 100.. [optional]
                sort_dir (str): Attachment date sort direction : ASC or DESC (default to ASC) . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StreamAttachmentResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['sid'] = \
                sid
            kwargs['session_token'] = \
                session_token
            return self.call_with_http_info(**kwargs)

        self.v1_streams_sid_attachments_get = _Endpoint(
            settings={
                'response_type': (StreamAttachmentResponse,),
                'auth': [],
                'endpoint_path': '/v1/streams/{sid}/attachments',
                'operation_id': 'v1_streams_sid_attachments_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'sid',
                    'session_token',
                    'since',
                    'to',
                    'limit',
                    'sort_dir',
                ],
                'required': [
                    'sid',
                    'session_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sid':
                        (str,),
                    'session_token':
                        (str,),
                    'since':
                        (int,),
                    'to':
                        (int,),
                    'limit':
                        (int,),
                    'sort_dir':
                        (str,),
                },
                'attribute_map': {
                    'sid': 'sid',
                    'session_token': 'sessionToken',
                    'since': 'since',
                    'to': 'to',
                    'limit': 'limit',
                    'sort_dir': 'sortDir',
                },
                'location_map': {
                    'sid': 'path',
                    'session_token': 'header',
                    'since': 'query',
                    'to': 'query',
                    'limit': 'query',
                    'sort_dir': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__v1_streams_sid_attachments_get
        )

        def __v2_admin_streams_list_post(
            self,
            session_token,
            **kwargs
        ):
            """Retrieve all the streams across the enterprise where the membership of the stream has been modified between a given time range   # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.v2_admin_streams_list_post(session_token, async_req=True)
            >>> result = thread.get()

            Args:
                session_token (str): Session authentication token.

            Keyword Args:
                skip (int): Number of items to skip. Default is 0. . [optional]
                limit (int): Maximum number of items to return. Default is 50.  This value cannot exceed 100. . [optional]
                filter (V2AdminStreamFilter): Stream filtering criteria.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V2AdminStreamList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['session_token'] = \
                session_token
            return self.call_with_http_info(**kwargs)

        self.v2_admin_streams_list_post = _Endpoint(
            settings={
                'response_type': (V2AdminStreamList,),
                'auth': [],
                'endpoint_path': '/v2/admin/streams/list',
                'operation_id': 'v2_admin_streams_list_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'skip',
                    'limit',
                    'filter',
                ],
                'required': [
                    'session_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'skip':
                        (int,),
                    'limit':
                        (int,),
                    'filter':
                        (V2AdminStreamFilter,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'skip': 'skip',
                    'limit': 'limit',
                },
                'location_map': {
                    'session_token': 'header',
                    'skip': 'query',
                    'limit': 'query',
                    'filter': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__v2_admin_streams_list_post
        )

        def __v2_streams_sid_info_get(
            self,
            sid,
            session_token,
            **kwargs
        ):
            """Get information about a partcular stream.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.v2_streams_sid_info_get(sid, session_token, async_req=True)
            >>> result = thread.get()

            Args:
                sid (str): Stream Id
                session_token (str): Session authentication token.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V2StreamAttributes
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['sid'] = \
                sid
            kwargs['session_token'] = \
                session_token
            return self.call_with_http_info(**kwargs)

        self.v2_streams_sid_info_get = _Endpoint(
            settings={
                'response_type': (V2StreamAttributes,),
                'auth': [],
                'endpoint_path': '/v2/streams/{sid}/info',
                'operation_id': 'v2_streams_sid_info_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'sid',
                    'session_token',
                ],
                'required': [
                    'sid',
                    'session_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'sid':
                        (str,),
                    'session_token':
                        (str,),
                },
                'attribute_map': {
                    'sid': 'sid',
                    'session_token': 'sessionToken',
                },
                'location_map': {
                    'sid': 'path',
                    'session_token': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__v2_streams_sid_info_get
        )

        def __v3_room_create_post(
            self,
            session_token,
            payload,
            **kwargs
        ):
            """Create a new chatroom.  # noqa: E501

            Create a new chatroom.  If no  attributes are specified, the room is created as a private chatroom.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.v3_room_create_post(session_token, payload, async_req=True)
            >>> result = thread.get()

            Args:
                session_token (str): Session authentication token.
                payload (V3RoomAttributes):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V3RoomDetail
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['session_token'] = \
                session_token
            kwargs['payload'] = \
                payload
            return self.call_with_http_info(**kwargs)

        self.v3_room_create_post = _Endpoint(
            settings={
                'response_type': (V3RoomDetail,),
                'auth': [],
                'endpoint_path': '/v3/room/create',
                'operation_id': 'v3_room_create_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'payload',
                ],
                'required': [
                    'session_token',
                    'payload',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'payload':
                        (V3RoomAttributes,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                },
                'location_map': {
                    'session_token': 'header',
                    'payload': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__v3_room_create_post
        )

        def __v3_room_id_info_get(
            self,
            id,
            session_token,
            **kwargs
        ):
            """Get information about a partcular chatroom.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.v3_room_id_info_get(id, session_token, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Room streamId
                session_token (str): Session authentication token.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V3RoomDetail
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['session_token'] = \
                session_token
            return self.call_with_http_info(**kwargs)

        self.v3_room_id_info_get = _Endpoint(
            settings={
                'response_type': (V3RoomDetail,),
                'auth': [],
                'endpoint_path': '/v3/room/{id}/info',
                'operation_id': 'v3_room_id_info_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'session_token',
                ],
                'required': [
                    'id',
                    'session_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'session_token':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'session_token': 'sessionToken',
                },
                'location_map': {
                    'id': 'path',
                    'session_token': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__v3_room_id_info_get
        )

        def __v3_room_id_update_post(
            self,
            id,
            session_token,
            payload,
            **kwargs
        ):
            """Update the attributes of an existing chatroom.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.v3_room_id_update_post(id, session_token, payload, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Room streamId
                session_token (str): Session authentication token.
                payload (V3RoomAttributes):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V3RoomDetail
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['session_token'] = \
                session_token
            kwargs['payload'] = \
                payload
            return self.call_with_http_info(**kwargs)

        self.v3_room_id_update_post = _Endpoint(
            settings={
                'response_type': (V3RoomDetail,),
                'auth': [],
                'endpoint_path': '/v3/room/{id}/update',
                'operation_id': 'v3_room_id_update_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'session_token',
                    'payload',
                ],
                'required': [
                    'id',
                    'session_token',
                    'payload',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'session_token':
                        (str,),
                    'payload':
                        (V3RoomAttributes,),
                },
                'attribute_map': {
                    'id': 'id',
                    'session_token': 'sessionToken',
                },
                'location_map': {
                    'id': 'path',
                    'session_token': 'header',
                    'payload': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__v3_room_id_update_post
        )

        def __v3_room_search_post(
            self,
            session_token,
            query,
            **kwargs
        ):
            """Search rooms according to the specified criteria.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = pod_api.v3_room_search_post(session_token, query, async_req=True)
            >>> result = thread.get()

            Args:
                session_token (str): Session authentication token.
                query (V2RoomSearchCriteria): The search query object.

            Keyword Args:
                skip (int): No. of results to skip. . [optional]
                limit (int): Max no. of results to return. If no value is provided, 50 is the default. Must be a positive integer and must not exceed 100 . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V3RoomSearchResults
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['session_token'] = \
                session_token
            kwargs['query'] = \
                query
            return self.call_with_http_info(**kwargs)

        self.v3_room_search_post = _Endpoint(
            settings={
                'response_type': (V3RoomSearchResults,),
                'auth': [],
                'endpoint_path': '/v3/room/search',
                'operation_id': 'v3_room_search_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'query',
                    'skip',
                    'limit',
                ],
                'required': [
                    'session_token',
                    'query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'query':
                        (V2RoomSearchCriteria,),
                    'skip':
                        (int,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'skip': 'skip',
                    'limit': 'limit',
                },
                'location_map': {
                    'session_token': 'header',
                    'query': 'body',
                    'skip': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__v3_room_search_post
        )
