# coding: utf-8

"""
    Agent API

    This document refers to Symphony API calls to send and receive messages and content. They need the on-premise Agent installed to perform decryption/encryption of content.  - sessionToken and keyManagerToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have sent no message to any stream even if a request to some subset of the requested streams would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. - MessageML is a markup language for messages. See reference here: https://rest-api.symphony.com/docs/messagemlv2 - **Real Time Events**: The following events are returned when reading from a real time messages and events stream (\"datafeed\"). These events will be returned for datafeeds created with the v5 endpoints. To know more about the endpoints, refer to Create Messages/Events Stream and Read Messages/Events Stream. Unless otherwise specified, all events were added in 1.46. 

    The version of the OpenAPI document: 25.8.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictStr
from typing import Optional
from typing_extensions import Annotated
from symphony.bdk.gen.agent_model.v1_health_check_response import V1HealthCheckResponse
from symphony.bdk.gen.agent_model.v2_health_check_response import V2HealthCheckResponse
from symphony.bdk.gen.agent_model.v3_health import V3Health

from symphony.bdk.gen.api_client import ApiClient, RequestSerialized
from symphony.bdk.gen.api_response import ApiResponse
from symphony.bdk.gen.rest import RESTResponseType


class SystemApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def v1_health_check_get(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V1HealthCheckResponse:
        """(Deprecated) Checks the health of the Agent.

        Used to validate the configuration of the agent. Makes a request to the HealthCheck on the Symphony cloud. Makes a request to the HealthCheck on the Key Manager service. 

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /v1/HealthCheck is deprecated.", DeprecationWarning)

        _param = self._v1_health_check_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1HealthCheckResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v1_health_check_get_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V1HealthCheckResponse]:
        """(Deprecated) Checks the health of the Agent.

        Used to validate the configuration of the agent. Makes a request to the HealthCheck on the Symphony cloud. Makes a request to the HealthCheck on the Key Manager service. 

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /v1/HealthCheck is deprecated.", DeprecationWarning)

        _param = self._v1_health_check_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1HealthCheckResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v1_health_check_get_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Checks the health of the Agent.

        Used to validate the configuration of the agent. Makes a request to the HealthCheck on the Symphony cloud. Makes a request to the HealthCheck on the Key Manager service. 

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /v1/HealthCheck is deprecated.", DeprecationWarning)

        _param = self._v1_health_check_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V1HealthCheckResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_health_check_get_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/HealthCheck',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v2_health_check_get(
        self,
        show_firehose_errors: Annotated[Optional[StrictBool], Field(description="[deprecated] Firehose Service has never been deployed. However, this request parameter has been kept here for specs backward compatibility. ")] = None,
        fail_on_pod_connectivity: Annotated[Optional[StrictBool], Field(description="Defines the HealthCheck status code response whenever the Pod connectivity fails. When set to \"true\", in case of Pod connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". ")] = None,
        fail_on_key_manager_connectivity: Annotated[Optional[StrictBool], Field(description="Defines the HealthCheck status code response whenever the Key Manager connectivity fails. When set to \"true\", in case of Key Manager connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". ")] = None,
        fail_on_agent_service_user: Annotated[Optional[StrictBool], Field(description="Defines the HealthCheck status code response whenever the Agent Service User connectivity fails. When set to \"true\", in case of Agent Service connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". ")] = None,
        fail_on_ce_service_user: Annotated[Optional[StrictBool], Field(description="This query parameter is not used as the ceservice is deprecated and it is kept for backward compatibility. Default value is \"false\" but it will not change the response status code if set to true. ")] = None,
        fail_on_encrypt_decrypt_success: Annotated[Optional[StrictBool], Field(description="Defines the status code response whenever the Encrypt/Decrypt message check fails. When set to \"true\", in case of Encrypt or Decrypt failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". ")] = None,
        fail_on_any: Annotated[Optional[StrictBool], Field(description="Defines the status code response whenever at least one of the checks fails. When set to \"true\", in case of any failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". ")] = None,
        fail_on_datafeed_connectivity: Annotated[Optional[StrictBool], Field(description="Defines the HealthCheck status code response whenever the Datafeed2 connectivity fails. When set to \"true\", in case of Datafeed connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". ")] = None,
        session_token: Annotated[Optional[StrictStr], Field(description="Session authentication token.")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2HealthCheckResponse:
        """(Deprecated) Checks the health of the Agent.

        [deprecated] : This endpoint is deprecated. The health check endpoint to be used instead is '/v3/health/extended'. Unlike this deprecated endpoint, the extended health check endpoint provides status on external component such as pod, key manager, ceservice, agentservice... 

        :param show_firehose_errors: [deprecated] Firehose Service has never been deployed. However, this request parameter has been kept here for specs backward compatibility. 
        :type show_firehose_errors: bool
        :param fail_on_pod_connectivity: Defines the HealthCheck status code response whenever the Pod connectivity fails. When set to \"true\", in case of Pod connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". 
        :type fail_on_pod_connectivity: bool
        :param fail_on_key_manager_connectivity: Defines the HealthCheck status code response whenever the Key Manager connectivity fails. When set to \"true\", in case of Key Manager connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". 
        :type fail_on_key_manager_connectivity: bool
        :param fail_on_agent_service_user: Defines the HealthCheck status code response whenever the Agent Service User connectivity fails. When set to \"true\", in case of Agent Service connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". 
        :type fail_on_agent_service_user: bool
        :param fail_on_ce_service_user: This query parameter is not used as the ceservice is deprecated and it is kept for backward compatibility. Default value is \"false\" but it will not change the response status code if set to true. 
        :type fail_on_ce_service_user: bool
        :param fail_on_encrypt_decrypt_success: Defines the status code response whenever the Encrypt/Decrypt message check fails. When set to \"true\", in case of Encrypt or Decrypt failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". 
        :type fail_on_encrypt_decrypt_success: bool
        :param fail_on_any: Defines the status code response whenever at least one of the checks fails. When set to \"true\", in case of any failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". 
        :type fail_on_any: bool
        :param fail_on_datafeed_connectivity: Defines the HealthCheck status code response whenever the Datafeed2 connectivity fails. When set to \"true\", in case of Datafeed connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". 
        :type fail_on_datafeed_connectivity: bool
        :param session_token: Session authentication token.
        :type session_token: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /v2/HealthCheck is deprecated.", DeprecationWarning)

        _param = self._v2_health_check_get_serialize(
            show_firehose_errors=show_firehose_errors,
            fail_on_pod_connectivity=fail_on_pod_connectivity,
            fail_on_key_manager_connectivity=fail_on_key_manager_connectivity,
            fail_on_agent_service_user=fail_on_agent_service_user,
            fail_on_ce_service_user=fail_on_ce_service_user,
            fail_on_encrypt_decrypt_success=fail_on_encrypt_decrypt_success,
            fail_on_any=fail_on_any,
            fail_on_datafeed_connectivity=fail_on_datafeed_connectivity,
            session_token=session_token,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2HealthCheckResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v2_health_check_get_with_http_info(
        self,
        show_firehose_errors: Annotated[Optional[StrictBool], Field(description="[deprecated] Firehose Service has never been deployed. However, this request parameter has been kept here for specs backward compatibility. ")] = None,
        fail_on_pod_connectivity: Annotated[Optional[StrictBool], Field(description="Defines the HealthCheck status code response whenever the Pod connectivity fails. When set to \"true\", in case of Pod connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". ")] = None,
        fail_on_key_manager_connectivity: Annotated[Optional[StrictBool], Field(description="Defines the HealthCheck status code response whenever the Key Manager connectivity fails. When set to \"true\", in case of Key Manager connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". ")] = None,
        fail_on_agent_service_user: Annotated[Optional[StrictBool], Field(description="Defines the HealthCheck status code response whenever the Agent Service User connectivity fails. When set to \"true\", in case of Agent Service connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". ")] = None,
        fail_on_ce_service_user: Annotated[Optional[StrictBool], Field(description="This query parameter is not used as the ceservice is deprecated and it is kept for backward compatibility. Default value is \"false\" but it will not change the response status code if set to true. ")] = None,
        fail_on_encrypt_decrypt_success: Annotated[Optional[StrictBool], Field(description="Defines the status code response whenever the Encrypt/Decrypt message check fails. When set to \"true\", in case of Encrypt or Decrypt failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". ")] = None,
        fail_on_any: Annotated[Optional[StrictBool], Field(description="Defines the status code response whenever at least one of the checks fails. When set to \"true\", in case of any failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". ")] = None,
        fail_on_datafeed_connectivity: Annotated[Optional[StrictBool], Field(description="Defines the HealthCheck status code response whenever the Datafeed2 connectivity fails. When set to \"true\", in case of Datafeed connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". ")] = None,
        session_token: Annotated[Optional[StrictStr], Field(description="Session authentication token.")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2HealthCheckResponse]:
        """(Deprecated) Checks the health of the Agent.

        [deprecated] : This endpoint is deprecated. The health check endpoint to be used instead is '/v3/health/extended'. Unlike this deprecated endpoint, the extended health check endpoint provides status on external component such as pod, key manager, ceservice, agentservice... 

        :param show_firehose_errors: [deprecated] Firehose Service has never been deployed. However, this request parameter has been kept here for specs backward compatibility. 
        :type show_firehose_errors: bool
        :param fail_on_pod_connectivity: Defines the HealthCheck status code response whenever the Pod connectivity fails. When set to \"true\", in case of Pod connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". 
        :type fail_on_pod_connectivity: bool
        :param fail_on_key_manager_connectivity: Defines the HealthCheck status code response whenever the Key Manager connectivity fails. When set to \"true\", in case of Key Manager connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". 
        :type fail_on_key_manager_connectivity: bool
        :param fail_on_agent_service_user: Defines the HealthCheck status code response whenever the Agent Service User connectivity fails. When set to \"true\", in case of Agent Service connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". 
        :type fail_on_agent_service_user: bool
        :param fail_on_ce_service_user: This query parameter is not used as the ceservice is deprecated and it is kept for backward compatibility. Default value is \"false\" but it will not change the response status code if set to true. 
        :type fail_on_ce_service_user: bool
        :param fail_on_encrypt_decrypt_success: Defines the status code response whenever the Encrypt/Decrypt message check fails. When set to \"true\", in case of Encrypt or Decrypt failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". 
        :type fail_on_encrypt_decrypt_success: bool
        :param fail_on_any: Defines the status code response whenever at least one of the checks fails. When set to \"true\", in case of any failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". 
        :type fail_on_any: bool
        :param fail_on_datafeed_connectivity: Defines the HealthCheck status code response whenever the Datafeed2 connectivity fails. When set to \"true\", in case of Datafeed connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". 
        :type fail_on_datafeed_connectivity: bool
        :param session_token: Session authentication token.
        :type session_token: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /v2/HealthCheck is deprecated.", DeprecationWarning)

        _param = self._v2_health_check_get_serialize(
            show_firehose_errors=show_firehose_errors,
            fail_on_pod_connectivity=fail_on_pod_connectivity,
            fail_on_key_manager_connectivity=fail_on_key_manager_connectivity,
            fail_on_agent_service_user=fail_on_agent_service_user,
            fail_on_ce_service_user=fail_on_ce_service_user,
            fail_on_encrypt_decrypt_success=fail_on_encrypt_decrypt_success,
            fail_on_any=fail_on_any,
            fail_on_datafeed_connectivity=fail_on_datafeed_connectivity,
            session_token=session_token,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2HealthCheckResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v2_health_check_get_without_preload_content(
        self,
        show_firehose_errors: Annotated[Optional[StrictBool], Field(description="[deprecated] Firehose Service has never been deployed. However, this request parameter has been kept here for specs backward compatibility. ")] = None,
        fail_on_pod_connectivity: Annotated[Optional[StrictBool], Field(description="Defines the HealthCheck status code response whenever the Pod connectivity fails. When set to \"true\", in case of Pod connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". ")] = None,
        fail_on_key_manager_connectivity: Annotated[Optional[StrictBool], Field(description="Defines the HealthCheck status code response whenever the Key Manager connectivity fails. When set to \"true\", in case of Key Manager connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". ")] = None,
        fail_on_agent_service_user: Annotated[Optional[StrictBool], Field(description="Defines the HealthCheck status code response whenever the Agent Service User connectivity fails. When set to \"true\", in case of Agent Service connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". ")] = None,
        fail_on_ce_service_user: Annotated[Optional[StrictBool], Field(description="This query parameter is not used as the ceservice is deprecated and it is kept for backward compatibility. Default value is \"false\" but it will not change the response status code if set to true. ")] = None,
        fail_on_encrypt_decrypt_success: Annotated[Optional[StrictBool], Field(description="Defines the status code response whenever the Encrypt/Decrypt message check fails. When set to \"true\", in case of Encrypt or Decrypt failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". ")] = None,
        fail_on_any: Annotated[Optional[StrictBool], Field(description="Defines the status code response whenever at least one of the checks fails. When set to \"true\", in case of any failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". ")] = None,
        fail_on_datafeed_connectivity: Annotated[Optional[StrictBool], Field(description="Defines the HealthCheck status code response whenever the Datafeed2 connectivity fails. When set to \"true\", in case of Datafeed connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". ")] = None,
        session_token: Annotated[Optional[StrictStr], Field(description="Session authentication token.")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Checks the health of the Agent.

        [deprecated] : This endpoint is deprecated. The health check endpoint to be used instead is '/v3/health/extended'. Unlike this deprecated endpoint, the extended health check endpoint provides status on external component such as pod, key manager, ceservice, agentservice... 

        :param show_firehose_errors: [deprecated] Firehose Service has never been deployed. However, this request parameter has been kept here for specs backward compatibility. 
        :type show_firehose_errors: bool
        :param fail_on_pod_connectivity: Defines the HealthCheck status code response whenever the Pod connectivity fails. When set to \"true\", in case of Pod connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". 
        :type fail_on_pod_connectivity: bool
        :param fail_on_key_manager_connectivity: Defines the HealthCheck status code response whenever the Key Manager connectivity fails. When set to \"true\", in case of Key Manager connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". 
        :type fail_on_key_manager_connectivity: bool
        :param fail_on_agent_service_user: Defines the HealthCheck status code response whenever the Agent Service User connectivity fails. When set to \"true\", in case of Agent Service connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". 
        :type fail_on_agent_service_user: bool
        :param fail_on_ce_service_user: This query parameter is not used as the ceservice is deprecated and it is kept for backward compatibility. Default value is \"false\" but it will not change the response status code if set to true. 
        :type fail_on_ce_service_user: bool
        :param fail_on_encrypt_decrypt_success: Defines the status code response whenever the Encrypt/Decrypt message check fails. When set to \"true\", in case of Encrypt or Decrypt failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". 
        :type fail_on_encrypt_decrypt_success: bool
        :param fail_on_any: Defines the status code response whenever at least one of the checks fails. When set to \"true\", in case of any failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". 
        :type fail_on_any: bool
        :param fail_on_datafeed_connectivity: Defines the HealthCheck status code response whenever the Datafeed2 connectivity fails. When set to \"true\", in case of Datafeed connectivity failure, the response status code will be 503; otherwise, it will be 200. Default value is \"false\". 
        :type fail_on_datafeed_connectivity: bool
        :param session_token: Session authentication token.
        :type session_token: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /v2/HealthCheck is deprecated.", DeprecationWarning)

        _param = self._v2_health_check_get_serialize(
            show_firehose_errors=show_firehose_errors,
            fail_on_pod_connectivity=fail_on_pod_connectivity,
            fail_on_key_manager_connectivity=fail_on_key_manager_connectivity,
            fail_on_agent_service_user=fail_on_agent_service_user,
            fail_on_ce_service_user=fail_on_ce_service_user,
            fail_on_encrypt_decrypt_success=fail_on_encrypt_decrypt_success,
            fail_on_any=fail_on_any,
            fail_on_datafeed_connectivity=fail_on_datafeed_connectivity,
            session_token=session_token,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2HealthCheckResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v2_health_check_get_serialize(
        self,
        show_firehose_errors,
        fail_on_pod_connectivity,
        fail_on_key_manager_connectivity,
        fail_on_agent_service_user,
        fail_on_ce_service_user,
        fail_on_encrypt_decrypt_success,
        fail_on_any,
        fail_on_datafeed_connectivity,
        session_token,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if show_firehose_errors is not None:
            
            _query_params.append(('showFirehoseErrors', show_firehose_errors))
            
        if fail_on_pod_connectivity is not None:
            
            _query_params.append(('failOnPodConnectivity', fail_on_pod_connectivity))
            
        if fail_on_key_manager_connectivity is not None:
            
            _query_params.append(('failOnKeyManagerConnectivity', fail_on_key_manager_connectivity))
            
        if fail_on_agent_service_user is not None:
            
            _query_params.append(('failOnAgentServiceUser', fail_on_agent_service_user))
            
        if fail_on_ce_service_user is not None:
            
            _query_params.append(('failOnCeServiceUser', fail_on_ce_service_user))
            
        if fail_on_encrypt_decrypt_success is not None:
            
            _query_params.append(('failOnEncryptDecryptSuccess', fail_on_encrypt_decrypt_success))
            
        if fail_on_any is not None:
            
            _query_params.append(('failOnAny', fail_on_any))
            
        if fail_on_datafeed_connectivity is not None:
            
            _query_params.append(('failOnDatafeedConnectivity', fail_on_datafeed_connectivity))
            
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v2/HealthCheck',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v3_extended_health(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V3Health:
        """Checks health status of services and users

        _Available on Agent 2.57.0 and above._  Returns the connectivity status of the Agent services (**pod**, **key manager** and **datafeed**) as well as users connectivity (**agentservice** and **ceservice**).  The global status will be set to `DOWN` if at least one of the sub-status is also `DOWN`. 

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v3_extended_health_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V3Health",
            '503': "V3Health",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v3_extended_health_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V3Health]:
        """Checks health status of services and users

        _Available on Agent 2.57.0 and above._  Returns the connectivity status of the Agent services (**pod**, **key manager** and **datafeed**) as well as users connectivity (**agentservice** and **ceservice**).  The global status will be set to `DOWN` if at least one of the sub-status is also `DOWN`. 

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v3_extended_health_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V3Health",
            '503': "V3Health",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v3_extended_health_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Checks health status of services and users

        _Available on Agent 2.57.0 and above._  Returns the connectivity status of the Agent services (**pod**, **key manager** and **datafeed**) as well as users connectivity (**agentservice** and **ceservice**).  The global status will be set to `DOWN` if at least one of the sub-status is also `DOWN`. 

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v3_extended_health_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V3Health",
            '503': "V3Health",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v3_extended_health_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v3/health/extended',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v3_health(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V3Health:
        """Checks health status

        _Available on Agent 2.57.0 and above._  Returns the connectivity status of your Agent server. If your Agent server is started and running, the status value will be `UP` 

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v3_health_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V3Health",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v3_health_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V3Health]:
        """Checks health status

        _Available on Agent 2.57.0 and above._  Returns the connectivity status of your Agent server. If your Agent server is started and running, the status value will be `UP` 

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v3_health_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V3Health",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v3_health_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Checks health status

        _Available on Agent 2.57.0 and above._  Returns the connectivity status of your Agent server. If your Agent server is started and running, the status value will be `UP` 

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v3_health_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V3Health",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v3_health_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v3/health',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


