# coding: utf-8

"""
    Agent API

    This document refers to Symphony API calls to send and receive messages and content. They need the on-premise Agent installed to perform decryption/encryption of content.  - sessionToken and keyManagerToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have sent no message to any stream even if a request to some subset of the requested streams would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. - MessageML is a markup language for messages. See reference here: https://rest-api.symphony.com/docs/messagemlv2 - **Real Time Events**: The following events are returned when reading from a real time messages and events stream (\"datafeed\"). These events will be returned for datafeeds created with the v5 endpoints. To know more about the endpoints, refer to Create Messages/Events Stream and Read Messages/Events Stream. Unless otherwise specified, all events were added in 1.46. 

    The version of the OpenAPI document: 25.8.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.agent_model.v1_dlp_content_type import V1DLPContentType
from symphony.bdk.gen.agent_model.v1_dlp_matched_policy import V1DLPMatchedPolicy
from symphony.bdk.gen.agent_model.v1_dlp_outcome import V1DLPOutcome
from typing import Optional, Set
from typing_extensions import Self

class V1DLPViolation(BaseModel):
    """
    A representation of a violation due to a message sent by a user of Symphony
    """ # noqa: E501
    enforcement_event_id: Optional[StrictStr] = Field(default=None, description="Enforcement event ID. Unique ID that identifies this enforcement.", alias="enforcementEventID")
    entity_id: Optional[StrictStr] = Field(default=None, description="Entity ID is the content Id of the violation, for example, for messages, its the Id of the message", alias="entityID")
    create_time: Optional[StrictInt] = Field(default=None, description="Timestamp of the violation in milliseconds since Jan 1 1970", alias="createTime")
    last_modified: Optional[StrictInt] = Field(default=None, description="Timestamp of the last modification of violation in milliseconds since Jan 1 1970", alias="lastModified")
    requester_id: Optional[StrictInt] = Field(default=None, description="Id of the requester responsible for the message/stream/signal", alias="requesterId")
    matched_policies: Optional[List[V1DLPMatchedPolicy]] = Field(default=None, description="List of policies that matched the violation.", alias="matchedPolicies")
    action: Optional[StrictStr] = Field(default=None, description="action taken such as BLOCK or WARN.  See outcome for a more detailed description of the outcome this action.")
    outcome: Optional[V1DLPOutcome] = None
    content_type: Optional[V1DLPContentType] = Field(default=None, alias="contentType")
    version: Optional[StrictStr] = Field(default=None, description="Version of application which processed the message and produced this violation.")
    ignore_dl_pwarning: Optional[StrictBool] = Field(default=None, description="Did the user chose to ignore DLP warning that was presented?", alias="ignoreDLPwarning")
    __properties: ClassVar[List[str]] = ["enforcementEventID", "entityID", "createTime", "lastModified", "requesterId", "matchedPolicies", "action", "outcome", "contentType", "version", "ignoreDLPwarning"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V1DLPViolation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in matched_policies (list)
        _items = []
        if self.matched_policies:
            for _item_matched_policies in self.matched_policies:
                if _item_matched_policies:
                    _items.append(_item_matched_policies.to_dict())
            _dict['matchedPolicies'] = _items
        # override the default output from pydantic by calling `to_dict()` of outcome
        if self.outcome:
            _dict['outcome'] = self.outcome.to_dict()
        # override the default output from pydantic by calling `to_dict()` of content_type
        if self.content_type:
            _dict['contentType'] = self.content_type.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V1DLPViolation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "enforcementEventID": obj.get("enforcementEventID"),
            "entityID": obj.get("entityID"),
            "createTime": obj.get("createTime"),
            "lastModified": obj.get("lastModified"),
            "requesterId": obj.get("requesterId"),
            "matchedPolicies": [V1DLPMatchedPolicy.from_dict(_item) for _item in obj["matchedPolicies"]] if obj.get("matchedPolicies") is not None else None,
            "action": obj.get("action"),
            "outcome": V1DLPOutcome.from_dict(obj["outcome"]) if obj.get("outcome") is not None else None,
            "contentType": V1DLPContentType.from_dict(obj["contentType"]) if obj.get("contentType") is not None else None,
            "version": obj.get("version"),
            "ignoreDLPwarning": obj.get("ignoreDLPwarning")
        })
        return _obj


